/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.rest.controllers;

import com.netflix.conductor.core.events.queue.DefaultEventQueueProcessor;
import com.netflix.conductor.model.TaskModel;
import io.swagger.v3.oas.annotations.Operation;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/queue"})
public class QueueAdminResource {
    private final DefaultEventQueueProcessor defaultEventQueueProcessor;

    public QueueAdminResource(DefaultEventQueueProcessor defaultEventQueueProcessor) {
        this.defaultEventQueueProcessor = defaultEventQueueProcessor;
    }

    @Operation(summary="Get the queue length")
    @GetMapping(value={"/size"})
    public Map<String, Long> size() {
        return this.defaultEventQueueProcessor.size();
    }

    @Operation(summary="Get Queue Names")
    @GetMapping(value={"/"})
    public Map<TaskModel.Status, String> names() {
        return this.defaultEventQueueProcessor.queues();
    }

    @Operation(summary="Publish a message in queue to mark a wait task as completed.")
    @PostMapping(value={"/update/{workflowId}/{taskRefName}/{status}"})
    public void update(@PathVariable(value="workflowId") String workflowId, @PathVariable(value="taskRefName") String taskRefName, @PathVariable(value="status") TaskModel.Status status, @RequestBody Map<String, Object> output) throws Exception {
        this.defaultEventQueueProcessor.updateByTaskRefName(workflowId, taskRefName, output, status);
    }

    @Operation(summary="Publish a message in queue to mark a wait task (by taskId) as completed.")
    @PostMapping(value={"/update/{workflowId}/task/{taskId}/{status}"})
    public void updateByTaskId(@PathVariable(value="workflowId") String workflowId, @PathVariable(value="taskId") String taskId, @PathVariable(value="status") TaskModel.Status status, @RequestBody Map<String, Object> output) throws Exception {
        this.defaultEventQueueProcessor.updateByTaskId(workflowId, taskId, output, status);
    }
}

