/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.utils;

import com.netflix.curator.CuratorZookeeperClient;
import com.netflix.curator.utils.ZKPaths;
import java.util.concurrent.atomic.AtomicReference;

public class EnsurePath {
    private final String path;
    private final AtomicReference<Helper> helper = new AtomicReference();
    private static final Helper doNothingHelper = new Helper(){

        @Override
        public void ensure(CuratorZookeeperClient client, String path) throws Exception {
        }
    };

    public EnsurePath(String path) {
        this.path = path;
        this.helper.set(new InitialHelper());
    }

    public void ensure(CuratorZookeeperClient client) throws Exception {
        Helper localHelper = this.helper.get();
        localHelper.ensure(client, this.path);
    }

    private class InitialHelper
    implements Helper {
        private boolean isSet = false;

        private InitialHelper() {
        }

        @Override
        public synchronized void ensure(CuratorZookeeperClient client, String path) throws Exception {
            if (!this.isSet) {
                client.blockUntilConnectedOrTimedOut();
                ZKPaths.mkdirs(client.getZooKeeper(), path, true);
                EnsurePath.this.helper.set(doNothingHelper);
                this.isSet = true;
            }
        }
    }

    private static interface Helper {
        public void ensure(CuratorZookeeperClient var1, String var2) throws Exception;
    }
}

