/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.ensemble.exhibitor;

import com.google.common.io.Closeables;
import com.netflix.curator.ensemble.exhibitor.ExhibitorRestClient;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;

public class DefaultExhibitorRestClient
implements ExhibitorRestClient {
    private final boolean useSsl;

    public DefaultExhibitorRestClient() {
        this(false);
    }

    public DefaultExhibitorRestClient(boolean useSsl) {
        this.useSsl = useSsl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRaw(String hostname, int port, String uriPath, String mimeType) throws Exception {
        URI uri = new URI(this.useSsl ? "https" : "http", null, hostname, port, uriPath, null, null);
        HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection();
        connection.addRequestProperty("Accept", mimeType);
        StringBuilder str = new StringBuilder();
        BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
        try {
            int b;
            while ((b = ((InputStream)in).read()) >= 0) {
                str.append((char)(b & 0xFF));
            }
        }
        finally {
            Closeables.closeQuietly((Closeable)in);
        }
        return str.toString();
    }
}

