/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.retry;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.curator.retry.ExponentialBackoffRetry;

public class BoundedExponentialBackoffRetry
extends ExponentialBackoffRetry {
    private final int maxSleepTimeMs;

    public BoundedExponentialBackoffRetry(int baseSleepTimeMs, int maxSleepTimeMs, int maxRetries) {
        super(baseSleepTimeMs, maxRetries);
        this.maxSleepTimeMs = maxSleepTimeMs;
    }

    @VisibleForTesting
    public int getMaxSleepTimeMs() {
        return this.maxSleepTimeMs;
    }

    @Override
    protected int getSleepTimeMs(int retryCount, long elapsedTimeMs) {
        return Math.min(this.maxSleepTimeMs, super.getSleepTimeMs(retryCount, elapsedTimeMs));
    }
}

