/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.retry;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.curator.retry.SleepingRetry;
import java.util.Random;

public class ExponentialBackoffRetry
extends SleepingRetry {
    private final Random random = new Random();
    private final int baseSleepTimeMs;

    public ExponentialBackoffRetry(int baseSleepTimeMs, int maxRetries) {
        super(maxRetries);
        this.baseSleepTimeMs = baseSleepTimeMs;
    }

    @VisibleForTesting
    public int getBaseSleepTimeMs() {
        return this.baseSleepTimeMs;
    }

    @Override
    protected int getSleepTimeMs(int retryCount, long elapsedTimeMs) {
        return this.baseSleepTimeMs * Math.max(1, this.random.nextInt(1 << retryCount + 1));
    }
}

