/*
 * Copyright 2012 Netflix, Inc.
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package com.netflix.curator.framework.recipes.locks;

import java.io.Closeable;
import java.io.IOException;

/**
 * Represents an acquired lease from an {@link InterProcessSemaphore}. It is the client's responsibility
 * to close this lease when it is no longer needed so that other blocked clients can use it. If the
 * client crashes (or its session expires, etc.) the lease will automatically be closed.
 */
public interface Lease extends Closeable
{
    /**
     * Releases the lease so that other clients/processes can acquire it
     *
     * @throws IOException
     */
    @Override
    public void close() throws IOException;
}
