/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.recipes.locks;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closeables;
import com.netflix.curator.framework.CuratorFramework;
import com.netflix.curator.framework.api.ACLPathAndBytesable;
import com.netflix.curator.framework.api.BackgroundPathable;
import com.netflix.curator.framework.recipes.locks.InterProcessMutex;
import com.netflix.curator.framework.recipes.locks.Lease;
import com.netflix.curator.framework.recipes.shared.SharedCountListener;
import com.netflix.curator.framework.recipes.shared.SharedCountReader;
import com.netflix.curator.framework.state.ConnectionState;
import com.netflix.curator.utils.ZKPaths;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterProcessSemaphoreV2 {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final InterProcessMutex lock;
    private final CuratorFramework client;
    private final String leasesPath;
    private final Watcher watcher = new Watcher(){

        public void process(WatchedEvent event) {
            InterProcessSemaphoreV2.this.notifyFromWatcher();
        }
    };
    private volatile int maxLeases;
    private static final String LOCK_PARENT = "locks";
    private static final String LEASE_PARENT = "leases";
    private static final String LEASE_BASE_NAME = "lease-";

    public InterProcessSemaphoreV2(CuratorFramework client, String path, int maxLeases) {
        this(client, path, maxLeases, null);
    }

    public InterProcessSemaphoreV2(CuratorFramework client, String path, SharedCountReader count) {
        this(client, path, 0, count);
    }

    private InterProcessSemaphoreV2(CuratorFramework client, String path, int maxLeases, SharedCountReader count) {
        this.client = client;
        this.lock = new InterProcessMutex(client, ZKPaths.makePath((String)path, (String)LOCK_PARENT));
        this.maxLeases = count != null ? count.getCount() : maxLeases;
        this.leasesPath = ZKPaths.makePath((String)path, (String)LEASE_PARENT);
        if (count != null) {
            count.addListener(new SharedCountListener(){

                @Override
                public void countHasChanged(SharedCountReader sharedCount, int newCount) throws Exception {
                    InterProcessSemaphoreV2.this.maxLeases = newCount;
                }

                public void stateChanged(CuratorFramework client, ConnectionState newState) {
                }
            });
        }
    }

    public void returnAll(Collection<Lease> leases) {
        for (Lease l : leases) {
            Closeables.closeQuietly((Closeable)l);
        }
    }

    public void returnLease(Lease lease) {
        Closeables.closeQuietly((Closeable)lease);
    }

    public Lease acquire() throws Exception {
        Collection<Lease> leases = this.acquire(1, 0L, null);
        return leases.iterator().next();
    }

    public Collection<Lease> acquire(int qty) throws Exception {
        return this.acquire(qty, 0L, null);
    }

    public Lease acquire(long time, TimeUnit unit) throws Exception {
        Collection<Lease> leases = this.acquire(1, time, unit);
        return leases != null ? leases.iterator().next() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<Lease> acquire(int qty, long time, TimeUnit unit) throws Exception {
        long startMs = System.currentTimeMillis();
        boolean hasWait = unit != null;
        long waitMs = hasWait ? TimeUnit.MILLISECONDS.convert(time, unit) : 0L;
        Preconditions.checkArgument((qty > 0 ? 1 : 0) != 0, (Object)"qty cannot be 0");
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean success = false;
        try {
            block13: while (qty-- > 0) {
                InterProcessSemaphoreV2 interProcessSemaphoreV2;
                if (!this.client.isStarted()) {
                    Collection<Lease> collection = null;
                    return collection;
                }
                if (hasWait) {
                    long thisWaitMs = this.getThisWaitMs(startMs, waitMs);
                    if (!this.lock.acquire(thisWaitMs, TimeUnit.MILLISECONDS)) {
                        interProcessSemaphoreV2 = null;
                        return interProcessSemaphoreV2;
                    }
                } else {
                    this.lock.acquire();
                }
                try {
                    String path = (String)((ACLPathAndBytesable)this.client.create().creatingParentsIfNeeded().withProtection().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).forPath(ZKPaths.makePath((String)this.leasesPath, (String)LEASE_BASE_NAME));
                    String nodeName = ZKPaths.getNodeFromPath((String)path);
                    builder.add((Object)this.makeLease(path));
                    interProcessSemaphoreV2 = this;
                    synchronized (interProcessSemaphoreV2) {
                        while (true) {
                            List children;
                            if (!(children = (List)((BackgroundPathable)this.client.getChildren().usingWatcher(this.watcher)).forPath(this.leasesPath)).contains(nodeName)) {
                                this.log.error("Sequential path not found: " + path);
                                throw new KeeperException.NoNodeException("Sequential path not found: " + path);
                            }
                            if (children.size() <= this.maxLeases) {
                                continue block13;
                            }
                            if (hasWait) {
                                long thisWaitMs = this.getThisWaitMs(startMs, waitMs);
                                if (thisWaitMs <= 0L) {
                                    Collection<Lease> collection = null;
                                    return collection;
                                }
                                this.wait(thisWaitMs);
                                continue;
                            }
                            this.wait();
                        }
                    }
                }
                finally {
                    this.lock.release();
                }
            }
            success = true;
            return builder.build();
        }
        finally {
            if (!success) {
                this.returnAll((Collection<Lease>)builder.build());
            }
        }
    }

    private long getThisWaitMs(long startMs, long waitMs) {
        long elapsedMs = System.currentTimeMillis() - startMs;
        return waitMs - elapsedMs;
    }

    private Lease makeLease(final String path) {
        return new Lease(){

            @Override
            public void close() throws IOException {
                try {
                    InterProcessSemaphoreV2.this.client.delete().guaranteed().forPath(path);
                }
                catch (KeeperException.NoNodeException e) {
                    InterProcessSemaphoreV2.this.log.warn("Lease already released", (Throwable)e);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        };
    }

    private synchronized void notifyFromWatcher() {
        this.notifyAll();
    }
}

