/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.test;

import com.netflix.curator.test.ByteCodeRewrite;
import com.netflix.curator.test.InstanceSpec;
import com.netflix.curator.test.QuorumConfigBuilder;
import com.netflix.curator.test.TestingZooKeeperServer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public class TestingServer
implements Closeable {
    private final TestingZooKeeperServer testingZooKeeperServer;
    private final InstanceSpec spec;

    public TestingServer() throws Exception {
        this(-1, null);
    }

    public TestingServer(int port) throws Exception {
        this(port, null);
    }

    public TestingServer(int port, File tempDirectory) throws Exception {
        this(new InstanceSpec(tempDirectory, port, -1, -1, true, -1));
    }

    public TestingServer(InstanceSpec spec) throws Exception {
        this.spec = spec;
        this.testingZooKeeperServer = new TestingZooKeeperServer(new QuorumConfigBuilder(spec));
        this.testingZooKeeperServer.start();
    }

    public int getPort() {
        return this.spec.getPort();
    }

    public File getTempDirectory() {
        return this.spec.getDataDirectory();
    }

    public void stop() throws IOException {
        this.testingZooKeeperServer.stop();
    }

    @Override
    public void close() throws IOException {
        this.testingZooKeeperServer.close();
    }

    public String getConnectString() {
        return this.spec.getConnectString();
    }

    static {
        ByteCodeRewrite.apply();
    }
}

