/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.queues.redis.conn;

import com.netflix.dyno.jedis.DynoJedisClient;
import com.netflix.dyno.queues.redis.conn.DynoJedisPipe;
import com.netflix.dyno.queues.redis.conn.Pipe;
import com.netflix.dyno.queues.redis.conn.RedisConnection;
import java.util.Set;
import redis.clients.jedis.Tuple;

public class DynoClientProxy
implements RedisConnection {
    private DynoJedisClient jedis;

    public DynoClientProxy(DynoJedisClient jedis) {
        this.jedis = jedis;
    }

    @Override
    public RedisConnection getResource() {
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public Pipe pipelined() {
        return new DynoJedisPipe(this.jedis.pipelined());
    }

    @Override
    public String hget(String key, String member) {
        return this.jedis.hget(key, member);
    }

    @Override
    public Long zrem(String key, String member) {
        return this.jedis.zrem(key, new String[]{member});
    }

    @Override
    public Long hdel(String key, String member) {
        return this.jedis.hdel(key, new String[]{member});
    }

    @Override
    public Double zscore(String key, String member) {
        return this.jedis.zscore(key, member);
    }

    @Override
    public void zadd(String key, double score, String member) {
        this.jedis.zadd(key, score, member);
    }

    @Override
    public void hset(String key, String member, String json) {
        this.jedis.hset(key, member, json);
    }

    @Override
    public long zcard(String key) {
        return this.jedis.zcard(key);
    }

    @Override
    public void del(String key) {
        this.jedis.del(key);
    }

    @Override
    public Set<String> zrangeByScore(String key, int min, double max, int offset, int count) {
        return this.jedis.zrangeByScore(key, (double)min, max, offset, count);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, int min, double max, int offset, int count) {
        return this.jedis.zrangeByScoreWithScores(key, (double)min, max, offset, count);
    }
}

