/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.queues.shard;

import com.netflix.dyno.connectionpool.Host;
import com.netflix.dyno.connectionpool.HostSupplier;
import com.netflix.dyno.queues.ShardSupplier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class ConsistentDynoShardSupplier
implements ShardSupplier {
    protected HostSupplier hs;
    protected String region;
    protected String localRack;
    protected Map<String, String> rackToShardMap;

    public ConsistentDynoShardSupplier(HostSupplier hs, String region, String localRack) {
        this.hs = hs;
        this.region = region;
        this.localRack = localRack;
    }

    public void setRackToShardMap(Map<String, String> rackToShardMapEntries) {
        this.rackToShardMap = new HashMap<String, String>(rackToShardMapEntries);
    }

    public String getCurrentShard() {
        return this.rackToShardMap.get(this.localRack);
    }

    public Set<String> getQueueShards() {
        HashSet<String> queueShards = new HashSet<String>();
        List hosts = this.hs.getHosts();
        for (Host host : hosts) {
            queueShards.add(this.rackToShardMap.get(host.getRack()));
        }
        return queueShards;
    }

    public String getShardForHost(Host host) {
        return this.rackToShardMap.get(host.getRack());
    }
}

