/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.queues.redis.conn;

import com.netflix.dyno.jedis.DynoJedisPipeline;
import com.netflix.dyno.queues.redis.conn.Pipe;
import redis.clients.jedis.Response;
import redis.clients.jedis.params.ZAddParams;

public class DynoJedisPipe
implements Pipe {
    private DynoJedisPipeline pipe;
    private boolean modified;

    public DynoJedisPipe(DynoJedisPipeline pipe) {
        this.pipe = pipe;
        this.modified = false;
    }

    @Override
    public void hset(String key, String field, String value) {
        this.pipe.hset(key, field, value);
        this.modified = true;
    }

    @Override
    public Response<Long> zadd(String key, double score, String member) {
        this.modified = true;
        return this.pipe.zadd(key, score, member);
    }

    @Override
    public Response<Long> zadd(String key, double score, String member, ZAddParams zParams) {
        this.modified = true;
        return this.pipe.zadd(key, score, member, zParams);
    }

    @Override
    public Response<Long> zrem(String key, String member) {
        this.modified = true;
        return this.pipe.zrem(key, new String[]{member});
    }

    @Override
    public Response<String> hget(String key, String member) {
        this.modified = true;
        return this.pipe.hget(key, member);
    }

    @Override
    public Response<Long> hdel(String key, String member) {
        this.modified = true;
        return this.pipe.hdel(key, new String[]{member});
    }

    @Override
    public void sync() {
        if (this.modified) {
            this.pipe.sync();
            this.modified = false;
        }
    }

    @Override
    public void close() throws Exception {
        this.pipe.close();
    }
}

