/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.queues.redis.conn;

import com.netflix.dyno.queues.redis.conn.Pipe;
import com.netflix.dyno.queues.redis.conn.RedisConnection;
import com.netflix.dyno.queues.redis.conn.RedisPipe;
import java.util.Set;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Tuple;

public class JedisProxy
implements RedisConnection {
    private JedisPool pool;
    private Jedis jedis;

    public JedisProxy(JedisPool pool) {
        this.pool = pool;
    }

    public JedisProxy(Jedis jedis) {
        this.jedis = jedis;
    }

    @Override
    public RedisConnection getResource() {
        Jedis jedis = this.pool.getResource();
        return new JedisProxy(jedis);
    }

    @Override
    public void close() {
        this.jedis.close();
    }

    @Override
    public Pipe pipelined() {
        return new RedisPipe(this.jedis.pipelined());
    }

    @Override
    public String hget(String key, String member) {
        return this.jedis.hget(key, member);
    }

    @Override
    public Long zrem(String key, String member) {
        return this.jedis.zrem(key, new String[]{member});
    }

    @Override
    public Long hdel(String key, String member) {
        return this.jedis.hdel(key, new String[]{member});
    }

    @Override
    public Double zscore(String key, String member) {
        return this.jedis.zscore(key, member);
    }

    @Override
    public void zadd(String key, double unackScore, String member) {
        this.jedis.zadd(key, unackScore, member);
    }

    @Override
    public void hset(String key, String member, String json) {
        this.jedis.hset(key, member, json);
    }

    @Override
    public long zcard(String key) {
        return this.jedis.zcard(key);
    }

    @Override
    public void del(String key) {
        this.jedis.del(key);
    }

    @Override
    public Set<String> zrangeByScore(String key, int min, double max, int offset, int count) {
        return this.jedis.zrangeByScore(key, (double)min, max, offset, count);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, int min, double max, int offset, int count) {
        return this.jedis.zrangeByScoreWithScores(key, (double)min, max, offset, count);
    }
}

