/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.queues.redis.sharding;

import com.netflix.dyno.queues.Message;
import com.netflix.dyno.queues.redis.sharding.ShardingStrategy;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class RoundRobinStrategy
implements ShardingStrategy {
    private final AtomicInteger nextShardIndex = new AtomicInteger(0);

    @Override
    public String getNextShard(List<String> allShards, Message message) {
        int index = this.nextShardIndex.incrementAndGet();
        if (index >= allShards.size()) {
            this.nextShardIndex.set(0);
            index = 0;
        }
        return allShards.get(index);
    }
}

