/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.demo.redis;

import com.netflix.dyno.connectionpool.Host;
import com.netflix.dyno.connectionpool.HostBuilder;
import com.netflix.dyno.connectionpool.HostSupplier;
import com.netflix.dyno.connectionpool.OperationResult;
import com.netflix.dyno.connectionpool.TokenMapSupplier;
import com.netflix.dyno.connectionpool.impl.ConnectionPoolConfigurationImpl;
import com.netflix.dyno.connectionpool.impl.lb.HostToken;
import com.netflix.dyno.jedis.DynoJedisClient;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.log4j.BasicConfigurator;

public class CustomTokenSupplierExample {
    private DynoJedisClient client;

    public void init() throws Exception {
        int port = 6379;
        final Host localHost = new HostBuilder().setHostname("localhost").setPort(6379).setRack("localrack").setStatus(Host.Status.Up).createHost();
        HostSupplier localHostSupplier = new HostSupplier(){

            public List<Host> getHosts() {
                return Collections.singletonList(localHost);
            }
        };
        TokenMapSupplier supplier = new TokenMapSupplier(){
            final HostToken localHostToken;
            {
                this.localHostToken = new HostToken(Long.valueOf(100000L), localHost);
            }

            public List<HostToken> getTokens(Set<Host> activeHosts) {
                return Collections.singletonList(this.localHostToken);
            }

            public HostToken getTokenForHost(Host host, Set<Host> activeHosts) {
                return this.localHostToken;
            }
        };
        this.client = new DynoJedisClient.Builder().withApplicationName("tokenSupplierExample").withDynomiteClusterName("tokenSupplierExample").withHostSupplier(localHostSupplier).withCPConfig(new ConnectionPoolConfigurationImpl("tokenSupplierExample").withTokenSupplier(supplier)).build();
    }

    public void runSimpleTest() throws Exception {
        int i;
        for (i = 0; i < 10; ++i) {
            this.client.set("" + i, "" + i);
        }
        for (i = 0; i < 10; ++i) {
            OperationResult result = this.client.d_get("" + i);
            System.out.println("Key: " + i + ", Value: " + (String)result.getResult() + " " + result.getNode());
        }
    }

    public void stop() {
        if (this.client != null) {
            this.client.stopClient();
        }
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        CustomTokenSupplierExample example = new CustomTokenSupplierExample();
        try {
            example.init();
            example.runSimpleTest();
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            example.stop();
        }
    }
}

