/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.demo.redis;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.netflix.dyno.connectionpool.CursorBasedResult;
import com.netflix.dyno.connectionpool.Host;
import com.netflix.dyno.connectionpool.HostBuilder;
import com.netflix.dyno.connectionpool.HostSupplier;
import com.netflix.dyno.connectionpool.OperationResult;
import com.netflix.dyno.connectionpool.TokenMapSupplier;
import com.netflix.dyno.connectionpool.exception.PoolOfflineException;
import com.netflix.dyno.connectionpool.impl.ConnectionPoolConfigurationImpl;
import com.netflix.dyno.connectionpool.impl.lb.HostToken;
import com.netflix.dyno.contrib.ArchaiusConnectionPoolConfiguration;
import com.netflix.dyno.jedis.DynoJedisClient;
import com.netflix.dyno.jedis.DynoJedisPipeline;
import com.netflix.dyno.recipes.json.DynoJedisJsonClient;
import com.netflix.dyno.recipes.json.JsonPath;
import com.netflix.dyno.recipes.lock.DynoLockClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import redis.clients.jedis.Response;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

public class DynoJedisDemo {
    private static final Logger logger = LoggerFactory.getLogger(DynoJedisDemo.class);
    public static final String randomValue = "dcfa7d0973834e5c9f480b65de19d684dcfa7d097383dcfa7d0973834e5c9f480b65de19d684dcfa7d097383dcfa7d0973834e5c9f480b65de19d684dcfa7d097383dcfa7d0973834e5c9f480b65de19d684dcfa7d097383";
    protected DynoJedisClient client;
    protected DynoJedisClient shadowClusterClient;
    private DynoLockClient dynoLockClient;
    protected int numKeys;
    protected final String localRack;
    protected final String clusterName;
    protected final String shadowClusterName;

    public DynoJedisDemo(String clusterName, String localRack) {
        this(clusterName, null, localRack);
    }

    public DynoJedisDemo(String primaryCluster, String shadowCluster, String localRack) {
        this.clusterName = primaryCluster;
        this.shadowClusterName = shadowCluster;
        this.localRack = localRack;
    }

    public void initWithLocalHost(boolean initLock) throws Exception {
        int port = 6379;
        HostSupplier localHostSupplier = new HostSupplier(){
            final Host hostSupplierHost;
            {
                this.hostSupplierHost = new HostBuilder().setHostname("localhost").setRack(DynoJedisDemo.this.localRack).setDatastorePort(6379).setStatus(Host.Status.Up).createHost();
            }

            public List<Host> getHosts() {
                return Collections.singletonList(this.hostSupplierHost);
            }
        };
        TokenMapSupplier tokenSupplier = new TokenMapSupplier(){
            final Host tokenHost;
            final HostToken localHostToken;
            {
                this.tokenHost = new HostBuilder().setHostname("localhost").setPort(6379).setDatastorePort(6379).setRack(DynoJedisDemo.this.localRack).setStatus(Host.Status.Up).createHost();
                this.localHostToken = new HostToken(Long.valueOf(100000L), this.tokenHost);
            }

            public List<HostToken> getTokens(Set<Host> activeHosts) {
                return Collections.singletonList(this.localHostToken);
            }

            public HostToken getTokenForHost(Host host, Set<Host> activeHosts) {
                return this.localHostToken;
            }
        };
        if (initLock) {
            this.initDynoLockClient(localHostSupplier, tokenSupplier, "test", "test");
        } else {
            this.init(localHostSupplier, 6379, tokenSupplier);
        }
    }

    private void initWithRemoteCluster(String clusterName, List<Host> hosts, int port, boolean lock) throws Exception {
        HostSupplier clusterHostSupplier = () -> hosts;
        if (lock) {
            this.initDynoLockClient(clusterHostSupplier, null, "test", clusterName);
        } else {
            this.init(clusterHostSupplier, port, null);
        }
    }

    public void initWithRemoteClusterFromFile(String filename, int port, boolean lock) throws Exception {
        this.initWithRemoteCluster(null, this.readHostsFromFile(filename, port), port, lock);
    }

    public void initWithRemoteClusterFromEurekaUrl(String clusterName, int port, boolean lock) throws Exception {
        this.initWithRemoteCluster(clusterName, this.getHostsFromDiscovery(clusterName), port, lock);
    }

    public void initDualClientWithRemoteClustersFromFile(String primaryHostsFile, String shadowHostsFile, int port) throws Exception {
        HostSupplier primaryClusterHostSupplier = () -> {
            try {
                return this.readHostsFromFile(primaryHostsFile, port);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        };
        HostSupplier shadowClusterHostSupplier = () -> {
            try {
                return this.readHostsFromFile(shadowHostsFile, port);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        };
        this.initDualWriterDemo(primaryClusterHostSupplier, shadowClusterHostSupplier, null, null);
    }

    public void initDualClientWithRemoteClustersFromEurekaUrl(String primaryClusterName, String shadowClusterName) {
        HostSupplier primaryClusterHostSupplier = () -> this.getHostsFromDiscovery(primaryClusterName);
        HostSupplier shadowClusterHostSupplier = () -> this.getHostsFromDiscovery(shadowClusterName);
        this.initDualWriterDemo(primaryClusterHostSupplier, shadowClusterHostSupplier, null, null);
    }

    public void initDualWriterDemo(HostSupplier primaryClusterHostSupplier, HostSupplier shadowClusterHostSupplier, TokenMapSupplier primaryTokenSupplier, TokenMapSupplier shadowTokenSupplier) {
        this.client = new DynoJedisClient.Builder().withApplicationName("demo").withDynomiteClusterName("dyno-dev").withHostSupplier(primaryClusterHostSupplier).withDualWriteHostSupplier(shadowClusterHostSupplier).withTokenMapSupplier(primaryTokenSupplier).withDualWriteTokenMapSupplier(shadowTokenSupplier).build();
        ArchaiusConnectionPoolConfiguration shadowCPConfig = new ArchaiusConnectionPoolConfiguration(this.shadowClusterName);
        this.shadowClusterClient = new DynoJedisClient.Builder().withApplicationName("demo").withDynomiteClusterName("dyno-dev").withHostSupplier(shadowClusterHostSupplier).withTokenMapSupplier(shadowTokenSupplier).withCPConfig((ConnectionPoolConfigurationImpl)shadowCPConfig).build();
    }

    public void init(HostSupplier hostSupplier, int port, TokenMapSupplier tokenSupplier) throws Exception {
        this.client = new DynoJedisClient.Builder().withApplicationName("demo").withDynomiteClusterName("dyno_dev").withHostSupplier(hostSupplier).withTokenMapSupplier(tokenSupplier).build();
    }

    public void initDynoLockClient(HostSupplier hostSupplier, TokenMapSupplier tokenMapSupplier, String appName, String clusterName) {
        this.dynoLockClient = new DynoLockClient.Builder().withApplicationName(appName).withDynomiteClusterName(clusterName).withTimeoutUnit(TimeUnit.MILLISECONDS).withTimeout(10000L).withHostSupplier(hostSupplier).withTokenMapSupplier(tokenMapSupplier).build();
    }

    public void runSimpleTest() throws Exception {
        OperationResult result;
        int i;
        this.numKeys = 10;
        System.out.println("Simple test selected");
        for (i = 0; i < this.numKeys; ++i) {
            System.out.println("Writing key/value => DynoClientTest-" + i + " / " + i);
            this.client.set("DynoClientTest-" + i, "" + i);
        }
        for (i = 0; i < this.numKeys; ++i) {
            result = this.client.d_get("DynoClientTest-" + i);
            System.out.println("Reading Key: " + i + ", Value: " + (String)result.getResult() + " " + result.getNode());
        }
        if (this.shadowClusterClient != null) {
            for (i = 0; i < this.numKeys; ++i) {
                result = this.shadowClusterClient.d_get("DynoClientTest-" + i);
                System.out.println("Reading Key: " + i + ", Value: " + (String)result.getResult() + " " + result.getNode());
            }
        }
    }

    public void runSimpleDualWriterPipelineTest() {
        OperationResult result;
        int i;
        this.numKeys = 10;
        System.out.println("Simple Dual Writer Pipeline test selected");
        DynoJedisPipeline pipeline = this.client.pipelined();
        for (i = 0; i < this.numKeys; ++i) {
            System.out.println("Writing key/value => DynoClientTest/" + i);
            pipeline.hset("DynoClientTest", "DynoClientTest-" + i, "" + i);
        }
        pipeline.sync();
        pipeline = this.client.pipelined();
        for (i = 0; i < this.numKeys; ++i) {
            System.out.println("Writing key/value => DynoClientTest-1/" + i);
            pipeline.hset("DynoClientTest-1", "DynoClientTest-" + i, "" + i);
        }
        pipeline.sync();
        System.out.println("Reading keys from dual writer pipeline client");
        for (i = 0; i < this.numKeys; ++i) {
            result = this.client.d_hget("DynoClientTest", "DynoClientTest-" + i);
            System.out.println("Reading Key: DynoClientTest/" + i + ", Value: " + (String)result.getResult() + " " + result.getNode());
            result = this.client.d_hget("DynoClientTest-1", "DynoClientTest-" + i);
            System.out.println("Reading Key: DynoClientTest-1/" + i + ", Value: " + (String)result.getResult() + " " + result.getNode());
        }
        System.out.println("Reading keys from shadow Jedis client");
        if (this.shadowClusterClient != null) {
            for (i = 0; i < this.numKeys; ++i) {
                result = this.shadowClusterClient.d_hget("DynoClientTest", "DynoClientTest-" + i);
                System.out.println("Reading Key: DynoClientTest/" + i + ", Value: " + (String)result.getResult() + " " + result.getNode());
                result = this.shadowClusterClient.d_hget("DynoClientTest-1", "DynoClientTest-" + i);
                System.out.println("Reading Key: DynoClientTest-1/" + i + ", Value: " + (String)result.getResult() + " " + result.getNode());
            }
        }
        try {
            pipeline.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void runBinaryKeyTest() throws Exception {
        System.out.println("Binary Key test selected");
        byte[] videoInt = ByteBuffer.allocate(4).putInt(new Integer(100)).array();
        byte[] locInt = ByteBuffer.allocate(4).putInt(new Integer(200)).array();
        byte[] overallKey = new byte[videoInt.length + locInt.length];
        byte[] firstWindow = ByteBuffer.allocate(4).putFloat(new Float(1.25).floatValue()).array();
        byte[] secondWindow = ByteBuffer.allocate(4).putFloat(new Float(1.5).floatValue()).array();
        byte[] thirdWindow = ByteBuffer.allocate(4).putFloat(new Float(1.75).floatValue()).array();
        byte[] fourthWindow = ByteBuffer.allocate(4).putFloat(new Float(2.0).floatValue()).array();
        byte[] overallVal = new byte[firstWindow.length + secondWindow.length + thirdWindow.length + fourthWindow.length];
        byte[] newKey = new byte[videoInt.length + locInt.length];
        this.client.set(overallKey, overallVal);
        System.out.println("Writing Key: " + new String(overallKey, Charset.forName("UTF-8")));
        OperationResult result = this.client.d_get(newKey);
        System.out.println("Reading Key: " + new String(newKey, Charset.forName("UTF-8")) + ", Value: " + ((byte[])result.getResult()).toString() + " " + result.getNode());
    }

    public void runSimpleTestWithHashtag() throws Exception {
        int i;
        this.numKeys = 100;
        System.out.println("Simple test with hashtag selected");
        for (i = 0; i < this.numKeys; ++i) {
            System.out.println("Writing key/value => DynoClientTest-" + i + " / " + i);
            this.client.set(i + "-{bar}", " " + i);
        }
        for (i = 0; i < this.numKeys; ++i) {
            OperationResult result = this.client.d_get(i + "-{bar}");
            System.out.println("Reading Key: " + i + "-{bar} , Value: " + (String)result.getResult() + " " + result.getNode());
        }
    }

    public void runPipelineEmptyResult() throws Exception {
        DynoJedisPipeline pipeline = this.client.pipelined();
        DynoJedisPipeline pipeline2 = this.client.pipelined();
        try {
            byte[] field1 = "field1".getBytes();
            byte[] field2 = "field2".getBytes();
            pipeline.hset("myHash".getBytes(), field1, "hello".getBytes());
            pipeline.hset("myHash".getBytes(), field2, "world".getBytes());
            Thread.sleep(1000L);
            Response result = pipeline.hmget("myHash".getBytes(), (byte[][])new byte[][]{field1, field2, "miss".getBytes()});
            pipeline.sync();
            System.out.println("TEST-1: hmget for 2 valid results and 1 non-existent field");
            for (int i = 0; i < ((List)result.get()).size(); ++i) {
                byte[] val = (byte[])((List)result.get()).get(i);
                if (val != null) {
                    System.out.println("TEST-1:Result => " + i + ") " + new String(val));
                    continue;
                }
                System.out.println("TEST-1:Result => " + i + ") " + val);
            }
        }
        catch (Exception e) {
            pipeline.discardPipelineAndReleaseConnection();
            throw e;
        }
        try {
            Response result2 = pipeline2.hmget("foo".getBytes(), (byte[][])new byte[][]{"miss1".getBytes(), "miss2".getBytes()});
            pipeline2.sync();
            System.out.println("TEST-2: hmget when all fields (3) are not present in the hash");
            if (result2.get() == null) {
                System.out.println("TEST-2: result is null");
            } else {
                for (int i = 0; i < ((List)result2.get()).size(); ++i) {
                    System.out.println("TEST-2:" + Arrays.toString((byte[])((List)result2.get()).get(i)));
                }
            }
        }
        catch (Exception e) {
            pipeline.discardPipelineAndReleaseConnection();
            throw e;
        }
    }

    public void runKeysTest() throws Exception {
        System.out.println("Writing 10,000 keys to dynomite...");
        for (int i = 0; i < 500; ++i) {
            this.client.set("DynoClientTest_KEYS-TEST-key" + i, "value-" + i);
        }
        System.out.println("finished writing 10000 keys, querying for keys(\"DynoClientTest_KYES-TEST*\")");
        Set result = this.client.keys("DynoClientTest_KEYS-TEST*");
        System.out.println("Got " + result.size() + " results, below");
        System.out.println(result);
    }

    public void runScanTest(boolean populateKeys) throws Exception {
        logger.info("SCAN TEST -- begin");
        String keyPattern = System.getProperty("dyno.demo.scan.key.pattern", "DynoClientTest_key-*");
        String keyPrefix = System.getProperty("dyno.demo.scan.key.prefix", "DynoClientTest_key-");
        if (populateKeys) {
            logger.info("Writing 500 keys to {} with prefix {}", (Object)this.clusterName, (Object)keyPrefix);
            for (int i = 0; i < 500; ++i) {
                this.client.set(keyPrefix + i, "value-" + i);
            }
        }
        logger.info("Reading keys from {} with pattern {}", (Object)this.clusterName, (Object)keyPattern);
        CursorBasedResult cbi = null;
        long start = System.currentTimeMillis();
        int count = 0;
        do {
            try {
                cbi = this.client.dyno_scan(cbi, 5, new String[]{keyPattern});
            }
            catch (PoolOfflineException ex) {
                logger.info("Caught exception.... retrying scan");
                cbi = null;
                continue;
            }
            List results = cbi.getStringResult();
            count += results.size();
            int i = 0;
            for (String res : results) {
                logger.info("{}) {}", (Object)i, (Object)res);
                ++i;
            }
        } while (cbi == null || !cbi.isComplete());
        long end = System.currentTimeMillis();
        logger.info("SCAN TEST -- done {} results in {}ms", (Object)count, (Object)(end - start));
    }

    public void runSScanTest(boolean populateKeys) throws Exception {
        ScanResult scanResult;
        logger.info("SET SCAN TEST -- begin");
        String key = "DynoClientTest_Set";
        if (populateKeys) {
            logger.info("Populating set in cluster {} with key {}", (Object)this.clusterName, (Object)"DynoClientTest_Set");
            for (int i = 0; i < 50; ++i) {
                this.client.sadd("DynoClientTest_Set", new String[]{"value-" + i});
            }
        }
        logger.info("Reading members of set from cluster {} with key {}", (Object)this.clusterName, (Object)"DynoClientTest_Set");
        HashSet matches = new HashSet();
        String cursor = "0";
        do {
            ScanParams scanParams = new ScanParams().count(Integer.valueOf(10));
            scanParams.match("*");
            scanResult = this.client.sscan("DynoClientTest_Set", cursor, scanParams);
            matches.addAll(scanResult.getResult());
        } while (!"0".equals(cursor = scanResult.getCursor()));
        logger.info("SET SCAN TEST -- done");
    }

    public void cleanup(int nKeys) throws Exception {
        for (int i = 0; i < nKeys; ++i) {
            System.out.println("Deleting : " + i);
            this.client.del("DynoDemoTest" + i);
        }
    }

    public void runMultiThreaded() throws Exception {
        this.runMultiThreaded(1000, true, 2, 2);
    }

    public void runMultiThreaded(int items, boolean doSeed, int numReaders, int numWriters) throws Exception {
        int nKeys = items;
        if (doSeed) {
            for (int i = 0; i < nKeys; ++i) {
                System.out.println("Writing : " + i);
                this.client.set("DynoDemoTest" + i, "" + i);
            }
        }
        int nThreads = numReaders + numWriters + 1;
        ExecutorService threadPool = Executors.newFixedThreadPool(nThreads);
        final AtomicBoolean stop = new AtomicBoolean(false);
        final CountDownLatch latch = new CountDownLatch(nThreads);
        final AtomicInteger success = new AtomicInteger(0);
        final AtomicInteger failure = new AtomicInteger(0);
        final AtomicInteger emptyReads = new AtomicInteger(0);
        this.startWrites(nKeys, numWriters, threadPool, stop, latch, success, failure);
        this.startReads(nKeys, numReaders, threadPool, stop, latch, success, failure, emptyReads);
        threadPool.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                while (!stop.get()) {
                    System.out.println("Success: " + success.get() + ", failure: " + failure.get() + ", emptyReads: " + emptyReads.get());
                    Thread.sleep(1000L);
                }
                latch.countDown();
                return null;
            }
        });
        Thread.sleep(15000L);
        stop.set(true);
        latch.await();
        threadPool.shutdownNow();
        this.executePostRunActions();
        System.out.println("Cleaning up keys");
        this.cleanup(nKeys);
        System.out.println("FINAL RESULT \nSuccess: " + success.get() + ", failure: " + failure.get() + ", emptyReads: " + emptyReads.get());
    }

    protected void executePostRunActions() {
    }

    protected void startWrites(final int nKeys, int numWriters, ExecutorService threadPool, final AtomicBoolean stop, final CountDownLatch latch, final AtomicInteger success, final AtomicInteger failure) {
        for (int i = 0; i < numWriters; ++i) {
            threadPool.submit(new Callable<Void>(){
                final Random random = new Random();

                @Override
                public Void call() throws Exception {
                    while (!stop.get()) {
                        int key = this.random.nextInt(nKeys);
                        int value = this.random.nextInt(nKeys);
                        try {
                            DynoJedisDemo.this.client.set("DynoDemoTest" + key, "" + value);
                            success.incrementAndGet();
                        }
                        catch (Exception e) {
                            System.out.println("WRITE FAILURE: " + e.getMessage());
                            failure.incrementAndGet();
                        }
                    }
                    latch.countDown();
                    return null;
                }
            });
        }
    }

    protected void startReads(final int nKeys, int numReaders, ExecutorService threadPool, final AtomicBoolean stop, final CountDownLatch latch, final AtomicInteger success, final AtomicInteger failure, final AtomicInteger emptyReads) {
        for (int i = 0; i < numReaders; ++i) {
            threadPool.submit(new Callable<Void>(){
                final Random random = new Random();

                @Override
                public Void call() throws Exception {
                    while (!stop.get()) {
                        int key = this.random.nextInt(nKeys);
                        try {
                            String value = DynoJedisDemo.this.client.get("DynoDemoTest" + key);
                            success.incrementAndGet();
                            if (value != null && !value.isEmpty()) continue;
                            emptyReads.incrementAndGet();
                        }
                        catch (Exception e) {
                            System.out.println("READ FAILURE: " + e.getMessage());
                            failure.incrementAndGet();
                        }
                    }
                    latch.countDown();
                    return null;
                }
            });
        }
    }

    public void stop() {
        if (this.client != null) {
            this.client.stopClient();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Host> readHostsFromFile(String filename, int port) throws Exception {
        ArrayList<Host> hosts = new ArrayList<Host>();
        File file = new File(filename);
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                String[] parts = line.trim().split(" ");
                if (parts.length != 2) {
                    throw new RuntimeException("Bad data format in file:" + line);
                }
                Host host = new HostBuilder().setHostname(parts[0].trim()).setPort(port).setRack(parts[1].trim()).setStatus(Host.Status.Up).createHost();
                hosts.add(host);
            }
        }
        return hosts;
    }

    public void runBinarySinglePipeline() throws Exception {
        for (int i = 0; i < 10; ++i) {
            DynoJedisPipeline pipeline = this.client.pipelined();
            HashMap<byte[], byte[]> bar = new HashMap<byte[], byte[]>();
            bar.put("key__1".getBytes(), "value__1".getBytes());
            bar.put("key__2".getBytes(), "value__2".getBytes());
            Response hmsetResult = pipeline.hmset(("hash__" + i).getBytes(), bar);
            pipeline.sync();
            System.out.println((String)hmsetResult.get());
        }
        System.out.println("Reading all keys");
        DynoJedisPipeline readPipeline = this.client.pipelined();
        Response resp = readPipeline.hgetAll("hash__1".getBytes());
        readPipeline.sync();
        StringBuilder sb = new StringBuilder();
        for (byte[] bytes : ((Map)resp.get()).keySet()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(new String(bytes));
        }
        System.out.println("Got hash :" + sb.toString());
    }

    public void runCompressionInPipelineTest() throws Exception {
        int maxNumKeys = 100;
        int maxPipelineSize = 10;
        int maxOperations = 500;
        Random rand = new Random();
        for (int operationIter = 0; operationIter < 500; ++operationIter) {
            DynoJedisPipeline pipeline = this.client.pipelined();
            int pipelineSize = 1 + rand.nextInt(10);
            String key = "hash__" + rand.nextInt(100);
            HashMap<String, String> map = new HashMap<String, String>();
            ArrayList<String> fields = new ArrayList<String>(pipelineSize);
            for (int pipelineIter = 0; pipelineIter < pipelineSize; ++pipelineIter) {
                String field = "field_" + pipelineIter;
                fields.add(field);
                String prefixSuffix = key + "_" + field;
                String value = prefixSuffix + "_" + DynoJedisDemo.generateValue(pipelineIter) + "_" + prefixSuffix;
                map.put(field, value);
            }
            Response HMSetResult = pipeline.hmset(key, map);
            Response HMGetResult = pipeline.hmget(key, fields.toArray(new String[fields.size()]));
            try {
                pipeline.sync();
            }
            catch (Exception e) {
                pipeline.discardPipelineAndReleaseConnection();
                System.out.println("Exception while writing key " + key + " fields: " + fields);
                throw e;
            }
            if (!((String)HMSetResult.get()).equals("OK")) {
                System.out.println("Result mismatch for HMSet key: '" + key + "' fields: '" + fields + "' result: '" + (String)HMSetResult.get() + "'");
            }
            if (operationIter % 100 == 0) {
                System.out.println("\n>>>>>>>> " + operationIter + " operations performed....");
            }
            List HMGetResultStrings = (List)HMGetResult.get();
            for (int i = 0; i < HMGetResultStrings.size(); ++i) {
                String prefixSuffix = key + "_" + (String)fields.get(i);
                String value = (String)HMGetResultStrings.get(i);
                if (value.startsWith(prefixSuffix) && value.endsWith(prefixSuffix)) continue;
                System.out.println("Result mismatch key: '" + key + "' field: '" + (String)fields.get(i) + "' value: '" + (String)HMGetResultStrings.get(i) + "'");
            }
        }
        System.out.println("Compression test Done: 500 pipeline operations performed.");
    }

    public void runSandboxTest() throws Exception {
        Set keys = this.client.keys("zuulRules:*");
        System.out.println("GOT KEYS");
        System.out.println(keys.size());
    }

    private static String generateValue(int kilobytes) {
        StringBuilder sb = new StringBuilder(kilobytes * 512);
        for (int i = 0; i < kilobytes; ++i) {
            for (int j = 0; j < 10; ++j) {
                sb.append("abcdefghijklmnopqrstuvwxzy0123456789a1b2c3d4f5g6h7");
                sb.append(":");
                sb.append("abcdefghijklmnopqrstuvwxzy0123456789a1b2c3d4f5g6h7");
                sb.append(":");
            }
        }
        return sb.toString();
    }

    public void runPipelineWithHashtag() throws Exception {
        DynoJedisPipeline pipeline = this.client.pipelined();
        try {
            pipeline.set("pipeline-hashtag1-{bar}", "value-1");
            pipeline.set("pipeline-hashtag2-{bar}", "value-2");
            pipeline.set("pipeline-hashtag3-{bar}", "value-3");
            pipeline.set("pipeline-hashtag4-{bar}", "value-4");
            pipeline.set("pipeline-hashtag5-{bar}", "value-5");
            pipeline.set("pipeline-hashtag6-{bar}", "value-6");
            pipeline.set("pipeline-hashtag7-{bar}", "value-7");
            pipeline.set("pipeline-hashtag8-{bar}", "value-8");
            pipeline.set("pipeline-hashtag9-{bar}", "value-9");
            pipeline.set("pipeline-hashtag10-{bar}", "value-10");
            Response value1 = pipeline.get("pipeline-hashtag1-{bar}");
            Response value2 = pipeline.get("pipeline-hashtag2-{bar}");
            Response value3 = pipeline.get("pipeline-hashtag3-{bar}");
            Response value4 = pipeline.get("pipeline-hashtag4-{bar}");
            Response value5 = pipeline.get("pipeline-hashtag5-{bar}");
            Response value6 = pipeline.get("pipeline-hashtag6-{bar}");
            pipeline.sync();
            System.out.println((String)value1.get());
            System.out.println((String)value2.get());
            System.out.println((String)value3.get());
            System.out.println((String)value4.get());
            System.out.println((String)value5.get());
            System.out.println((String)value6.get());
        }
        catch (Exception e) {
            pipeline.discardPipelineAndReleaseConnection();
            throw e;
        }
    }

    public void runPipeline() throws Exception {
        int numThreads = 5;
        ExecutorService threadPool = Executors.newFixedThreadPool(numThreads);
        final AtomicBoolean stop = new AtomicBoolean(false);
        final CountDownLatch latch = new CountDownLatch(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            threadPool.submit(new Callable<Void>(){
                final Random rand = new Random();

                @Override
                public Void call() throws Exception {
                    AtomicInteger iter = new AtomicInteger(0);
                    while (!stop.get()) {
                        int index = this.rand.nextInt(5);
                        int i = iter.incrementAndGet();
                        DynoJedisPipeline pipeline = DynoJedisDemo.this.client.pipelined();
                        try {
                            Response resultA1 = pipeline.hset("DynoJedisDemo_pipeline-" + index, "a1", DynoJedisDemo.this.constructRandomValue(index));
                            Response resultA2 = pipeline.hset("DynoJedisDemo_pipeline-" + index, "a2", "value-" + i);
                            pipeline.sync();
                            System.out.println(resultA1.get() + " " + resultA2.get());
                        }
                        catch (Exception e) {
                            pipeline.discardPipelineAndReleaseConnection();
                            throw e;
                        }
                    }
                    latch.countDown();
                    return null;
                }
            });
        }
        Thread.sleep(5000L);
        stop.set(true);
        latch.await();
        threadPool.shutdownNow();
    }

    private String constructRandomValue(int sizeInKB) {
        int requriredLength = sizeInKB * 1024;
        String s = randomValue;
        int sLength = s.length();
        StringBuilder sb = new StringBuilder();
        int lengthSoFar = 0;
        do {
            sb.append(s);
        } while ((lengthSoFar += sLength) < requriredLength);
        String ss = sb.toString();
        if (ss.length() > requriredLength) {
            ss = sb.substring(0, requriredLength);
        }
        return ss;
    }

    private List<Host> getHostsFromDiscovery(String clusterName) {
        String env = System.getProperty("netflix.environment", "test");
        String discoveryKey = String.format("dyno.demo.discovery.%s", env);
        if (!System.getProperties().containsKey(discoveryKey)) {
            throw new IllegalArgumentException("Discovery URL not found");
        }
        String localDatacenter = System.getProperty("LOCAL_DATACENTER");
        String discoveryUrl = String.format(System.getProperty(discoveryKey), localDatacenter);
        String url = String.format("http://%s/%s", discoveryUrl, clusterName);
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            HttpResponse response = client.execute((HttpUriRequest)new HttpGet(url));
            InputStream in = response.getEntity().getContent();
            SAXParserFactory parserFactor = SAXParserFactory.newInstance();
            SAXParser parser = parserFactor.newSAXParser();
            SAXHandler handler = new SAXHandler("instance", new String[]{"public-hostname", "availability-zone", "status", "local-ipv4"});
            parser.parse(in, (DefaultHandler)handler);
            ArrayList<Host> hosts = new ArrayList<Host>();
            for (Map<String, String> map : handler.getList()) {
                String rack = map.get("availability-zone");
                Host.Status status = map.get("status").equalsIgnoreCase("UP") ? Host.Status.Up : Host.Status.Down;
                Host host = new HostBuilder().setHostname(map.get("public-hostname")).setIpAddress(map.get("local-ipv4")).setRack(rack).setStatus(status).createHost();
                hosts.add(host);
                System.out.println("Host: " + host);
            }
            return hosts;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void runLongTest() throws InterruptedException {
        ExecutorService threadPool = Executors.newFixedThreadPool(2);
        AtomicBoolean stop = new AtomicBoolean(false);
        CountDownLatch latch = new CountDownLatch(2);
        AtomicInteger success = new AtomicInteger(0);
        AtomicInteger failure = new AtomicInteger(0);
        AtomicInteger emptyReads = new AtomicInteger(0);
        threadPool.submit(() -> {
            while (!stop.get()) {
                System.out.println("Getting Value for key '0'");
                String value = this.client.get("0");
                System.out.println("Got Value for key '0' : " + value);
                Thread.sleep(5000L);
            }
            latch.countDown();
            return null;
        });
        threadPool.submit(() -> {
            while (!stop.get()) {
                System.out.println("Success: " + success.get() + ", failure: " + failure.get() + ", emptyReads: " + emptyReads.get());
                Thread.sleep(1000L);
            }
            latch.countDown();
            return null;
        });
        Thread.sleep(60000L);
        stop.set(true);
        latch.await();
        threadPool.shutdownNow();
    }

    public void runEvalTest() throws Exception {
        this.client.set("EvalTest", "true");
        ArrayList keys = Lists.newArrayList((Object[])new String[]{"EvalTest"});
        ArrayList args = Lists.newArrayList((Object[])new String[]{"true"});
        Object obj = this.client.eval("if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end", (List)keys, (List)args);
        if (obj.toString().equals("1")) {
            System.out.println("EVAL Test Succeeded");
        } else {
            System.out.println("EVAL Test Failed");
        }
    }

    private void runJsonTest() throws Exception {
        DynoJedisJsonClient jsonClient = new DynoJedisJsonClient(this.client);
        Gson gson = new Gson();
        ArrayList<String> list = new ArrayList<String>();
        list.add("apple");
        list.add("orange");
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        map.put("fruits", list);
        JsonPath jsonPath = new JsonPath().appendSubKey("fruits");
        System.out.println("Get path: " + jsonPath.toString());
        System.out.println("inserting json: " + list);
        OperationResult set1Result = jsonClient.set("test1", map);
        OperationResult set2Result = jsonClient.set("test2", map);
        OperationResult arrappendResult = jsonClient.arrappend("test1", new JsonPath().appendSubKey("fruits"), new Object[]{"mango"});
        OperationResult arrinsertResult = jsonClient.arrinsert("test1", new JsonPath().appendSubKey("fruits"), 0, new Object[]{"banana"});
        OperationResult set3Result = jsonClient.set("test1", new JsonPath().appendSubKey("flowers"), Arrays.asList("rose", "lily"));
        OperationResult typeResult = jsonClient.type("test1");
        OperationResult get1Result = jsonClient.get("test1", new JsonPath[]{jsonPath});
        OperationResult get2Result = jsonClient.get("test2", new JsonPath[]{jsonPath});
        OperationResult mgetResult = jsonClient.mget(Arrays.asList("test1", "test2"), jsonPath.atIndex(-1));
        OperationResult objkeysResult = jsonClient.objkeys("test1");
        OperationResult objlenResult = jsonClient.objlen("test1");
        OperationResult del1Result = jsonClient.del("test1");
        OperationResult del2Result = jsonClient.del("test2");
        System.out.println("Json set1 result: " + (String)set1Result.getResult());
        System.out.println("Json set2 result: " + (String)set2Result.getResult());
        System.out.println("Json arrappend result: " + arrappendResult.getResult());
        System.out.println("Json addinsert result: " + arrinsertResult.getResult());
        System.out.println("Json set3 result: " + (String)set3Result.getResult());
        System.out.println("Json type result: " + ((Class)typeResult.getResult()).getTypeName());
        System.out.println("Json get1 result: " + get1Result.getResult());
        System.out.println("Json get2 result: " + get2Result.getResult());
        System.out.println("Json mget result: " + mgetResult.getResult());
        System.out.println("Json del1 result: " + del1Result.getResult());
        System.out.println("Json del2 result: " + del2Result.getResult());
        System.out.println("Json objkeys result: " + objkeysResult.getResult());
        System.out.println("Json objlen result: " + objlenResult.getResult());
    }

    public void runEvalShaTest() throws Exception {
        this.client.set("EvalShaTestKey", "EVALSHA_WORKS");
        ArrayList keys = Lists.newArrayList((Object[])new String[]{"EvalShaTestKey"});
        ArrayList args = Lists.newArrayList();
        String script_hash = this.client.scriptLoad("return redis.call('get', KEYS[1])");
        if (this.client.scriptExists(script_hash) == Boolean.FALSE) {
            throw new Exception("Test failed. Script did not exist when it should have.");
        }
        Object obj = this.client.evalsha(script_hash, (List)keys, (List)args);
        if (!obj.toString().equals("EVALSHA_WORKS")) {
            throw new Exception("EVALSHA Test Failed. Expected: 'EVALSHA_WORKS'; Got: '" + obj.toString());
        }
        System.out.println("EVALSHA Test Succeeded");
        this.client.scriptFlush();
        if (this.client.scriptExists(script_hash) == Boolean.TRUE) {
            throw new Exception("Test failed. Script existed when it shouldn't have.");
        }
        this.client.del((String)keys.get(0));
        System.out.println("SCRIPT EXISTS and SCRIPT FLUSH Test succeeded.");
    }

    private void runExpireHashTest() throws Exception {
        String val;
        int i;
        this.numKeys = 10;
        System.out.println("Expire hash test selected");
        long ttl = 5L;
        for (i = 0; i < this.numKeys; ++i) {
            System.out.println("Writing key/value => DynoClientTest-" + i + " / " + i);
            this.client.ehset("DynoClientTest", "DynoClientTest-" + i, "" + i, ttl);
        }
        System.out.println("Reading expire hash values (before ttl expiry)");
        for (i = 0; i < this.numKeys; ++i) {
            val = this.client.ehget("DynoClientTest", "DynoClientTest-" + i);
            System.out.println("Reading Key: " + i + ", Value: " + val);
        }
        Thread.sleep(ttl * 1000L);
        System.out.println("Reading expire hash values (after ttl expiry)");
        for (i = 0; i < this.numKeys; ++i) {
            val = this.client.ehget("DynoClientTest", "DynoClientTest-" + i);
            System.out.println("Reading Key: " + i + ", Value: " + val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        Option lock = new Option("k", "lock", false, "Dyno Lock");
        lock.setArgName("lock");
        Option primaryCluster = new Option("p", "primaryCluster", true, "Primary cluster");
        primaryCluster.setArgName("clusterName");
        Option secondaryCluster = new Option("s", "shadowCluster", true, "Shadow cluster");
        secondaryCluster.setArgName("clusterName");
        Option localhost = new Option("l", "localhost", false, "localhost");
        Option test = new Option("t", "test", true, "Test to run");
        test.setArgName("testNumber");
        test.setRequired(true);
        OptionGroup cluster = new OptionGroup().addOption(localhost).addOption(primaryCluster);
        cluster.setRequired(true);
        Options options = new Options();
        options.addOptionGroup(cluster).addOption(secondaryCluster).addOption(lock).addOption(test);
        Properties props = new Properties();
        props.load(DynoJedisDemo.class.getResourceAsStream("/demo.properties"));
        for (String name : props.stringPropertyNames()) {
            System.setProperty(name, props.getProperty(name));
        }
        if (!props.containsKey("EC2_AVAILABILITY_ZONE") && !props.containsKey("dyno.demo.lbStrategy")) {
            throw new IllegalArgumentException("MUST set local for load balancing OR set the load balancing strategy to round robin");
        }
        String rack = props.getProperty("EC2_AVAILABILITY_ZONE", "us-east-1c");
        String hostsFile = props.getProperty("dyno.demo.hostsFile");
        String shadowHostsFile = props.getProperty("dyno.demo.shadowHostsFile");
        int port = Integer.valueOf(props.getProperty("dyno.demo.port", "8102"));
        DynoJedisDemo demo = null;
        try {
            DefaultParser parser = new DefaultParser();
            CommandLine cli = parser.parse(options, args);
            int testNumber = Integer.parseInt(cli.getOptionValue("t"));
            boolean isLock = cli.hasOption("k");
            if (cli.hasOption("l")) {
                demo = new DynoJedisDemo("dyno-localhost", rack);
                demo.initWithLocalHost(isLock);
            } else if (cli.hasOption("l")) {
                demo = new DynoJedisDemo("dyno-localhost", rack);
                demo.initWithLocalHost(false);
            } else if (!cli.hasOption("s")) {
                demo = new DynoJedisDemo(cli.getOptionValue("p"), rack);
                if (hostsFile != null) {
                    demo.initWithRemoteClusterFromFile(hostsFile, port, isLock);
                } else {
                    demo.initWithRemoteClusterFromEurekaUrl(cli.getOptionValue("p"), port, isLock);
                }
            } else {
                demo = new DynoJedisDemo(cli.getOptionValue("p"), cli.getOptionValue("s"), rack);
                if (hostsFile != null) {
                    demo.initDualClientWithRemoteClustersFromFile(hostsFile, shadowHostsFile, port);
                } else {
                    demo.initDualClientWithRemoteClustersFromEurekaUrl(cli.getOptionValue("p"), cli.getOptionValue("s"));
                }
            }
            System.out.println("Connected");
            switch (testNumber) {
                case 1: {
                    demo.runSimpleTest();
                    break;
                }
                case 2: {
                    demo.runKeysTest();
                    break;
                }
                case 3: {
                    demo.runSimpleTestWithHashtag();
                    break;
                }
                case 4: {
                    demo.runMultiThreaded();
                    break;
                }
                case 5: {
                    boolean writeKeys = Boolean.valueOf(props.getProperty("dyno.demo.scan.populateKeys"));
                    demo.runScanTest(writeKeys);
                    break;
                }
                case 6: {
                    demo.runPipeline();
                    break;
                }
                case 7: {
                    demo.runPipelineWithHashtag();
                    break;
                }
                case 8: {
                    demo.runSScanTest(true);
                    break;
                }
                case 9: {
                    demo.runCompressionInPipelineTest();
                    break;
                }
                case 10: {
                    demo.runEvalTest();
                    demo.runEvalShaTest();
                    break;
                }
                case 11: {
                    demo.runBinaryKeyTest();
                    break;
                }
                case 12: {
                    demo.runExpireHashTest();
                    break;
                }
                case 13: {
                    demo.runJsonTest();
                    break;
                }
                case 14: {
                    demo.runLockTest();
                }
            }
            Thread.sleep(1000L);
        }
        catch (ParseException pe) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp(120, DynoJedisDemo.class.getSimpleName(), "", options, "", true);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (demo != null) {
                demo.stop();
            }
            System.out.println("Done");
            System.out.flush();
            System.err.flush();
            System.exit(0);
        }
    }

    private void runLockTest() throws InterruptedException {
        String resourceName = "testResource";
        long ttl = 5000L;
        boolean value = this.dynoLockClient.acquireLock(resourceName, ttl, resource -> logger.info("Extension failed"));
        if (value) {
            logger.info("Acquired lock on resource {} for {} ms ", (Object)resourceName, (Object)value);
        }
        this.dynoLockClient.logLocks();
        Thread.sleep(100000L);
        this.dynoLockClient.releaseLock(resourceName);
    }

    private class SAXHandler
    extends DefaultHandler {
        private final List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        private final String rootElement;
        private final Set<String> interestElements = new HashSet<String>();
        private Map<String, String> currentPayload = null;
        private String currentInterestElement = null;

        private SAXHandler(String root, String ... interests) {
            this.rootElement = root;
            for (String s : interests) {
                this.interestElements.add(s);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equalsIgnoreCase(this.rootElement)) {
                this.currentPayload = new HashMap<String, String>();
                return;
            }
            if (this.interestElements.contains(qName)) {
                this.currentInterestElement = qName;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equalsIgnoreCase(this.rootElement)) {
                this.list.add(this.currentPayload);
                this.currentPayload = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String value = new String(ch, start, length);
            if (this.currentInterestElement != null && this.currentPayload != null) {
                this.currentPayload.put(this.currentInterestElement, value);
                this.currentInterestElement = null;
            }
        }

        public List<Map<String, String>> getList() {
            return this.list;
        }
    }
}

