/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.jedis;

import com.netflix.dyno.connectionpool.CursorBasedResult;
import com.netflix.dyno.connectionpool.TokenRackMapper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.ScanResult;

public class CursorBasedResultImpl<T>
implements CursorBasedResult<T>,
TokenRackMapper {
    private final Map<String, ScanResult<T>> result;
    private Map<Long, String> tokenRackMap;

    CursorBasedResultImpl(Map<String, ScanResult<T>> result) {
        this.result = result;
        this.tokenRackMap = new LinkedHashMap<Long, String>();
    }

    CursorBasedResultImpl(Map<String, ScanResult<T>> result, Map<Long, String> tokenRackMap) {
        this.result = result;
        this.tokenRackMap = tokenRackMap;
    }

    public List<T> getResult() {
        ArrayList aggregated = new ArrayList();
        for (ScanResult<T> sr : this.result.values()) {
            aggregated.addAll(sr.getResult());
        }
        return aggregated;
    }

    public List<String> getStringResult() {
        ArrayList<String> aggregated = new ArrayList<String>();
        for (Map.Entry<String, ScanResult<T>> entry : this.result.entrySet()) {
            aggregated.add(String.format("%s -> %s", entry.getKey(), entry.getValue().getCursor()));
        }
        return aggregated;
    }

    public String getCursorForHost(String host) {
        ScanResult<T> sr = this.result.get(host);
        if (sr != null) {
            return sr.getCursor();
        }
        return "0";
    }

    public boolean isComplete() {
        for (ScanResult<T> r : this.result.values()) {
            if (r.getCursor().equals("0")) continue;
            return false;
        }
        return true;
    }

    public String getRackForToken(Long token) {
        return this.tokenRackMap.get(token);
    }

    public void setRackForToken(Long token, String rack) {
        this.tokenRackMap.put(token, rack);
    }

    public Map<Long, String> getTokenRackMap() {
        return this.tokenRackMap;
    }
}

