/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.jedis;

import com.netflix.dyno.connectionpool.ConnectionPool;
import com.netflix.dyno.connectionpool.ConnectionPoolMonitor;
import com.netflix.dyno.connectionpool.OperationResult;
import com.netflix.dyno.contrib.DynoOPMonitor;
import com.netflix.dyno.jedis.DynoDualWriterPipeline;
import com.netflix.dyno.jedis.DynoJedisClient;
import com.netflix.dyno.jedis.DynoJedisPipelineMonitor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

public class DynoDualWriterClient
extends DynoJedisClient {
    private static final Logger logger = LoggerFactory.getLogger(DynoDualWriterClient.class);
    private static ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    private final String appName;
    private final ConnectionPool<Jedis> connPool;
    private final DynoJedisClient shadowClient;
    private final Dial dial;
    private final AtomicReference<DynoJedisPipelineMonitor> pipelineMonitor = new AtomicReference();

    public DynoDualWriterClient(String name, String clusterName, ConnectionPool<Jedis> pool, DynoOPMonitor operationMonitor, ConnectionPoolMonitor connectionPoolMonitor, DynoJedisClient shadowClient) {
        this(name, clusterName, pool, operationMonitor, connectionPoolMonitor, shadowClient, new TimestampDial(pool.getConfiguration().getDualWritePercentage()));
    }

    public DynoDualWriterClient(String name, String clusterName, ConnectionPool<Jedis> pool, DynoOPMonitor operationMonitor, ConnectionPoolMonitor connectionPoolMonitor, DynoJedisClient shadowClient, Dial dial) {
        super(name, clusterName, pool, operationMonitor, connectionPoolMonitor);
        this.appName = name;
        this.connPool = pool;
        this.shadowClient = shadowClient;
        this.dial = dial;
    }

    public Dial getDial() {
        return this.dial;
    }

    private DynoJedisPipelineMonitor checkAndInitPipelineMonitor() {
        if (this.pipelineMonitor.get() != null) {
            return this.pipelineMonitor.get();
        }
        int flushTimerFrequency = this.connPool.getConfiguration().getTimingCountersResetFrequencySeconds();
        DynoJedisPipelineMonitor plMonitor = new DynoJedisPipelineMonitor(this.appName, flushTimerFrequency);
        boolean success = this.pipelineMonitor.compareAndSet(null, plMonitor);
        if (success) {
            this.pipelineMonitor.get().init();
        }
        return this.pipelineMonitor.get();
    }

    @Override
    public DynoDualWriterPipeline pipelined() {
        return new DynoDualWriterPipeline(this.appName, this.getConnPool(), this.checkAndInitPipelineMonitor(), this.getConnPool().getMonitor(), this.shadowClient.getConnPool(), this.dial);
    }

    private <R> Future<OperationResult<R>> writeAsync(String key, Callable<OperationResult<R>> func) {
        if (this.sendShadowRequest(key)) {
            try {
                return executor.submit(func);
            }
            catch (Throwable th) {
                this.opMonitor.recordFailure("shadowPool_submit", th.getMessage());
            }
        }
        return null;
    }

    private <R> Future<OperationResult<R>> writeAsync(byte[] key, Callable<OperationResult<R>> func) {
        if (this.sendShadowRequest(key)) {
            try {
                return executor.submit(func);
            }
            catch (Throwable th) {
                this.opMonitor.recordFailure("shadowPool_submit", th.getMessage());
            }
        }
        return null;
    }

    private boolean sendShadowRequest(String key) {
        return this.getConnPool().getConfiguration().isDualWriteEnabled() && !this.getConnPool().isIdle() && this.getConnPool().getActivePools().size() > 0 && this.dial.isInRange(key);
    }

    private boolean sendShadowRequest(byte[] key) {
        return this.getConnPool().getConfiguration().isDualWriteEnabled() && !this.getConnPool().isIdle() && this.getConnPool().getActivePools().size() > 0 && this.dial.isInRange(key);
    }

    @Override
    public Long append(String key, String value) {
        return (Long)this.d_append(key, value).getResult();
    }

    @Override
    public OperationResult<Long> d_append(final String key, final String value) {
        this.writeAsync(key, new Callable<OperationResult<Long>>(){

            @Override
            public OperationResult<Long> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_append(key, value);
            }
        });
        return DynoDualWriterClient.super.d_append(key, value);
    }

    @Override
    public OperationResult<String> d_hmset(final String key, final Map<String, String> hash) {
        this.writeAsync(key, new Callable<OperationResult<String>>(){

            @Override
            public OperationResult<String> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_hmset(key, hash);
            }
        });
        return DynoDualWriterClient.super.d_hmset(key, hash);
    }

    @Override
    public Long sadd(String key, String ... members) {
        return (Long)this.d_sadd(key, members).getResult();
    }

    @Override
    public OperationResult<Long> d_sadd(final String key, final String ... members) {
        this.writeAsync(key, new Callable<OperationResult<Long>>(){

            @Override
            public OperationResult<Long> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_sadd(key, members);
            }
        });
        return DynoDualWriterClient.super.d_sadd(key, members);
    }

    @Override
    public Long hset(String key, String field, String value) {
        return (Long)this.d_hset(key, field, value).getResult();
    }

    @Override
    public OperationResult<Long> d_hset(final String key, final String field, final String value) {
        this.writeAsync(key, new Callable<OperationResult<Long>>(){

            @Override
            public OperationResult<Long> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_hset(key, field, value);
            }
        });
        return DynoDualWriterClient.super.d_hset(key, field, value);
    }

    @Override
    public String set(String key, String value) {
        return (String)this.d_set(key, value).getResult();
    }

    @Override
    public OperationResult<String> d_set(final String key, final String value) {
        this.writeAsync(key, new Callable<OperationResult<String>>(){

            @Override
            public OperationResult<String> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_set(key, value);
            }
        });
        return DynoDualWriterClient.super.d_set(key, value);
    }

    @Override
    public String setex(String key, int seconds, String value) {
        return (String)this.d_setex(key, (Integer)seconds, value).getResult();
    }

    @Override
    public OperationResult<String> d_setex(final String key, final Integer seconds, final String value) {
        this.writeAsync(key, new Callable<OperationResult<String>>(){

            @Override
            public OperationResult<String> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_setex(key, seconds, value);
            }
        });
        return DynoDualWriterClient.super.d_setex(key, seconds, value);
    }

    @Override
    public Long del(final String key) {
        this.writeAsync(key, new Callable<OperationResult<Long>>(){

            @Override
            public OperationResult<Long> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_del(key);
            }
        });
        return DynoDualWriterClient.super.del(key);
    }

    @Override
    public Long expire(final String key, final int seconds) {
        this.writeAsync(key, new Callable<OperationResult<Long>>(){

            @Override
            public OperationResult<Long> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_expire(key, seconds);
            }
        });
        return DynoDualWriterClient.super.expire(key, seconds);
    }

    @Override
    public Long expireAt(final String key, final long unixTime) {
        this.writeAsync(key, new Callable<OperationResult<Long>>(){

            @Override
            public OperationResult<Long> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_expireAt(key, unixTime);
            }
        });
        return DynoDualWriterClient.super.expireAt(key, unixTime);
    }

    @Override
    public String getSet(final String key, final String value) {
        this.writeAsync(key, new Callable<OperationResult<String>>(){

            @Override
            public OperationResult<String> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_getSet(key, value);
            }
        });
        return DynoDualWriterClient.super.getSet(key, value);
    }

    @Override
    public Long hdel(final String key, final String ... fields) {
        this.writeAsync(key, new Callable<OperationResult<Long>>(){

            @Override
            public OperationResult<Long> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_hdel(key, fields);
            }
        });
        return DynoDualWriterClient.super.hdel(key, new String[0]);
    }

    @Override
    public Long hincrBy(final String key, final String field, final long value) {
        this.writeAsync(key, new Callable<OperationResult<Long>>(){

            @Override
            public OperationResult<Long> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_hincrBy(key, field, value);
            }
        });
        return DynoDualWriterClient.super.hincrBy(key, field, value);
    }

    @Override
    public Double hincrByFloat(final String key, final String field, final double value) {
        this.writeAsync(key, new Callable<OperationResult<Double>>(){

            @Override
            public OperationResult<Double> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_hincrByFloat(key, field, value);
            }
        });
        return DynoDualWriterClient.super.hincrByFloat(key, field, value);
    }

    @Override
    public Long hsetnx(final String key, final String field, final String value) {
        this.writeAsync(key, new Callable<OperationResult<Long>>(){

            @Override
            public OperationResult<Long> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_hsetnx(key, field, value);
            }
        });
        return DynoDualWriterClient.super.hsetnx(key, field, value);
    }

    @Override
    public Long incr(final String key) {
        this.writeAsync(key, new Callable<OperationResult<Long>>(){

            @Override
            public OperationResult<Long> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_incr(key);
            }
        });
        return DynoDualWriterClient.super.incr(key);
    }

    @Override
    public Long incrBy(final String key, final long delta) {
        this.writeAsync(key, new Callable<OperationResult<Long>>(){

            @Override
            public OperationResult<Long> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_incrBy(key, delta);
            }
        });
        return DynoDualWriterClient.super.incrBy(key, delta);
    }

    @Override
    public Double incrByFloat(final String key, final double increment) {
        this.writeAsync(key, new Callable<OperationResult<Double>>(){

            @Override
            public OperationResult<Double> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_incrByFloat(key, increment);
            }
        });
        return DynoDualWriterClient.super.incrByFloat(key, increment);
    }

    @Override
    public String lpop(final String key) {
        this.writeAsync(key, new Callable<OperationResult<String>>(){

            @Override
            public OperationResult<String> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_lpop(key);
            }
        });
        return DynoDualWriterClient.super.lpop(key);
    }

    @Override
    public Long lpush(final String key, final String ... values) {
        this.writeAsync(key, new Callable<OperationResult<Long>>(){

            @Override
            public OperationResult<Long> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_lpush(key, values);
            }
        });
        return DynoDualWriterClient.super.lpush(key, values);
    }

    @Override
    public Long lrem(final String key, final long count, final String value) {
        this.writeAsync(key, new Callable<OperationResult<Long>>(){

            @Override
            public OperationResult<Long> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_lrem(key, count, value);
            }
        });
        return DynoDualWriterClient.super.lrem(key, count, value);
    }

    @Override
    public String lset(final String key, final long count, final String value) {
        this.writeAsync(key, new Callable<OperationResult<String>>(){

            @Override
            public OperationResult<String> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_lset(key, count, value);
            }
        });
        return DynoDualWriterClient.super.lset(key, count, value);
    }

    @Override
    public String ltrim(final String key, final long start, final long end) {
        this.writeAsync(key, new Callable<OperationResult<String>>(){

            @Override
            public OperationResult<String> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_ltrim(key, start, end);
            }
        });
        return DynoDualWriterClient.super.ltrim(key, start, end);
    }

    @Override
    public Long persist(final String key) {
        this.writeAsync(key, new Callable<OperationResult<Long>>(){

            @Override
            public OperationResult<Long> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_persist(key);
            }
        });
        return DynoDualWriterClient.super.persist(key);
    }

    @Override
    public Long pexpireAt(final String key, final long millisecondsTimestamp) {
        this.writeAsync(key, new Callable<OperationResult<Long>>(){

            @Override
            public OperationResult<Long> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_pexpireAt(key, millisecondsTimestamp);
            }
        });
        return DynoDualWriterClient.super.pexpireAt(key, millisecondsTimestamp);
    }

    @Override
    public Long pttl(final String key) {
        this.writeAsync(key, new Callable<OperationResult<Long>>(){

            @Override
            public OperationResult<Long> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_pttl(key);
            }
        });
        return DynoDualWriterClient.super.pttl(key);
    }

    @Override
    public String rename(final String oldkey, String newkey) {
        this.writeAsync(oldkey, new Callable<OperationResult<String>>(){

            @Override
            public OperationResult<String> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_rename(oldkey, oldkey);
            }
        });
        return DynoDualWriterClient.super.rename(oldkey, oldkey);
    }

    @Override
    public String rpop(final String key) {
        this.writeAsync(key, new Callable<OperationResult<String>>(){

            @Override
            public OperationResult<String> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_rpop(key);
            }
        });
        return DynoDualWriterClient.super.rpop(key);
    }

    @Override
    public Long scard(final String key) {
        this.writeAsync(key, new Callable<OperationResult<Long>>(){

            @Override
            public OperationResult<Long> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_scard(key);
            }
        });
        return DynoDualWriterClient.super.scard(key);
    }

    @Override
    public Boolean setbit(final String key, final long offset, final boolean value) {
        this.writeAsync(key, new Callable<OperationResult<Boolean>>(){

            @Override
            public OperationResult<Boolean> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_setbit(key, (Long)offset, value);
            }
        });
        return DynoDualWriterClient.super.setbit(key, offset, value);
    }

    @Override
    public Boolean setbit(final String key, final long offset, final String value) {
        this.writeAsync(key, new Callable<OperationResult<Boolean>>(){

            @Override
            public OperationResult<Boolean> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_setbit(key, (Long)offset, value);
            }
        });
        return DynoDualWriterClient.super.setbit(key, offset, value);
    }

    @Override
    public Long setnx(final String key, final String value) {
        this.writeAsync(key, new Callable<OperationResult<Long>>(){

            @Override
            public OperationResult<Long> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_setnx(key, value);
            }
        });
        return DynoDualWriterClient.super.setnx(key, value);
    }

    @Override
    public Long setrange(final String key, final long offset, final String value) {
        this.writeAsync(key, new Callable<OperationResult<Long>>(){

            @Override
            public OperationResult<Long> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_setrange(key, offset, value);
            }
        });
        return DynoDualWriterClient.super.setrange(key, offset, value);
    }

    @Override
    public Set<String> smembers(final String key) {
        this.writeAsync(key, new Callable<OperationResult<Set<String>>>(){

            @Override
            public OperationResult<Set<String>> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_smembers(key);
            }
        });
        return DynoDualWriterClient.super.smembers(key);
    }

    @Override
    public Long smove(final String srckey, final String dstkey, final String member) {
        this.writeAsync(srckey, new Callable<OperationResult<Long>>(){

            @Override
            public OperationResult<Long> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_smove(srckey, dstkey, member);
            }
        });
        return DynoDualWriterClient.super.smove(srckey, dstkey, member);
    }

    @Override
    public List<String> sort(final String key) {
        this.writeAsync(key, new Callable<OperationResult<List<String>>>(){

            @Override
            public OperationResult<List<String>> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_sort(key);
            }
        });
        return DynoDualWriterClient.super.sort(key);
    }

    @Override
    public String spop(final String key) {
        this.writeAsync(key, new Callable<OperationResult<String>>(){

            @Override
            public OperationResult<String> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_spop(key);
            }
        });
        return DynoDualWriterClient.super.spop(key);
    }

    @Override
    public Long srem(final String key, final String ... members) {
        this.writeAsync(key, new Callable<OperationResult<Long>>(){

            @Override
            public OperationResult<Long> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_srem(key, members);
            }
        });
        return DynoDualWriterClient.super.srem(key, members);
    }

    @Override
    public ScanResult<String> sscan(final String key, final String cursor) {
        this.writeAsync(key, new Callable<OperationResult<ScanResult<String>>>(){

            @Override
            public OperationResult<ScanResult<String>> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_sscan(key, cursor);
            }
        });
        return DynoDualWriterClient.super.sscan(key, cursor);
    }

    @Override
    public ScanResult<String> sscan(final String key, final String cursor, final ScanParams params) {
        this.writeAsync(key, new Callable<OperationResult<ScanResult<String>>>(){

            @Override
            public OperationResult<ScanResult<String>> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_sscan(key, cursor, params);
            }
        });
        return DynoDualWriterClient.super.sscan(key, cursor, params);
    }

    @Override
    public Long ttl(final String key) {
        this.writeAsync(key, new Callable<OperationResult<Long>>(){

            @Override
            public OperationResult<Long> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_ttl(key);
            }
        });
        return DynoDualWriterClient.super.ttl(key);
    }

    @Override
    public Long zadd(final String key, final double score, final String member) {
        this.writeAsync(key, new Callable<OperationResult<Long>>(){

            @Override
            public OperationResult<Long> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_zadd(key, score, member);
            }
        });
        return DynoDualWriterClient.super.zadd(key, score, member);
    }

    @Override
    public Long zadd(final String key, final Map<String, Double> scoreMembers) {
        this.writeAsync(key, new Callable<OperationResult<Long>>(){

            @Override
            public OperationResult<Long> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_zadd(key, scoreMembers);
            }
        });
        return DynoDualWriterClient.super.zadd(key, scoreMembers);
    }

    @Override
    public Double zincrby(final String key, final double score, final String member) {
        this.writeAsync(key, new Callable<OperationResult<Double>>(){

            @Override
            public OperationResult<Double> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_zincrby(key, score, member);
            }
        });
        return DynoDualWriterClient.super.zincrby(key, score, member);
    }

    @Override
    public Long zrem(final String key, final String ... member) {
        this.writeAsync(key, new Callable<OperationResult<Long>>(){

            @Override
            public OperationResult<Long> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_zrem(key, member);
            }
        });
        return DynoDualWriterClient.super.zrem(key, member);
    }

    @Override
    public List<String> blpop(final int timeout, final String key) {
        this.writeAsync(key, new Callable<OperationResult<List<String>>>(){

            @Override
            public OperationResult<List<String>> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_blpop(timeout, key);
            }
        });
        return DynoDualWriterClient.super.blpop(timeout, key);
    }

    @Override
    public List<String> brpop(final int timeout, final String key) {
        this.writeAsync(key, new Callable<OperationResult<List<String>>>(){

            @Override
            public OperationResult<List<String>> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_brpop(timeout, key);
            }
        });
        return DynoDualWriterClient.super.brpop(timeout, key);
    }

    @Override
    public String set(final byte[] key, final byte[] value) {
        this.writeAsync(key, new Callable<OperationResult<String>>(){

            @Override
            public OperationResult<String> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_set(key, value);
            }
        });
        return DynoDualWriterClient.super.set(key, value);
    }

    @Override
    public String setex(final byte[] key, final int seconds, final byte[] value) {
        this.writeAsync(key, new Callable<OperationResult<String>>(){

            @Override
            public OperationResult<String> call() throws Exception {
                return DynoDualWriterClient.this.shadowClient.d_setex(key, (Integer)seconds, value);
            }
        });
        return DynoDualWriterClient.super.setex(key, seconds, value);
    }

    private static class TimestampDial
    implements Dial {
        private final AtomicInteger range = new AtomicInteger(1);

        public TimestampDial(int range) {
            this.range.set(range);
        }

        @Override
        public boolean isInRange(String key) {
            return (long)this.range.get() > System.currentTimeMillis() % 100L;
        }

        @Override
        public boolean isInRange(byte[] key) {
            return (long)this.range.get() > System.currentTimeMillis() % 100L;
        }

        @Override
        public void setRange(int range) {
            this.range.set(range);
        }
    }

    public static interface Dial {
        public boolean isInRange(String var1);

        public boolean isInRange(byte[] var1);

        public void setRange(int var1);
    }
}

