/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.jedis;

import com.netflix.dyno.connectionpool.ConnectionPoolMonitor;
import com.netflix.dyno.connectionpool.impl.ConnectionPoolImpl;
import com.netflix.dyno.jedis.DynoDualWriterClient;
import com.netflix.dyno.jedis.DynoJedisPipeline;
import com.netflix.dyno.jedis.DynoJedisPipelineMonitor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.Response;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;

public class DynoDualWriterPipeline
extends DynoJedisPipeline {
    private static final Logger logger = LoggerFactory.getLogger(DynoDualWriterPipeline.class);
    private static ExecutorService executor = Executors.newSingleThreadExecutor();
    private final ConnectionPoolImpl<Jedis> connPool;
    private final DynoJedisPipeline shadowPipeline;
    private final DynoDualWriterClient.Dial dial;

    DynoDualWriterPipeline(String appName, ConnectionPoolImpl<Jedis> pool, DynoJedisPipelineMonitor operationMonitor, ConnectionPoolMonitor connPoolMonitor, ConnectionPoolImpl<Jedis> shadowConnectionPool, DynoDualWriterClient.Dial dial) {
        super(pool, operationMonitor, connPoolMonitor);
        this.connPool = pool;
        this.dial = dial;
        int flushTimerFrequency = shadowConnectionPool.getConfiguration().getTimingCountersResetFrequencySeconds();
        DynoJedisPipelineMonitor shadowOperationMonitor = new DynoJedisPipelineMonitor(appName, flushTimerFrequency);
        this.shadowPipeline = new DynoJedisPipeline(shadowConnectionPool, shadowOperationMonitor, shadowConnectionPool.getMonitor());
    }

    private ConnectionPoolImpl<Jedis> getConnPool() {
        return this.connPool;
    }

    private <R> Future<Response<R>> writeAsync(String key, Callable<Response<R>> func) {
        if (this.canSendShadowRequest(key)) {
            return executor.submit(func);
        }
        return null;
    }

    private <R> Future<Response<R>> writeAsync(byte[] key, Callable<Response<R>> func) {
        if (this.canSendShadowRequest(key)) {
            return executor.submit(func);
        }
        return null;
    }

    private <R> Future<R> scheduleAsync(Callable<R> func) {
        return executor.submit(func);
    }

    private boolean canSendShadowRequest(String key) {
        return this.getConnPool().getConfiguration().isDualWriteEnabled() && !this.getConnPool().isIdle() && this.getConnPool().getActivePools().size() > 0 && this.dial.isInRange(key);
    }

    private boolean canSendShadowRequest(byte[] key) {
        return this.getConnPool().getConfiguration().isDualWriteEnabled() && !this.getConnPool().isIdle() && this.getConnPool().getActivePools().size() > 0 && this.dial.isInRange(key);
    }

    @Override
    public void sync() {
        this.scheduleAsync(() -> {
            this.shadowPipeline.sync();
            return null;
        });
        super.sync();
    }

    @Override
    public List<Object> syncAndReturnAll() {
        this.scheduleAsync(() -> {
            this.shadowPipeline.sync();
            return null;
        });
        return super.syncAndReturnAll();
    }

    @Override
    public void discardPipelineAndReleaseConnection() {
        this.scheduleAsync(() -> {
            this.shadowPipeline.discardPipelineAndReleaseConnection();
            return null;
        });
        super.discardPipelineAndReleaseConnection();
    }

    @Override
    public void close() throws Exception {
        this.shadowPipeline.close();
        super.close();
    }

    @Override
    public Response<Long> append(String key, String value) {
        this.writeAsync(key, () -> this.shadowPipeline.append(key, value));
        return DynoDualWriterPipeline.super.append(key, value);
    }

    @Override
    public Response<List<String>> blpop(String arg) {
        this.writeAsync(arg, () -> this.shadowPipeline.blpop(arg));
        return DynoDualWriterPipeline.super.blpop(arg);
    }

    @Override
    public Response<List<String>> brpop(String arg) {
        this.writeAsync(arg, () -> this.shadowPipeline.brpop(arg));
        return DynoDualWriterPipeline.super.brpop(arg);
    }

    @Override
    public Response<Long> decr(String key) {
        this.writeAsync(key, () -> this.shadowPipeline.decr(key));
        return DynoDualWriterPipeline.super.decr(key);
    }

    @Override
    public Response<Long> decrBy(String key, long integer) {
        this.writeAsync(key, () -> this.shadowPipeline.decrBy(key, integer));
        return DynoDualWriterPipeline.super.decrBy(key, integer);
    }

    @Override
    public Response<Long> del(String key) {
        this.writeAsync(key, () -> this.shadowPipeline.del(key));
        return DynoDualWriterPipeline.super.del(key);
    }

    @Override
    public Response<Long> expire(String key, int seconds) {
        this.writeAsync(key, () -> this.shadowPipeline.expire(key, seconds));
        return DynoDualWriterPipeline.super.expire(key, seconds);
    }

    @Override
    public Response<Long> pexpire(String key, long milliseconds) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> expireAt(String key, long unixTime) {
        this.writeAsync(key, () -> this.shadowPipeline.expireAt(key, unixTime));
        return DynoDualWriterPipeline.super.expireAt(key, unixTime);
    }

    @Override
    public Response<Long> pexpireAt(String key, long millisecondsTimestamp) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> hdel(String key, String ... field) {
        this.writeAsync(key, () -> this.shadowPipeline.hdel(key, field));
        return DynoDualWriterPipeline.super.hdel(key, field);
    }

    @Override
    public Response<Long> hincrBy(String key, String field, long value) {
        this.writeAsync(key, () -> this.shadowPipeline.hincrBy(key, field, value));
        return DynoDualWriterPipeline.super.hincrBy(key, field, value);
    }

    @Override
    public Response<Double> hincrByFloat(String key, String field, double value) {
        this.writeAsync(key, () -> this.shadowPipeline.hincrByFloat(key, field, value));
        return DynoDualWriterPipeline.super.hincrByFloat(key, field, value);
    }

    @Override
    public Response<String> hmset(byte[] key, Map<byte[], byte[]> hash) {
        this.writeAsync(key, () -> this.shadowPipeline.hmset(key, hash));
        return DynoDualWriterPipeline.super.hmset(key, hash);
    }

    @Override
    public Response<String> hmset(String key, Map<String, String> hash) {
        this.writeAsync(key, () -> this.shadowPipeline.hmset(key, hash));
        return DynoDualWriterPipeline.super.hmset(key, hash);
    }

    @Override
    public Response<Long> hset(String key, String field, String value) {
        this.writeAsync(key, () -> this.shadowPipeline.hset(key, field, value));
        return DynoDualWriterPipeline.super.hset(key, field, value);
    }

    @Override
    public Response<Long> hset(byte[] key, byte[] field, byte[] value) {
        this.writeAsync(key, () -> this.shadowPipeline.hset(key, field, value));
        return DynoDualWriterPipeline.super.hset(key, field, value);
    }

    @Override
    public Response<Long> hsetnx(String key, String field, String value) {
        this.writeAsync(key, () -> this.shadowPipeline.hsetnx(key, field, value));
        return DynoDualWriterPipeline.super.hsetnx(key, field, value);
    }

    @Override
    public Response<Long> incr(String key) {
        this.writeAsync(key, () -> this.shadowPipeline.incr(key));
        return DynoDualWriterPipeline.super.incr(key);
    }

    @Override
    public Response<Long> incrBy(String key, long integer) {
        this.writeAsync(key, () -> this.shadowPipeline.incrBy(key, integer));
        return DynoDualWriterPipeline.super.incrBy(key, integer);
    }

    @Override
    public Response<Double> incrByFloat(String key, double increment) {
        this.writeAsync(key, () -> this.shadowPipeline.incrByFloat(key, increment));
        return DynoDualWriterPipeline.super.incrByFloat(key, increment);
    }

    @Override
    public Response<Long> linsert(String key, ListPosition where, String pivot, String value) {
        this.writeAsync(key, () -> this.shadowPipeline.linsert(key, where, pivot, value));
        return DynoDualWriterPipeline.super.linsert(key, where, pivot, value);
    }

    @Override
    public Response<String> lpop(String key) {
        this.writeAsync(key, () -> this.shadowPipeline.lpop(key));
        return DynoDualWriterPipeline.super.lpop(key);
    }

    @Override
    public Response<Long> lpush(String key, String ... string) {
        this.writeAsync(key, () -> this.shadowPipeline.lpush(key, string));
        return DynoDualWriterPipeline.super.lpush(key, string);
    }

    @Override
    public Response<Long> lpushx(String key, String ... string) {
        this.writeAsync(key, () -> this.shadowPipeline.lpushx(key, string));
        return DynoDualWriterPipeline.super.lpushx(key, string);
    }

    @Override
    public Response<Long> lrem(String key, long count, String value) {
        this.writeAsync(key, () -> this.shadowPipeline.lrem(key, count, value));
        return DynoDualWriterPipeline.super.lrem(key, count, value);
    }

    @Override
    public Response<String> lset(String key, long index, String value) {
        this.writeAsync(key, () -> this.shadowPipeline.lset(key, index, value));
        return DynoDualWriterPipeline.super.lset(key, index, value);
    }

    @Override
    public Response<String> ltrim(String key, long start, long end) {
        this.writeAsync(key, () -> this.shadowPipeline.ltrim(key, start, end));
        return DynoDualWriterPipeline.super.ltrim(key, start, end);
    }

    @Override
    public Response<Long> move(String key, int dbIndex) {
        this.writeAsync(key, () -> this.shadowPipeline.move(key, dbIndex));
        return DynoDualWriterPipeline.super.move(key, dbIndex);
    }

    @Override
    public Response<Long> persist(String key) {
        this.writeAsync(key, () -> this.shadowPipeline.persist(key));
        return DynoDualWriterPipeline.super.persist(key);
    }

    @Override
    public Response<String> rename(String oldkey, String newkey) {
        this.writeAsync(newkey, () -> this.shadowPipeline.rename(oldkey, newkey));
        return DynoDualWriterPipeline.super.rename(oldkey, newkey);
    }

    @Override
    public Response<Long> renamenx(String oldkey, String newkey) {
        this.writeAsync(newkey, () -> this.shadowPipeline.renamenx(oldkey, newkey));
        return DynoDualWriterPipeline.super.renamenx(oldkey, newkey);
    }

    @Override
    public Response<String> rpop(String key) {
        this.writeAsync(key, () -> this.shadowPipeline.rpop(key));
        return DynoDualWriterPipeline.super.rpop(key);
    }

    @Override
    public Response<Long> rpush(String key, String ... string) {
        this.writeAsync(key, () -> this.shadowPipeline.rpush(key, string));
        return DynoDualWriterPipeline.super.rpush(key, string);
    }

    @Override
    public Response<Long> rpushx(String key, String ... string) {
        this.writeAsync(key, () -> this.shadowPipeline.rpushx(key, string));
        return DynoDualWriterPipeline.super.rpushx(key, string);
    }

    @Override
    public Response<Long> sadd(String key, String ... member) {
        this.writeAsync(key, () -> this.shadowPipeline.sadd(key, member));
        return DynoDualWriterPipeline.super.sadd(key, member);
    }

    @Override
    public Response<String> set(String key, String value) {
        this.writeAsync(key, () -> this.shadowPipeline.set(key, value));
        return DynoDualWriterPipeline.super.set(key, value);
    }

    @Override
    public Response<Boolean> setbit(String key, long offset, boolean value) {
        this.writeAsync(key, () -> this.shadowPipeline.setbit(key, offset, value));
        return DynoDualWriterPipeline.super.setbit(key, offset, value);
    }

    @Override
    public Response<String> setex(String key, int seconds, String value) {
        this.writeAsync(key, () -> this.shadowPipeline.setex(key, seconds, value));
        return DynoDualWriterPipeline.super.setex(key, seconds, value);
    }

    @Override
    public Response<Long> setnx(String key, String value) {
        this.writeAsync(key, () -> this.shadowPipeline.setnx(key, value));
        return DynoDualWriterPipeline.super.setnx(key, value);
    }

    @Override
    public Response<Long> setrange(String key, long offset, String value) {
        this.writeAsync(key, () -> this.shadowPipeline.setrange(key, offset, value));
        return DynoDualWriterPipeline.super.setrange(key, offset, value);
    }

    @Override
    public Response<List<String>> sort(String key) {
        this.writeAsync(key, () -> this.shadowPipeline.sort(key));
        return DynoDualWriterPipeline.super.sort(key);
    }

    @Override
    public Response<List<String>> sort(String key, SortingParams sortingParameters) {
        this.writeAsync(key, () -> this.shadowPipeline.sort(key, sortingParameters));
        return DynoDualWriterPipeline.super.sort(key, sortingParameters);
    }

    @Override
    public Response<String> spop(String key) {
        this.writeAsync(key, () -> this.shadowPipeline.spop(key));
        return DynoDualWriterPipeline.super.spop(key);
    }

    @Override
    public Response<Set<String>> spop(String key, long count) {
        this.writeAsync(key, () -> this.shadowPipeline.spop(key, count));
        return DynoDualWriterPipeline.super.spop(key, count);
    }

    @Override
    public Response<Long> srem(String key, String ... member) {
        this.writeAsync(key, () -> this.shadowPipeline.srem(key, member));
        return DynoDualWriterPipeline.super.srem(key, member);
    }

    @Override
    public Response<ScanResult<String>> sscan(String key, int cursor) {
        throw new UnsupportedOperationException("'SSCAN' cannot be called in pipeline");
    }

    @Override
    public Response<ScanResult<String>> sscan(String key, String cursor) {
        throw new UnsupportedOperationException("'SSCAN' cannot be called in pipeline");
    }

    @Override
    public Response<Long> zadd(String key, double score, String member) {
        this.writeAsync(key, () -> this.shadowPipeline.zadd(key, score, member));
        return DynoDualWriterPipeline.super.zadd(key, score, member);
    }

    @Override
    public Response<Long> zadd(String key, Map<String, Double> scoreMembers) {
        this.writeAsync(key, () -> this.shadowPipeline.zadd(key, scoreMembers));
        return DynoDualWriterPipeline.super.zadd(key, scoreMembers);
    }

    @Override
    public Response<Double> zincrby(String key, double score, String member) {
        this.writeAsync(key, () -> this.shadowPipeline.zincrby(key, score, member));
        return DynoDualWriterPipeline.super.zincrby(key, score, member);
    }

    @Override
    public Response<Long> zrem(String key, String ... member) {
        this.writeAsync(key, () -> this.shadowPipeline.zrem(key, member));
        return DynoDualWriterPipeline.super.zrem(key, member);
    }

    @Override
    public Response<Long> zremrangeByRank(String key, long start, long end) {
        this.writeAsync(key, () -> this.shadowPipeline.zremrangeByRank(key, start, end));
        return DynoDualWriterPipeline.super.zremrangeByRank(key, start, end);
    }

    @Override
    public Response<Long> zremrangeByScore(String key, double start, double end) {
        this.writeAsync(key, () -> this.shadowPipeline.zremrangeByScore(key, start, end));
        return DynoDualWriterPipeline.super.zremrangeByScore(key, start, end);
    }

    @Override
    public Response<ScanResult<Tuple>> zscan(String key, int cursor) {
        throw new UnsupportedOperationException("'ZSCAN' cannot be called in pipeline");
    }

    @Override
    public Response<Long> zlexcount(String key, String min, String max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<String>> zrangeByLex(String key, String min, String max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<String>> zrangeByLex(String key, String min, String max, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> zremrangeByLex(String key, String start, String end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<String> set(byte[] key, byte[] value) {
        this.writeAsync(key, () -> this.shadowPipeline.set(key, value));
        return DynoDualWriterPipeline.super.set(key, value);
    }

    @Override
    public Response<Long> pfadd(String key, String ... elements) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> pfcount(String key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<List<Long>> bitfield(String key, String ... arguments) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<String>> zrevrangeByLex(String key, String max, String min) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<String>> zrevrangeByLex(String key, String max, String min, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> geoadd(String arg0, Map<String, GeoCoordinate> arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> geoadd(String arg0, double arg1, double arg2, String arg3) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Double> geodist(String arg0, String arg1, String arg2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Double> geodist(String arg0, String arg1, String arg2, GeoUnit arg3) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<List<String>> geohash(String arg0, String ... arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<List<GeoCoordinate>> geopos(String arg0, String ... arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadius(String arg0, double arg1, double arg2, double arg3, GeoUnit arg4) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadius(String arg0, double arg1, double arg2, double arg3, GeoUnit arg4, GeoRadiusParam arg5) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMember(String arg0, String arg1, double arg2, GeoUnit arg3) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMember(String arg0, String arg1, double arg2, GeoUnit arg3, GeoRadiusParam arg4) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> zadd(String arg0, Map<String, Double> arg1, ZAddParams arg2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> zadd(String key, double score, String member, ZAddParams params) {
        this.writeAsync(key, () -> this.shadowPipeline.zadd(key, score, member, params));
        return DynoDualWriterPipeline.super.zadd(key, score, member, params);
    }

    @Override
    public Response<Double> zincrby(String arg0, double arg1, String arg2, ZIncrByParams arg3) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> append(byte[] key, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<List<byte[]>> blpop(byte[] arg) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<List<byte[]>> brpop(byte[] arg) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> decr(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> decrBy(byte[] key, long integer) {
        this.writeAsync(key, () -> this.shadowPipeline.decrBy(key, integer));
        return DynoDualWriterPipeline.super.decrBy(key, integer);
    }

    @Override
    public Response<Long> del(byte[] key) {
        this.writeAsync(key, () -> this.shadowPipeline.del(key));
        return DynoDualWriterPipeline.super.del(key);
    }

    @Override
    public Response<byte[]> echo(byte[] string) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> expire(byte[] key, int seconds) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> pexpire(byte[] key, long milliseconds) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> expireAt(byte[] key, long unixTime) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> pexpireAt(byte[] key, long millisecondsTimestamp) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Boolean> getbit(byte[] key, long offset) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<byte[]> getSet(byte[] key, byte[] value) {
        this.writeAsync(key, () -> this.shadowPipeline.getSet(key, value));
        return DynoDualWriterPipeline.super.getSet(key, value);
    }

    @Override
    public Response<byte[]> getrange(byte[] key, long startOffset, long endOffset) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> hdel(byte[] key, byte[] ... field) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Boolean> hexists(byte[] key, byte[] field) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> hincrBy(byte[] key, byte[] field, long value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<byte[]>> hkeys(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> hlen(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> hsetnx(byte[] key, byte[] field, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<List<byte[]>> hvals(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> incr(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> incrBy(byte[] key, long integer) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<byte[]> lindex(byte[] key, long index) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> linsert(byte[] key, ListPosition where, byte[] pivot, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> llen(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<byte[]> lpop(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> lpush(byte[] key, byte[] ... string) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> lpushx(byte[] key, byte[] ... bytes) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<List<byte[]>> lrange(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> lrem(byte[] key, long count, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<String> lset(byte[] key, long index, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<String> ltrim(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> move(byte[] key, int dbIndex) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> persist(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<byte[]> rpop(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> rpush(byte[] key, byte[] ... string) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> rpushx(byte[] key, byte[] ... string) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> sadd(byte[] key, byte[] ... member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> scard(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Boolean> setbit(byte[] key, long offset, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> setrange(byte[] key, long offset, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<String> setex(byte[] key, int seconds, byte[] value) {
        this.writeAsync(key, () -> this.shadowPipeline.setex(key, seconds, value));
        return DynoDualWriterPipeline.super.setex(key, seconds, value);
    }

    @Override
    public Response<Long> setnx(byte[] key, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<byte[]>> smembers(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Boolean> sismember(byte[] key, byte[] member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<List<byte[]>> sort(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<List<byte[]>> sort(byte[] key, SortingParams sortingParameters) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<byte[]> spop(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<byte[]>> spop(byte[] key, long count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<byte[]> srandmember(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> srem(byte[] key, byte[] ... member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> strlen(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<String> substr(byte[] key, int start, int end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> ttl(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<String> type(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> zadd(byte[] key, double score, byte[] member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> zadd(byte[] key, double score, byte[] member, ZAddParams params) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> zadd(byte[] key, Map<byte[], Double> scoreMembers) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> zadd(byte[] key, Map<byte[], Double> scoreMembers, ZAddParams params) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> zcard(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> zcount(byte[] key, double min, double max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Double> zincrby(byte[] key, double score, byte[] member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Double> zincrby(byte[] key, double score, byte[] member, ZIncrByParams params) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<byte[]>> zrange(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<byte[]>> zrangeByScore(byte[] key, double min, double max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<byte[]>> zrangeByScore(byte[] key, byte[] min, byte[] max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<byte[]>> zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<byte[]>> zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, double min, double max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, double max, double min) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, byte[] max, byte[] min) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, double max, double min, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, double max, double min) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<Tuple>> zrangeWithScores(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> zrank(byte[] key, byte[] member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> zrem(byte[] key, byte[] ... member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> zremrangeByRank(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> zremrangeByScore(byte[] key, double start, double end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> zremrangeByScore(byte[] key, byte[] start, byte[] end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<byte[]>> zrevrange(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<Tuple>> zrevrangeWithScores(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> zrevrank(byte[] key, byte[] member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Double> zscore(byte[] key, byte[] member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> zlexcount(byte[] key, byte[] min, byte[] max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<byte[]>> zrangeByLex(byte[] key, byte[] min, byte[] max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<byte[]>> zrangeByLex(byte[] key, byte[] min, byte[] max, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<byte[]>> zrevrangeByLex(byte[] key, byte[] max, byte[] min) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Set<byte[]>> zrevrangeByLex(byte[] key, byte[] max, byte[] min, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> zremrangeByLex(byte[] key, byte[] min, byte[] max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> bitcount(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> bitcount(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> pfadd(byte[] key, byte[] ... elements) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> pfcount(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> geoadd(byte[] key, double longitude, double latitude, byte[] member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Long> geoadd(byte[] key, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Double> geodist(byte[] key, byte[] member1, byte[] member2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<Double> geodist(byte[] key, byte[] member1, byte[] member2, GeoUnit unit) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<List<byte[]>> geohash(byte[] key, byte[] ... members) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<List<GeoCoordinate>> geopos(byte[] key, byte[] ... members) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Response<List<Long>> bitfield(byte[] key, byte[] ... elements) {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

