/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.jedis;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClient;
import com.netflix.dyno.connectionpool.CompressionOperation;
import com.netflix.dyno.connectionpool.ConnectionContext;
import com.netflix.dyno.connectionpool.ConnectionPool;
import com.netflix.dyno.connectionpool.ConnectionPoolConfiguration;
import com.netflix.dyno.connectionpool.ConnectionPoolMonitor;
import com.netflix.dyno.connectionpool.CursorBasedResult;
import com.netflix.dyno.connectionpool.HostSupplier;
import com.netflix.dyno.connectionpool.MultiKeyCompressionOperation;
import com.netflix.dyno.connectionpool.Operation;
import com.netflix.dyno.connectionpool.OperationResult;
import com.netflix.dyno.connectionpool.TokenMapSupplier;
import com.netflix.dyno.connectionpool.TokenRackMapper;
import com.netflix.dyno.connectionpool.TopologyView;
import com.netflix.dyno.connectionpool.exception.DynoConnectException;
import com.netflix.dyno.connectionpool.exception.DynoException;
import com.netflix.dyno.connectionpool.impl.ConnectionPoolConfigurationImpl;
import com.netflix.dyno.connectionpool.impl.ConnectionPoolImpl;
import com.netflix.dyno.connectionpool.impl.utils.CollectionUtils;
import com.netflix.dyno.connectionpool.impl.utils.ZipUtils;
import com.netflix.dyno.contrib.ArchaiusConnectionPoolConfiguration;
import com.netflix.dyno.contrib.DynoCPMonitor;
import com.netflix.dyno.contrib.DynoOPMonitor;
import com.netflix.dyno.contrib.EurekaHostsSupplier;
import com.netflix.dyno.jedis.CursorBasedResultImpl;
import com.netflix.dyno.jedis.DynoDualWriterClient;
import com.netflix.dyno.jedis.DynoJedisCommands;
import com.netflix.dyno.jedis.DynoJedisPipeline;
import com.netflix.dyno.jedis.DynoJedisPipelineMonitor;
import com.netflix.dyno.jedis.DynoJedisUtils;
import com.netflix.dyno.jedis.JedisGenericOperation;
import com.netflix.dyno.jedis.OpName;
import com.netflix.dyno.jedis.operation.BaseKeyOperation;
import com.netflix.dyno.jedis.operation.MultiKeyOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.Response;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.commands.BinaryJedisCommands;
import redis.clients.jedis.commands.JedisCommands;
import redis.clients.jedis.commands.MultiKeyBinaryCommands;
import redis.clients.jedis.commands.MultiKeyCommands;
import redis.clients.jedis.commands.ScriptingCommands;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;

public class DynoJedisClient
implements JedisCommands,
BinaryJedisCommands,
MultiKeyCommands,
ScriptingCommands,
MultiKeyBinaryCommands,
DynoJedisCommands {
    private static final Logger Logger = LoggerFactory.getLogger(DynoJedisClient.class);
    private static final String DYNO_EXIPREHASH_METADATA_KEYPREFIX = "_metadata:";
    private final String appName;
    private final String clusterName;
    private final ConnectionPool<Jedis> connPool;
    private final AtomicReference<DynoJedisPipelineMonitor> pipelineMonitor = new AtomicReference();
    protected final DynoOPMonitor opMonitor;
    protected final ConnectionPoolMonitor cpMonitor;

    public DynoJedisClient(String name, String clusterName, ConnectionPool<Jedis> pool, DynoOPMonitor operationMonitor, ConnectionPoolMonitor cpMonitor) {
        this.appName = name;
        this.clusterName = clusterName;
        this.connPool = pool;
        this.opMonitor = operationMonitor;
        this.cpMonitor = cpMonitor;
    }

    public ConnectionPoolImpl<Jedis> getConnPool() {
        return (ConnectionPoolImpl)this.connPool;
    }

    public String getApplicationName() {
        return this.appName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public TopologyView getTopologyView() {
        return this.getConnPool();
    }

    public <R> OperationResult<R> moduleCommand(JedisGenericOperation<R> handler) {
        return this.connPool.executeWithFailover(handler);
    }

    public Long append(String key, String value) {
        return (Long)this.d_append(key, value).getResult();
    }

    public OperationResult<Long> d_append(final String key, final String value) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.APPEND){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.append(key, value);
            }
        });
    }

    public Long decr(String key) {
        return (Long)this.d_decr(key).getResult();
    }

    public OperationResult<Long> d_decr(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.DECR){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.decr(key);
            }
        });
    }

    public Long decrBy(String key, long delta) {
        return (Long)this.d_decrBy(key, delta).getResult();
    }

    public OperationResult<Long> d_decrBy(final String key, final Long delta) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.DECRBY){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.decrBy(key, delta.longValue());
            }
        });
    }

    public Long del(String key) {
        return (Long)this.d_del(key).getResult();
    }

    public Long unlink(String key) {
        return (Long)this.d_unlink(key).getResult();
    }

    public OperationResult<Long> d_unlink(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.UNLINK){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.unlink(key);
            }
        });
    }

    public OperationResult<Long> d_del(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.DEL){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.del(key);
            }
        });
    }

    public byte[] dump(String key) {
        return (byte[])this.d_dump(key).getResult();
    }

    public String restore(String key, int ttl, byte[] serializedValue) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String restoreReplace(String key, int ttl, byte[] serializedValue) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public OperationResult<byte[]> d_dump(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<byte[]>(key, OpName.DUMP){

            public byte[] execute(Jedis client, ConnectionContext state) {
                return client.dump(key);
            }
        });
    }

    public Boolean exists(String key) {
        return (Boolean)this.d_exists(key).getResult();
    }

    public OperationResult<Boolean> d_exists(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Boolean>(key, OpName.EXISTS){

            public Boolean execute(Jedis client, ConnectionContext state) {
                return client.exists(key);
            }
        });
    }

    public Long expire(String key, int seconds) {
        return (Long)this.d_expire(key, seconds).getResult();
    }

    public OperationResult<Long> d_expire(final String key, final int seconds) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.EXPIRE){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.expire(key, seconds);
            }
        });
    }

    public Long expireAt(String key, long unixTime) {
        return (Long)this.d_expireAt(key, unixTime).getResult();
    }

    public OperationResult<Long> d_expireAt(final String key, final long unixTime) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.EXPIREAT){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.expireAt(key, unixTime);
            }
        });
    }

    public Object eval(String script, int keyCount, String ... params) {
        return this.d_eval(script, keyCount, params).getResult();
    }

    public OperationResult<Object> d_eval(final String script, final int keyCount, final String ... params) {
        if (keyCount == 0) {
            throw new DynoException("Need at least one key in script");
        }
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Object>(params[0], OpName.EVAL){

            public Object execute(Jedis client, ConnectionContext state) {
                return client.eval(script, keyCount, params);
            }
        });
    }

    public Object eval(String script, List<String> keys, List<String> args) {
        String[] params = (String[])ArrayUtils.addAll((Object[])keys.toArray(new String[0]), (Object[])args.toArray(new String[0]));
        return this.eval(script, keys.size(), params);
    }

    public Object eval(String script) {
        return this.eval(script, 0, new String[0]);
    }

    public Object evalsha(String sha1, int keyCount, String ... params) {
        return this.d_evalsha(sha1, keyCount, params).getResult();
    }

    public OperationResult<Object> d_evalsha(final String sha1, final int keyCount, final String ... params) {
        if (keyCount == 0) {
            throw new DynoException("Need at least one key in script");
        }
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Object>(params[0], OpName.EVALSHA){

            public Object execute(Jedis client, ConnectionContext state) {
                return client.evalsha(sha1, keyCount, params);
            }
        });
    }

    public Object evalsha(String sha1, List<String> keys, List<String> args) {
        String[] params = (String[])ArrayUtils.addAll((Object[])keys.toArray(new String[0]), (Object[])args.toArray(new String[0]));
        return this.evalsha(sha1, keys.size(), params);
    }

    public Object evalsha(String sha1) {
        return this.evalsha(sha1, 0, new String[0]);
    }

    public Boolean scriptExists(String sha1) {
        return (Boolean)this.d_scriptExists(sha1).getResult();
    }

    public OperationResult<Boolean> d_scriptExists(final String sha1) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Boolean>(sha1, OpName.SCRIPT_EXISTS){

            public Boolean execute(Jedis client, ConnectionContext state) throws DynoException {
                return client.scriptExists(sha1);
            }
        });
    }

    public List<Boolean> scriptExists(String ... sha1) {
        return this.scriptExists(sha1);
    }

    public String scriptLoad(String script) {
        return (String)this.d_scriptLoad(script).getResult();
    }

    public OperationResult<String> d_scriptLoad(final String script) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(script, OpName.SCRIPT_LOAD){

            public String execute(Jedis client, ConnectionContext state) throws DynoException {
                return client.scriptLoad(script);
            }
        });
    }

    public String scriptFlush() {
        return (String)this.d_scriptFlush().getResult();
    }

    public OperationResult<String> d_scriptFlush() {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>("", OpName.SCRIPT_FLUSH){

            public String execute(Jedis client, ConnectionContext state) throws DynoException {
                return client.scriptFlush();
            }
        });
    }

    public String scriptKill() {
        return (String)this.d_scriptKill().getResult();
    }

    public OperationResult<String> d_scriptKill() {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>("", OpName.SCRIPT_KILL){

            public String execute(Jedis client, ConnectionContext state) throws DynoException {
                return client.scriptKill();
            }
        });
    }

    public String get(String key) {
        return (String)this.d_get(key).getResult();
    }

    public OperationResult<String> d_get(final String key) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.GET){

                public String execute(Jedis client, ConnectionContext state) throws DynoException {
                    return client.get(key);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<String>(key, OpName.GET){

            public String execute(Jedis client, ConnectionContext state) throws DynoException {
                return this.decompressValue(client.get(key), state);
            }
        });
    }

    public Boolean getbit(String key, long offset) {
        return (Boolean)this.d_getbit(key, offset).getResult();
    }

    public OperationResult<Boolean> d_getbit(final String key, final Long offset) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Boolean>(key, OpName.GETBIT){

            public Boolean execute(Jedis client, ConnectionContext state) {
                return client.getbit(key, offset.longValue());
            }
        });
    }

    public String getrange(String key, long startOffset, long endOffset) {
        return (String)this.d_getrange(key, startOffset, endOffset).getResult();
    }

    public OperationResult<String> d_getrange(final String key, final Long startOffset, final Long endOffset) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.GETRANGE){

            public String execute(Jedis client, ConnectionContext state) {
                return client.getrange(key, startOffset.longValue(), endOffset.longValue());
            }
        });
    }

    public String getSet(String key, String value) {
        return (String)this.d_getSet(key, value).getResult();
    }

    public OperationResult<String> d_getSet(final String key, final String value) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.GETSET){

                public String execute(Jedis client, ConnectionContext state) throws DynoException {
                    return client.getSet(key, value);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<String>(key, OpName.GETSET){

            public String execute(Jedis client, ConnectionContext state) throws DynoException {
                return this.decompressValue(client.getSet(key, this.compressValue(value, state)), state);
            }
        });
    }

    public Long hdel(String key, String ... fields) {
        return (Long)this.d_hdel(key, fields).getResult();
    }

    public OperationResult<Long> d_hdel(final String key, final String ... fields) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.HDEL){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.hdel(key, fields);
            }
        });
    }

    public Boolean hexists(String key, String field) {
        return (Boolean)this.d_hexists(key, field).getResult();
    }

    public OperationResult<Boolean> d_hexists(final String key, final String field) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Boolean>(key, OpName.HEXISTS){

            public Boolean execute(Jedis client, ConnectionContext state) {
                return client.hexists(key, field);
            }
        });
    }

    public String hget(String key, String field) {
        return (String)this.d_hget(key, field).getResult();
    }

    public OperationResult<String> d_hget(final String key, final String field) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.HGET){

                public String execute(Jedis client, ConnectionContext state) throws DynoException {
                    return client.hget(key, field);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<String>(key, OpName.HGET){

            public String execute(Jedis client, ConnectionContext state) throws DynoException {
                return this.decompressValue(client.hget(key, field), state);
            }
        });
    }

    public Map<String, String> hgetAll(String key) {
        return (Map)this.d_hgetAll(key).getResult();
    }

    public OperationResult<Map<String, String>> d_hgetAll(final String key) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Map<String, String>>(key, OpName.HGETALL){

                public Map<String, String> execute(Jedis client, ConnectionContext state) throws DynoException {
                    return client.hgetAll(key);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<Map<String, String>>(key, OpName.HGETALL){

            public Map<String, String> execute(Jedis client, final ConnectionContext state) {
                return CollectionUtils.transform((Map)client.hgetAll(key), (CollectionUtils.MapEntryTransform)new CollectionUtils.MapEntryTransform<String, String, String>(){

                    public String get(String key, String val) {
                        return this.decompressValue(val, state);
                    }
                });
            }
        });
    }

    public Long hincrBy(String key, String field, long value) {
        return (Long)this.d_hincrBy(key, field, value).getResult();
    }

    public OperationResult<Long> d_hincrBy(final String key, final String field, final long value) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.HINCRBY){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.hincrBy(key, field, value);
            }
        });
    }

    public Double hincrByFloat(String key, String field, double value) {
        return (Double)this.d_hincrByFloat(key, field, value).getResult();
    }

    public OperationResult<Double> d_hincrByFloat(final String key, final String field, final double value) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Double>(key, OpName.HINCRBYFLOAT){

            public Double execute(Jedis client, ConnectionContext state) {
                return client.hincrByFloat(key, field, value);
            }
        });
    }

    public Long hsetnx(String key, String field, String value) {
        return (Long)this.d_hsetnx(key, field, value).getResult();
    }

    public OperationResult<Long> d_hsetnx(final String key, final String field, final String value) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.HSETNX){

                public Long execute(Jedis client, ConnectionContext state) {
                    return client.hsetnx(key, field, value);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<Long>(key, OpName.HSETNX){

            public Long execute(Jedis client, ConnectionContext state) throws DynoException {
                return client.hsetnx(key, field, this.compressValue(value, state));
            }
        });
    }

    public Set<String> hkeys(String key) {
        return (Set)this.d_hkeys(key).getResult();
    }

    public OperationResult<Set<String>> d_hkeys(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.HKEYS){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.hkeys(key);
            }
        });
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor) {
        return (ScanResult)this.d_hscan(key, cursor).getResult();
    }

    public OperationResult<ScanResult<Map.Entry<String, String>>> d_hscan(final String key, final String cursor) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<ScanResult<Map.Entry<String, String>>>(key, OpName.HSCAN){

                public ScanResult<Map.Entry<String, String>> execute(Jedis client, ConnectionContext state) {
                    return client.hscan(key, cursor);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<ScanResult<Map.Entry<String, String>>>(key, OpName.HSCAN){

            public ScanResult<Map.Entry<String, String>> execute(Jedis client, final ConnectionContext state) {
                return new ScanResult(cursor, new ArrayList(CollectionUtils.transform((Collection)client.hscan(key, cursor).getResult(), (CollectionUtils.Transform)new CollectionUtils.Transform<Map.Entry<String, String>, Map.Entry<String, String>>(){

                    public Map.Entry<String, String> get(Map.Entry<String, String> entry) {
                        entry.setValue(this.decompressValue(entry.getValue(), state));
                        return entry;
                    }
                })));
            }
        });
    }

    private String getCursorValue(ConnectionContext state, CursorBasedResult cursor) {
        if (state != null && state.getMetadata("host") != null && cursor != null) {
            return cursor.getCursorForHost(state.getMetadata("host").toString());
        }
        return "0";
    }

    private List<OperationResult<ScanResult<String>>> scatterGatherScan(final CursorBasedResult<String> cursor, final int count, final String ... pattern) {
        if (!(cursor instanceof TokenRackMapper)) {
            throw new DynoException("cursor does not implement the TokenRackMapper interface");
        }
        return new ArrayList<OperationResult<ScanResult<String>>>(this.connPool.executeWithRing((TokenRackMapper)cursor, (Operation)new BaseKeyOperation<ScanResult<String>>("SCAN", OpName.SCAN){

            public ScanResult<String> execute(Jedis client, ConnectionContext state) throws DynoException {
                if (pattern != null && pattern.length > 0) {
                    ScanParams sp = new ScanParams().count(Integer.valueOf(count));
                    for (String s : pattern) {
                        sp.match(s);
                    }
                    return client.scan(DynoJedisClient.this.getCursorValue(state, cursor), sp);
                }
                return client.scan(DynoJedisClient.this.getCursorValue(state, cursor));
            }
        }));
    }

    public Long hlen(String key) {
        return (Long)this.d_hlen(key).getResult();
    }

    public OperationResult<Long> d_hlen(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.HLEN){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.hlen(key);
            }
        });
    }

    public List<String> hmget(String key, String ... fields) {
        return (List)this.d_hmget(key, fields).getResult();
    }

    public OperationResult<List<String>> d_hmget(final String key, final String ... fields) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<List<String>>(key, OpName.HMGET){

                public List<String> execute(Jedis client, ConnectionContext state) {
                    return client.hmget(key, fields);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<List<String>>(key, OpName.HMGET){

            public List<String> execute(Jedis client, final ConnectionContext state) throws DynoException {
                return new ArrayList<String>(CollectionUtils.transform((Collection)client.hmget(key, fields), (CollectionUtils.Transform)new CollectionUtils.Transform<String, String>(){

                    public String get(String s) {
                        return this.decompressValue(s, state);
                    }
                }));
            }
        });
    }

    public String hmset(String key, Map<String, String> hash) {
        return (String)this.d_hmset(key, hash).getResult();
    }

    public OperationResult<String> d_hmset(final String key, final Map<String, String> hash) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.HMSET){

                public String execute(Jedis client, ConnectionContext state) {
                    return client.hmset(key, hash);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<String>(key, OpName.HMSET){

            public String execute(Jedis client, final ConnectionContext state) throws DynoException {
                return client.hmset(key, CollectionUtils.transform((Map)hash, (CollectionUtils.MapEntryTransform)new CollectionUtils.MapEntryTransform<String, String, String>(){

                    public String get(String key, String val) {
                        return this.compressValue(val, state);
                    }
                }));
            }
        });
    }

    public Long hset(String key, String field, String value) {
        return (Long)this.d_hset(key, field, value).getResult();
    }

    public Long hset(String key, Map<String, String> hash) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public OperationResult<Long> d_hset(final String key, final String field, final String value) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.HSET){

                public Long execute(Jedis client, ConnectionContext state) {
                    return client.hset(key, field, value);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<Long>(key, OpName.HSET){

            public Long execute(Jedis client, ConnectionContext state) throws DynoException {
                return client.hset(key, field, this.compressValue(value, state));
            }
        });
    }

    public List<String> hvals(String key) {
        return (List)this.d_hvals(key).getResult();
    }

    public OperationResult<List<String>> d_hvals(final String key) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<List<String>>(key, OpName.HVALS){

                public List<String> execute(Jedis client, ConnectionContext state) {
                    return client.hvals(key);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<List<String>>(key, OpName.HVALS){

            public List<String> execute(Jedis client, final ConnectionContext state) throws DynoException {
                return new ArrayList<String>(CollectionUtils.transform((Collection)client.hvals(key), (CollectionUtils.Transform)new CollectionUtils.Transform<String, String>(){

                    public String get(String s) {
                        return this.decompressValue(s, state);
                    }
                }));
            }
        });
    }

    public Long incr(String key) {
        return (Long)this.d_incr(key).getResult();
    }

    public OperationResult<Long> d_incr(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.INCR){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.incr(key);
            }
        });
    }

    public Long incrBy(String key, long delta) {
        return (Long)this.d_incrBy(key, delta).getResult();
    }

    public OperationResult<Long> d_incrBy(final String key, final Long delta) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.INCRBY){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.incrBy(key, delta.longValue());
            }
        });
    }

    public Double incrByFloat(String key, double increment) {
        return (Double)this.d_incrByFloat(key, increment).getResult();
    }

    public OperationResult<Double> d_incrByFloat(final String key, final Double increment) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Double>(key, OpName.INCRBYFLOAT){

            public Double execute(Jedis client, ConnectionContext state) {
                return client.incrByFloat(key, increment.doubleValue());
            }
        });
    }

    public String lindex(String key, long index) {
        return (String)this.d_lindex(key, index).getResult();
    }

    public OperationResult<String> d_lindex(final String key, final Long index) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.LINDEX){

            public String execute(Jedis client, ConnectionContext state) {
                return client.lindex(key, index.longValue());
            }
        });
    }

    public Long linsert(String key, ListPosition where, String pivot, String value) {
        return (Long)this.d_linsert(key, where, pivot, value).getResult();
    }

    public OperationResult<Long> d_linsert(final String key, final ListPosition where, final String pivot, final String value) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.LINSERT){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.linsert(key, where, pivot, value);
            }
        });
    }

    public Long llen(String key) {
        return (Long)this.d_llen(key).getResult();
    }

    public OperationResult<Long> d_llen(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.LLEN){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.llen(key);
            }
        });
    }

    public String lpop(String key) {
        return (String)this.d_lpop(key).getResult();
    }

    public OperationResult<String> d_lpop(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.LPOP){

            public String execute(Jedis client, ConnectionContext state) {
                return client.lpop(key);
            }
        });
    }

    public Long lpush(String key, String ... values) {
        return (Long)this.d_lpush(key, values).getResult();
    }

    public OperationResult<Long> d_lpush(final String key, final String ... values) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.LPUSH){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.lpush(key, values);
            }
        });
    }

    public Long lpushx(String key, String ... values) {
        return (Long)this.d_lpushx(key, values).getResult();
    }

    public OperationResult<Long> d_lpushx(final String key, final String ... values) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.LPUSHX){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.lpushx(key, values);
            }
        });
    }

    public List<String> lrange(String key, long start, long end) {
        return (List)this.d_lrange(key, start, end).getResult();
    }

    public OperationResult<List<String>> d_lrange(final String key, final Long start, final Long end) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<List<String>>(key, OpName.LRANGE){

            public List<String> execute(Jedis client, ConnectionContext state) {
                return client.lrange(key, start.longValue(), end.longValue());
            }
        });
    }

    public Long lrem(String key, long count, String value) {
        return (Long)this.d_lrem(key, count, value).getResult();
    }

    public OperationResult<Long> d_lrem(final String key, final Long count, final String value) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.LREM){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.lrem(key, count.longValue(), value);
            }
        });
    }

    public String lset(String key, long index, String value) {
        return (String)this.d_lset(key, index, value).getResult();
    }

    public OperationResult<String> d_lset(final String key, final Long index, final String value) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.LSET){

            public String execute(Jedis client, ConnectionContext state) {
                return client.lset(key, index.longValue(), value);
            }
        });
    }

    public String ltrim(String key, long start, long end) {
        return (String)this.d_ltrim(key, start, end).getResult();
    }

    public OperationResult<String> d_ltrim(final String key, final long start, final long end) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.LTRIM){

            public String execute(Jedis client, ConnectionContext state) {
                return client.ltrim(key, start, end);
            }
        });
    }

    public Long persist(String key) {
        return (Long)this.d_persist(key).getResult();
    }

    public OperationResult<Long> d_persist(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.PERSIST){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.persist(key);
            }
        });
    }

    public Long pexpireAt(String key, long millisecondsTimestamp) {
        return (Long)this.d_pexpireAt(key, millisecondsTimestamp).getResult();
    }

    public OperationResult<Long> d_pexpireAt(final String key, final Long millisecondsTimestamp) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.PEXPIREAT){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.pexpireAt(key, millisecondsTimestamp.longValue());
            }
        });
    }

    public Long pttl(String key) {
        return (Long)this.d_pttl(key).getResult();
    }

    public Long touch(String key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public OperationResult<Long> d_pttl(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.PTTL){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.pttl(key);
            }
        });
    }

    public String rename(String oldkey, String newkey) {
        return (String)this.d_rename(oldkey, newkey).getResult();
    }

    public OperationResult<String> d_rename(final String oldkey, final String newkey) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(oldkey, OpName.RENAME){

            public String execute(Jedis client, ConnectionContext state) {
                return client.rename(oldkey, newkey);
            }
        });
    }

    public Long renamenx(String oldkey, String newkey) {
        return (Long)this.d_renamenx(oldkey, newkey).getResult();
    }

    public OperationResult<Long> d_renamenx(final String oldkey, final String newkey) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(oldkey, OpName.RENAMENX){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.renamenx(oldkey, newkey);
            }
        });
    }

    public String restore(String key, Integer ttl, byte[] serializedValue) {
        return (String)this.d_restore(key, ttl, serializedValue).getResult();
    }

    public OperationResult<String> d_restore(final String key, final Integer ttl, final byte[] serializedValue) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.RESTORE){

            public String execute(Jedis client, ConnectionContext state) {
                return client.restore(key, ttl.intValue(), serializedValue);
            }
        });
    }

    public String rpop(String key) {
        return (String)this.d_rpop(key).getResult();
    }

    public OperationResult<String> d_rpop(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.RPOP){

            public String execute(Jedis client, ConnectionContext state) {
                return client.rpop(key);
            }
        });
    }

    public String rpoplpush(String srckey, String dstkey) {
        return (String)this.d_rpoplpush(srckey, dstkey).getResult();
    }

    public OperationResult<String> d_rpoplpush(final String srckey, final String dstkey) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(srckey, OpName.RPOPLPUSH){

            public String execute(Jedis client, ConnectionContext state) {
                return client.rpoplpush(srckey, dstkey);
            }
        });
    }

    public Long rpush(String key, String ... values) {
        return (Long)this.d_rpush(key, values).getResult();
    }

    public OperationResult<Long> d_rpush(final String key, final String ... values) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.RPUSH){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.rpush(key, values);
            }
        });
    }

    public Long rpushx(String key, String ... values) {
        return (Long)this.d_rpushx(key, values).getResult();
    }

    public OperationResult<Long> d_rpushx(final String key, final String ... values) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.RPUSHX){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.rpushx(key, values);
            }
        });
    }

    public Long sadd(String key, String ... members) {
        return (Long)this.d_sadd(key, members).getResult();
    }

    public OperationResult<Long> d_sadd(final String key, final String ... members) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.SADD){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.sadd(key, members);
            }
        });
    }

    public Long scard(String key) {
        return (Long)this.d_scard(key).getResult();
    }

    public OperationResult<Long> d_scard(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.SCARD){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.scard(key);
            }
        });
    }

    public Set<String> sdiff(String ... keys) {
        return (Set)this.d_sdiff(keys).getResult();
    }

    public OperationResult<Set<String>> d_sdiff(final String ... keys) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(keys[0], OpName.SDIFF){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.sdiff(keys);
            }
        });
    }

    public Long sdiffstore(String dstkey, String ... keys) {
        return (Long)this.d_sdiffstore(dstkey, keys).getResult();
    }

    public OperationResult<Long> d_sdiffstore(final String dstkey, final String ... keys) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(dstkey, OpName.SDIFFSTORE){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.sdiffstore(dstkey, keys);
            }
        });
    }

    public String set(String key, String value) {
        return (String)this.d_set(key, value).getResult();
    }

    public OperationResult<String> d_set(final String key, final String value) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.SET){

                public String execute(Jedis client, ConnectionContext state) throws DynoException {
                    return client.set(key, value);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<String>(key, OpName.SET){

            public String execute(Jedis client, ConnectionContext state) throws DynoException {
                return client.set(key, this.compressValue(value, state));
            }
        });
    }

    @Deprecated
    public String set(String key, String value, String nxxx, String expx, long time) {
        return (String)this.d_set(key, value, nxxx, expx, time).getResult();
    }

    public OperationResult<String> d_set(String key, String value, String nxxx, String expx, long time) {
        SetParams setParams = SetParams.setParams();
        if (nxxx.equalsIgnoreCase("NX")) {
            setParams.nx();
        } else if (nxxx.equalsIgnoreCase("XX")) {
            setParams.xx();
        }
        if (expx.equalsIgnoreCase("EX")) {
            setParams.ex((int)time);
        } else if (expx.equalsIgnoreCase("PX")) {
            setParams.px(time);
        }
        return this.d_set(key, value, setParams);
    }

    public String set(String key, String value, SetParams setParams) {
        return (String)this.d_set(key, value, setParams).getResult();
    }

    public OperationResult<String> d_set(final String key, final String value, final SetParams setParams) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.SET){

                public String execute(Jedis client, ConnectionContext state) throws DynoException {
                    return client.set(key, value, setParams);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<String>(key, OpName.SET){

            public String execute(Jedis client, ConnectionContext state) throws DynoException {
                return client.set(key, this.compressValue(value, state), setParams);
            }
        });
    }

    public Boolean setbit(String key, long offset, boolean value) {
        return (Boolean)this.d_setbit(key, (Long)offset, value).getResult();
    }

    public OperationResult<Boolean> d_setbit(final String key, final Long offset, final Boolean value) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Boolean>(key, OpName.SETBIT){

            public Boolean execute(Jedis client, ConnectionContext state) {
                return client.setbit(key, offset.longValue(), value.booleanValue());
            }
        });
    }

    public Boolean setbit(String key, long offset, String value) {
        return (Boolean)this.d_setbit(key, (Long)offset, value).getResult();
    }

    public OperationResult<Boolean> d_setbit(final String key, final Long offset, final String value) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Boolean>(key, OpName.SETBIT){

            public Boolean execute(Jedis client, ConnectionContext state) {
                return client.setbit(key, offset.longValue(), value);
            }
        });
    }

    public String setex(String key, int seconds, String value) {
        return (String)this.d_setex(key, (Integer)seconds, value).getResult();
    }

    public OperationResult<String> d_setex(final String key, final Integer seconds, final String value) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.SETEX){

                public String execute(Jedis client, ConnectionContext state) throws DynoException {
                    return client.setex(key, seconds.intValue(), value);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<String>(key, OpName.SETEX){

            public String execute(Jedis client, ConnectionContext state) throws DynoException {
                return client.setex(key, seconds.intValue(), this.compressValue(value, state));
            }
        });
    }

    public String psetex(String key, long milliseconds, String value) {
        return (String)this.d_psetex(key, milliseconds, value).getResult();
    }

    public OperationResult<String> d_psetex(final String key, final long milliseconds, final String value) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.PSETEX){

                public String execute(Jedis client, ConnectionContext state) throws DynoException {
                    return client.psetex(key, milliseconds, value);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<String>(key, OpName.PSETEX){

            public String execute(Jedis client, ConnectionContext state) throws DynoException {
                return client.psetex(key, milliseconds, this.compressValue(value, state));
            }
        });
    }

    public Long setnx(String key, String value) {
        return (Long)this.d_setnx(key, value).getResult();
    }

    public OperationResult<Long> d_setnx(final String key, final String value) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.SETNX){

                public Long execute(Jedis client, ConnectionContext state) throws DynoException {
                    return client.setnx(key, value);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueOperation<Long>(key, OpName.SETNX){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.setnx(key, this.compressValue(value, state));
            }
        });
    }

    public Long setrange(String key, long offset, String value) {
        return (Long)this.d_setrange(key, offset, value).getResult();
    }

    public OperationResult<Long> d_setrange(final String key, final Long offset, final String value) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.SETRANGE){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.setrange(key, offset.longValue(), value);
            }
        });
    }

    public Boolean sismember(String key, String member) {
        return (Boolean)this.d_sismember(key, member).getResult();
    }

    public OperationResult<Boolean> d_sismember(final String key, final String member) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Boolean>(key, OpName.SISMEMBER){

            public Boolean execute(Jedis client, ConnectionContext state) {
                return client.sismember(key, member);
            }
        });
    }

    public Set<String> smembers(String key) {
        return (Set)this.d_smembers(key).getResult();
    }

    public OperationResult<Set<String>> d_smembers(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.SMEMBERS){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.smembers(key);
            }
        });
    }

    public Long smove(String srckey, String dstkey, String member) {
        return (Long)this.d_smove(srckey, dstkey, member).getResult();
    }

    public OperationResult<Long> d_smove(final String srckey, final String dstkey, final String member) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(srckey, OpName.SMOVE){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.smove(srckey, dstkey, member);
            }
        });
    }

    public List<String> sort(String key) {
        return (List)this.d_sort(key).getResult();
    }

    public OperationResult<List<String>> d_sort(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<List<String>>(key, OpName.SORT){

            public List<String> execute(Jedis client, ConnectionContext state) {
                return client.sort(key);
            }
        });
    }

    public List<String> sort(String key, SortingParams sortingParameters) {
        return (List)this.d_sort(key, sortingParameters).getResult();
    }

    public OperationResult<List<String>> d_sort(final String key, final SortingParams sortingParameters) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<List<String>>(key, OpName.SORT){

            public List<String> execute(Jedis client, ConnectionContext state) {
                return client.sort(key, sortingParameters);
            }
        });
    }

    public String spop(String key) {
        return (String)this.d_spop(key).getResult();
    }

    public OperationResult<String> d_spop(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.SPOP){

            public String execute(Jedis client, ConnectionContext state) {
                return client.spop(key);
            }
        });
    }

    public Set<String> spop(String key, long count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String srandmember(String key) {
        return (String)this.d_srandmember(key).getResult();
    }

    public List<String> srandmember(String key, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public OperationResult<String> d_srandmember(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.SRANDMEMBER){

            public String execute(Jedis client, ConnectionContext state) {
                return client.srandmember(key);
            }
        });
    }

    public Long srem(String key, String ... members) {
        return (Long)this.d_srem(key, members).getResult();
    }

    public OperationResult<Long> d_srem(final String key, final String ... members) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.SREM){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.srem(key, members);
            }
        });
    }

    public ScanResult<String> sscan(String key, String cursor) {
        return (ScanResult)this.d_sscan(key, cursor).getResult();
    }

    public OperationResult<ScanResult<String>> d_sscan(final String key, final String cursor) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<ScanResult<String>>(key, OpName.SSCAN){

            public ScanResult<String> execute(Jedis client, ConnectionContext state) {
                return client.sscan(key, cursor);
            }
        });
    }

    public ScanResult<String> sscan(String key, String cursor, ScanParams params) {
        return (ScanResult)this.d_sscan(key, cursor, params).getResult();
    }

    public OperationResult<ScanResult<String>> d_sscan(final String key, final String cursor, final ScanParams params) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<ScanResult<String>>(key, OpName.SSCAN){

            public ScanResult<String> execute(Jedis client, ConnectionContext state) {
                return client.sscan(key, cursor, params);
            }
        });
    }

    public Long strlen(String key) {
        return (Long)this.d_strlen(key).getResult();
    }

    public OperationResult<Long> d_strlen(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.STRLEN){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.strlen(key);
            }
        });
    }

    public String substr(String key, int start, int end) {
        return (String)this.d_substr(key, start, end).getResult();
    }

    public OperationResult<String> d_substr(final String key, final Integer start, final Integer end) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.SUBSTR){

            public String execute(Jedis client, ConnectionContext state) {
                return client.substr(key, start.intValue(), end.intValue());
            }
        });
    }

    public Long ttl(String key) {
        return (Long)this.d_ttl(key).getResult();
    }

    public OperationResult<Long> d_ttl(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.TTL){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.ttl(key);
            }
        });
    }

    public String type(String key) {
        return (String)this.d_type(key).getResult();
    }

    public OperationResult<String> d_type(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.TYPE){

            public String execute(Jedis client, ConnectionContext state) {
                return client.type(key);
            }
        });
    }

    public Long zadd(String key, double score, String member) {
        return (Long)this.d_zadd(key, score, member).getResult();
    }

    public OperationResult<Long> d_zadd(final String key, final Double score, final String member) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZADD){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zadd(key, score.doubleValue(), member);
            }
        });
    }

    public Long zadd(String key, Map<String, Double> scoreMembers) {
        return (Long)this.d_zadd(key, scoreMembers).getResult();
    }

    public OperationResult<Long> d_zadd(final String key, final Map<String, Double> scoreMembers) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZADD){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zadd(key, scoreMembers);
            }
        });
    }

    public Long zadd(String key, double score, String member, ZAddParams params) {
        return (Long)this.d_zadd(key, score, member, params).getResult();
    }

    public OperationResult<Long> d_zadd(final String key, final double score, final String member, final ZAddParams params) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZADD){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zadd(key, score, member, params);
            }
        });
    }

    public Long zcard(String key) {
        return (Long)this.d_zcard(key).getResult();
    }

    public OperationResult<Long> d_zcard(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZCARD){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zcard(key);
            }
        });
    }

    public Long zcount(String key, double min, double max) {
        return (Long)this.d_zcount(key, min, max).getResult();
    }

    public OperationResult<Long> d_zcount(final String key, final Double min, final Double max) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZCOUNT){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zcount(key, min.doubleValue(), max.doubleValue());
            }
        });
    }

    public Long zcount(String key, String min, String max) {
        return (Long)this.d_zcount(key, min, max).getResult();
    }

    public OperationResult<Long> d_zcount(final String key, final String min, final String max) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZCOUNT){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zcount(key, min, max);
            }
        });
    }

    public Double zincrby(String key, double score, String member) {
        return (Double)this.d_zincrby(key, score, member).getResult();
    }

    public OperationResult<Double> d_zincrby(final String key, final Double score, final String member) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Double>(key, OpName.ZINCRBY){

            public Double execute(Jedis client, ConnectionContext state) {
                return client.zincrby(key, score.doubleValue(), member);
            }
        });
    }

    public Set<String> zrange(String key, long start, long end) {
        return (Set)this.d_zrange(key, start, end).getResult();
    }

    public OperationResult<Set<String>> d_zrange(final String key, final Long start, final Long end) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZRANGE){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrange(key, start.longValue(), end.longValue());
            }
        });
    }

    public Long zrank(String key, String member) {
        return (Long)this.d_zrank(key, member).getResult();
    }

    public OperationResult<Long> d_zrank(final String key, final String member) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZRANK){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zrank(key, member);
            }
        });
    }

    public Long zrem(String key, String ... member) {
        return (Long)this.d_zrem(key, member).getResult();
    }

    public OperationResult<Long> d_zrem(final String key, final String ... member) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZREM){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zrem(key, member);
            }
        });
    }

    public Long zremrangeByRank(String key, long start, long end) {
        return (Long)this.d_zremrangeByRank(key, start, end).getResult();
    }

    public OperationResult<Long> d_zremrangeByRank(final String key, final Long start, final Long end) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZREMRANGEBYRANK){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zremrangeByRank(key, start.longValue(), end.longValue());
            }
        });
    }

    public Long zremrangeByScore(String key, double start, double end) {
        return (Long)this.d_zremrangeByScore(key, start, end).getResult();
    }

    public OperationResult<Long> d_zremrangeByScore(final String key, final Double start, final Double end) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZREMRANGEBYSCORE){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zremrangeByScore(key, start.doubleValue(), end.doubleValue());
            }
        });
    }

    public Set<String> zrevrange(String key, long start, long end) {
        return (Set)this.d_zrevrange(key, start, end).getResult();
    }

    public OperationResult<Set<String>> d_zrevrange(final String key, final Long start, final Long end) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZREVRANGE){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrevrange(key, start.longValue(), end.longValue());
            }
        });
    }

    public Long zrevrank(String key, String member) {
        return (Long)this.d_zrevrank(key, member).getResult();
    }

    public OperationResult<Long> d_zrevrank(final String key, final String member) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZREVRANK){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zrevrank(key, member);
            }
        });
    }

    public Set<Tuple> zrangeWithScores(String key, long start, long end) {
        return (Set)this.d_zrangeWithScores(key, start, end).getResult();
    }

    public OperationResult<Set<Tuple>> d_zrangeWithScores(final String key, final Long start, final Long end) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<Tuple>>(key, OpName.ZRANGEWITHSCORES){

            public Set<Tuple> execute(Jedis client, ConnectionContext state) {
                return client.zrangeWithScores(key, start.longValue(), end.longValue());
            }
        });
    }

    public Set<Tuple> zrevrangeWithScores(String key, long start, long end) {
        return (Set)this.d_zrevrangeWithScores(key, start, end).getResult();
    }

    public OperationResult<Set<Tuple>> d_zrevrangeWithScores(final String key, final Long start, final Long end) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<Tuple>>(key, OpName.ZREVRANGEWITHSCORES){

            public Set<Tuple> execute(Jedis client, ConnectionContext state) {
                return client.zrevrangeWithScores(key, start.longValue(), end.longValue());
            }
        });
    }

    public Double zscore(String key, String member) {
        return (Double)this.d_zscore(key, member).getResult();
    }

    public OperationResult<Double> d_zscore(final String key, final String member) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Double>(key, OpName.ZSCORE){

            public Double execute(Jedis client, ConnectionContext state) {
                return client.zscore(key, member);
            }
        });
    }

    public ScanResult<Tuple> zscan(String key, String cursor) {
        return (ScanResult)this.d_zscan(key, cursor).getResult();
    }

    public OperationResult<ScanResult<Tuple>> d_zscan(final String key, final String cursor) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<ScanResult<Tuple>>(key, OpName.ZSCAN){

            public ScanResult<Tuple> execute(Jedis client, ConnectionContext state) {
                return client.zscan(key, cursor);
            }
        });
    }

    public Set<String> zrangeByScore(String key, double min, double max) {
        return (Set)this.d_zrangeByScore(key, min, max).getResult();
    }

    public OperationResult<Set<String>> d_zrangeByScore(final String key, final Double min, final Double max) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZRANGEBYSCORE){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrangeByScore(key, min.doubleValue(), max.doubleValue());
            }
        });
    }

    public Set<String> zrangeByScore(String key, String min, String max) {
        return (Set)this.d_zrangeByScore(key, min, max).getResult();
    }

    public OperationResult<Set<String>> d_zrangeByScore(final String key, final String min, final String max) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZRANGEBYSCORE){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrangeByScore(key, min, max);
            }
        });
    }

    public Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        return (Set)this.d_zrangeByScore(key, min, max, (Integer)offset, (Integer)count).getResult();
    }

    public OperationResult<Set<String>> d_zrangeByScore(final String key, final Double min, final Double max, final Integer offset, final Integer count) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZRANGEBYSCORE){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrangeByScore(key, min.doubleValue(), max.doubleValue(), offset.intValue(), count.intValue());
            }
        });
    }

    public Set<String> zrevrangeByScore(String key, String max, String min) {
        return (Set)this.d_zrevrangeByScore(key, max, min).getResult();
    }

    public OperationResult<Set<String>> d_zrevrangeByScore(final String key, final String max, final String min) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZREVRANGEBYSCORE){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrevrangeByScore(key, max, min);
            }
        });
    }

    public Set<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        return (Set)this.d_zrangeByScore(key, min, max, (Integer)offset, (Integer)count).getResult();
    }

    public OperationResult<Set<String>> d_zrangeByScore(final String key, final String min, final String max, final Integer offset, final Integer count) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZRANGEBYSCORE){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrangeByScore(key, min, max, offset.intValue(), count.intValue());
            }
        });
    }

    public Set<String> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        return (Set)this.d_zrevrangeByScore(key, max, min, (Integer)offset, (Integer)count).getResult();
    }

    public OperationResult<Set<String>> d_zrevrangeByScore(final String key, final Double max, final Double min, final Integer offset, final Integer count) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZREVRANGEBYSCORE){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrevrangeByScore(key, max.doubleValue(), min.doubleValue(), offset.intValue(), count.intValue());
            }
        });
    }

    public Set<String> zrevrangeByScore(String key, double max, double min) {
        return (Set)this.d_zrevrangeByScore(key, max, min).getResult();
    }

    public OperationResult<Set<String>> d_zrevrangeByScore(final String key, final Double max, final Double min) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZREVRANGEBYSCORE){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrevrangeByScore(key, max.doubleValue(), min.doubleValue());
            }
        });
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max) {
        return (Set)this.d_zrangeByScoreWithScores(key, min, max).getResult();
    }

    public OperationResult<Set<Tuple>> d_zrangeByScoreWithScores(final String key, final Double min, final Double max) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<Tuple>>(key, OpName.ZREVRANGEBYSCORE){

            public Set<Tuple> execute(Jedis client, ConnectionContext state) {
                return client.zrangeByScoreWithScores(key, min.doubleValue(), max.doubleValue());
            }
        });
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min) {
        return (Set)this.d_zrevrangeByScoreWithScores(key, min, max).getResult();
    }

    public OperationResult<Set<Tuple>> d_zrevrangeByScoreWithScores(final String key, final Double max, final Double min) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<Tuple>>(key, OpName.ZREVRANGEBYSCOREWITHSCORES){

            public Set<Tuple> execute(Jedis client, ConnectionContext state) {
                return client.zrevrangeByScoreWithScores(key, max.doubleValue(), min.doubleValue());
            }
        });
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        return (Set)this.d_zrangeByScoreWithScores(key, min, max, (Integer)offset, (Integer)count).getResult();
    }

    public OperationResult<Set<Tuple>> d_zrangeByScoreWithScores(final String key, final Double min, final Double max, final Integer offset, final Integer count) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<Tuple>>(key, OpName.ZRANGEBYSCOREWITHSCORES){

            public Set<Tuple> execute(Jedis client, ConnectionContext state) {
                return client.zrangeByScoreWithScores(key, min.doubleValue(), max.doubleValue(), offset.intValue(), count.intValue());
            }
        });
    }

    public Set<String> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        return (Set)this.d_zrevrangeByScore(key, max, min, (Integer)offset, (Integer)count).getResult();
    }

    public OperationResult<Set<String>> d_zrevrangeByScore(final String key, final String max, final String min, final Integer offset, final Integer count) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZREVRANGEBYSCORE){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrevrangeByScore(key, max, min, offset.intValue(), count.intValue());
            }
        });
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max) {
        return (Set)this.d_zrangeByScoreWithScores(key, min, max).getResult();
    }

    public OperationResult<Set<Tuple>> d_zrangeByScoreWithScores(final String key, final String min, final String max) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<Tuple>>(key, OpName.ZRANGEBYSCOREWITHSCORES){

            public Set<Tuple> execute(Jedis client, ConnectionContext state) {
                return client.zrangeByScoreWithScores(key, min, max);
            }
        });
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min) {
        return (Set)this.d_zrevrangeByScoreWithScores(key, max, min).getResult();
    }

    public OperationResult<Set<Tuple>> d_zrevrangeByScoreWithScores(final String key, final String max, final String min) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<Tuple>>(key, OpName.ZREVRANGEBYSCOREWITHSCORES){

            public Set<Tuple> execute(Jedis client, ConnectionContext state) {
                return client.zrevrangeByScoreWithScores(key, max, min);
            }
        });
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        return (Set)this.d_zrangeByScoreWithScores(key, min, max, (Integer)offset, (Integer)count).getResult();
    }

    public OperationResult<Set<Tuple>> d_zrangeByScoreWithScores(final String key, final String min, final String max, final Integer offset, final Integer count) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<Tuple>>(key, OpName.ZRANGEBYSCOREWITHSCORES){

            public Set<Tuple> execute(Jedis client, ConnectionContext state) {
                return client.zrangeByScoreWithScores(key, min, max, offset.intValue(), count.intValue());
            }
        });
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        return (Set)this.d_zrevrangeByScoreWithScores(key, max, min, (Integer)offset, (Integer)count).getResult();
    }

    public OperationResult<Set<Tuple>> d_zrevrangeByScoreWithScores(final String key, final Double max, final Double min, final Integer offset, final Integer count) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<Tuple>>(key, OpName.ZREVRANGEBYSCOREWITHSCORES){

            public Set<Tuple> execute(Jedis client, ConnectionContext state) {
                return client.zrevrangeByScoreWithScores(key, max.doubleValue(), min.doubleValue(), offset.intValue(), count.intValue());
            }
        });
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        return (Set)this.d_zrevrangeByScoreWithScores(key, max, min, (Integer)offset, (Integer)count).getResult();
    }

    public OperationResult<Set<Tuple>> d_zrevrangeByScoreWithScores(final String key, final String max, final String min, final Integer offset, final Integer count) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<Tuple>>(key, OpName.ZREVRANGEBYSCOREWITHSCORES){

            public Set<Tuple> execute(Jedis client, ConnectionContext state) {
                return client.zrevrangeByScoreWithScores(key, max, min, offset.intValue(), count.intValue());
            }
        });
    }

    public Long zremrangeByScore(String key, String start, String end) {
        return (Long)this.d_zremrangeByScore(key, start, end).getResult();
    }

    public Long zlexcount(String key, String min, String max) {
        return (Long)this.d_zlexcount(key, min, max).getResult();
    }

    public OperationResult<Long> d_zlexcount(final String key, final String min, final String max) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZLEXCOUNT){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zlexcount(key, min, max);
            }
        });
    }

    public Set<String> zrangeByLex(String key, String min, String max) {
        return (Set)this.d_zrangeByLex(key, min, max).getResult();
    }

    public OperationResult<Set<String>> d_zrangeByLex(final String key, final String min, final String max) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZRANGEBYLEX){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrangeByLex(key, min, max);
            }
        });
    }

    public Set<String> zrangeByLex(String key, String min, String max, int offset, int count) {
        return (Set)this.d_zrangeByLex(key, min, max, offset, count).getResult();
    }

    public OperationResult<Set<String>> d_zrangeByLex(final String key, final String min, final String max, final int offset, final int count) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZRANGEBYLEX){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrangeByLex(key, min, max, offset, count);
            }
        });
    }

    public Long zremrangeByLex(String key, String min, String max) {
        return (Long)this.d_zremrangeByLex(key, min, max).getResult();
    }

    public OperationResult<Long> d_zremrangeByLex(final String key, final String min, final String max) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZREMRANGEBYLEX){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zremrangeByLex(key, min, max);
            }
        });
    }

    public OperationResult<Long> d_zremrangeByScore(final String key, final String start, final String end) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZREMRANGEBYSCORE){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zremrangeByScore(key, start, end);
            }
        });
    }

    public List<String> blpop(int timeout, String key) {
        return (List)this.d_blpop(timeout, key).getResult();
    }

    public OperationResult<List<String>> d_blpop(final int timeout, final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<List<String>>(key, OpName.BLPOP){

            public List<String> execute(Jedis client, ConnectionContext state) {
                return client.blpop(timeout, key);
            }
        });
    }

    public List<String> brpop(int timeout, String key) {
        return (List)this.d_brpop(timeout, key).getResult();
    }

    public OperationResult<List<String>> d_brpop(final int timeout, final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<List<String>>(key, OpName.BRPOP){

            public List<String> execute(Jedis client, ConnectionContext state) {
                return client.brpop(timeout, key);
            }
        });
    }

    public String echo(String string) {
        return (String)this.d_echo(string).getResult();
    }

    public OperationResult<String> d_echo(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.ECHO){

            public String execute(Jedis client, ConnectionContext state) {
                return client.echo(key);
            }
        });
    }

    public Long move(String key, int dbIndex) {
        return (Long)this.d_move(key, dbIndex).getResult();
    }

    public OperationResult<Long> d_move(final String key, final Integer dbIndex) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.MOVE){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.move(key, dbIndex.intValue());
            }
        });
    }

    public Long bitcount(String key) {
        return (Long)this.d_bitcount(key).getResult();
    }

    public OperationResult<Long> d_bitcount(final String key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.BITCOUNT){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.bitcount(key);
            }
        });
    }

    public Long pfadd(String key, String ... elements) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public long pfcount(String key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long bitcount(String key, long start, long end) {
        return (Long)this.d_bitcount(key, start, end).getResult();
    }

    public OperationResult<Long> d_bitcount(final String key, final Long start, final Long end) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.BITCOUNT){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.bitcount(key, start.longValue(), end.longValue());
            }
        });
    }

    public List<String> blpop(int timeout, String ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<String> brpop(int timeout, String ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<String> blpop(String ... args) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<String> brpop(String ... args) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<String> keys(String pattern) {
        HashSet<String> allResults = new HashSet<String>();
        Collection<OperationResult<Set<String>>> results = this.d_keys(pattern);
        for (OperationResult<Set<String>> result : results) {
            allResults.addAll((Collection)result.getResult());
        }
        return allResults;
    }

    public Collection<OperationResult<Set<String>>> d_keys(final String pattern) {
        Logger.warn("Executing d_keys for pattern: " + pattern);
        Collection results = this.connPool.executeWithRing(new CursorBasedResultImpl(new LinkedHashMap()), (Operation)new BaseKeyOperation<Set<String>>(pattern, OpName.KEYS){

            public Set<String> execute(Jedis client, ConnectionContext state) throws DynoException {
                return client.keys(pattern);
            }
        });
        return results;
    }

    public Long pexpire(String key, long milliseconds) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<String> mget(String ... keys) {
        return (List)this.d_mget(keys).getResult();
    }

    public OperationResult<List<String>> d_mget(final String ... keys) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new MultiKeyOperation<List<String>>(Arrays.asList(keys), OpName.MGET){

                public List<String> execute(Jedis client, ConnectionContext state) {
                    return client.mget(keys);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueMultiKeyOperation<List<String>>(Arrays.asList(keys), OpName.MGET){

            public List<String> execute(Jedis client, final ConnectionContext state) throws DynoException {
                return new ArrayList<String>(CollectionUtils.transform((Collection)client.mget(keys), (CollectionUtils.Transform)new CollectionUtils.Transform<String, String>(){

                    public String get(String s) {
                        return this.decompressValue(state, s);
                    }
                }));
            }
        });
    }

    public Long exists(String ... arg0) {
        return (Long)this.d_exists(arg0).getResult();
    }

    public OperationResult<Long> d_exists(final String ... arg0) {
        return this.connPool.executeWithFailover((Operation)new MultiKeyOperation<Long>(Arrays.asList(arg0), OpName.EXISTS){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.exists(arg0);
            }
        });
    }

    public Long del(String ... keys) {
        return (Long)this.d_del(keys).getResult();
    }

    public Long unlink(String ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public OperationResult<Long> d_del(final String ... keys) {
        return this.connPool.executeWithFailover((Operation)new MultiKeyOperation<Long>(Arrays.asList(keys), OpName.DEL){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.del(keys);
            }
        });
    }

    public Long msetnx(String ... keysvalues) {
        return (Long)this.d_msetnx(keysvalues).getResult();
    }

    public OperationResult<Long> d_msetnx(final String ... keysvalues) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new MultiKeyOperation<Long>(Arrays.asList(keysvalues), OpName.MSETNX){

                public Long execute(Jedis client, ConnectionContext state) {
                    return client.msetnx(keysvalues);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueMultiKeyOperation<Long>(Arrays.asList(keysvalues), OpName.MSETNX){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.msetnx(this.compressMultiKeyValue(state, keysvalues));
            }
        });
    }

    public String mset(String ... keysvalues) {
        return (String)this.d_mset(keysvalues).getResult();
    }

    public OperationResult<String> d_mset(final String ... keysvalues) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new MultiKeyOperation<String>(Arrays.asList(keysvalues), OpName.MSET){

                public String execute(Jedis client, ConnectionContext state) {
                    return client.mset(keysvalues);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueMultiKeyOperation<String>(Arrays.asList(keysvalues), OpName.MSET){

            public String execute(Jedis client, ConnectionContext state) {
                return client.mset(this.compressMultiKeyValue(state, keysvalues));
            }
        });
    }

    public Set<String> sinter(String ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long sinterstore(String dstkey, String ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long sort(String key, SortingParams sortingParameters, String dstkey) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long sort(String key, String dstkey) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<String> sunion(String ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long sunionstore(String dstkey, String ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String watch(String ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long del(byte[] ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long unlink(byte[] ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long exists(byte[] ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<byte[]> blpop(int timeout, byte[] ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<byte[]> brpop(int timeout, byte[] ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<byte[]> blpop(byte[] ... args) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<byte[]> brpop(byte[] ... args) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> keys(byte[] pattern) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<byte[]> mget(byte[] ... keys) {
        return (List)this.d_mget(keys).getResult();
    }

    public OperationResult<List<byte[]>> d_mget(final byte[] ... keys) {
        if (ConnectionPoolConfiguration.CompressionStrategy.NONE == this.connPool.getConfiguration().getCompressionStrategy()) {
            return this.connPool.executeWithFailover((Operation)new MultiKeyOperation<List<byte[]>>(Arrays.asList(keys), OpName.MGET){

                public List<byte[]> execute(Jedis client, ConnectionContext state) {
                    return client.mget(keys);
                }
            });
        }
        return this.connPool.executeWithFailover((Operation)new CompressionValueMultiKeyOperation<List<byte[]>>(Arrays.asList(keys), OpName.MGET){

            public List<byte[]> execute(Jedis client, final ConnectionContext state) throws DynoException {
                return new ArrayList<byte[]>(CollectionUtils.transform((Collection)client.mget(keys), (CollectionUtils.Transform)new CollectionUtils.Transform<byte[], byte[]>(){

                    public byte[] get(byte[] s) {
                        return this.decompressValue(state, String.valueOf(s)).getBytes();
                    }
                }));
            }
        });
    }

    public String mset(byte[] ... keysvalues) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long msetnx(byte[] ... keysvalues) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String rename(byte[] oldkey, byte[] newkey) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long renamenx(byte[] oldkey, byte[] newkey) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public byte[] rpoplpush(byte[] srckey, byte[] dstkey) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> sdiff(byte[] ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long sdiffstore(byte[] dstkey, byte[] ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> sinter(byte[] ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long sinterstore(byte[] dstkey, byte[] ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long smove(byte[] srckey, byte[] dstkey, byte[] member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long sort(byte[] key, SortingParams sortingParameters, byte[] dstkey) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long sort(byte[] key, byte[] dstkey) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> sunion(byte[] ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long sunionstore(byte[] dstkey, byte[] ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String watch(byte[] ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String unwatch() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zinterstore(byte[] dstkey, byte[] ... sets) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zinterstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zunionstore(byte[] dstkey, byte[] ... sets) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zunionstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public byte[] brpoplpush(byte[] source, byte[] destination, int timeout) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long publish(byte[] channel, byte[] message) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void subscribe(BinaryJedisPubSub jedisPubSub, byte[] ... channels) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void psubscribe(BinaryJedisPubSub jedisPubSub, byte[] ... patterns) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public byte[] randomBinaryKey() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long bitop(BitOP op, byte[] destKey, byte[] ... srcKeys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String pfmerge(byte[] destkey, byte[] ... sourcekeys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long pfcount(byte[] ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long touch(byte[] ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zinterstore(String dstkey, String ... sets) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zinterstore(String dstkey, ZParams params, String ... sets) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<String> zrevrangeByLex(String key, String max, String min) {
        return (Set)this.d_zrevrangeByLex(key, max, min).getResult();
    }

    public OperationResult<Set<String>> d_zrevrangeByLex(final String key, final String max, final String min) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZREVRANGEBYLEX){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrangeByLex(key, max, min);
            }
        });
    }

    public Set<String> zrevrangeByLex(String key, String max, String min, int offset, int count) {
        return (Set)this.d_zrevrangeByLex(key, max, min, offset, count).getResult();
    }

    public OperationResult<Set<String>> d_zrevrangeByLex(final String key, final String max, final String min, final int offset, final int count) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<String>>(key, OpName.ZREVRANGEBYLEX){

            public Set<String> execute(Jedis client, ConnectionContext state) {
                return client.zrangeByLex(key, max, min, offset, count);
            }
        });
    }

    public Long zunionstore(String dstkey, String ... sets) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zunionstore(String dstkey, ZParams params, String ... sets) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String brpoplpush(String source, String destination, int timeout) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long publish(String channel, String message) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void psubscribe(JedisPubSub jedisPubSub, String ... patterns) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String randomKey() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long bitop(BitOP op, String destKey, String ... srcKeys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String set(byte[] key, byte[] value) {
        return (String)this.d_set(key, value).getResult();
    }

    public OperationResult<String> d_set(final byte[] key, final byte[] value) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.SET){

            public String execute(Jedis client, ConnectionContext state) throws DynoException {
                return client.set(key, value);
            }
        });
    }

    public byte[] get(byte[] key) {
        return (byte[])this.d_get(key).getResult();
    }

    public OperationResult<byte[]> d_get(final byte[] key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<byte[]>(key, OpName.GET){

            public byte[] execute(Jedis client, ConnectionContext state) throws DynoException {
                return client.get(key);
            }
        });
    }

    public String setex(byte[] key, int seconds, byte[] value) {
        return (String)this.d_setex(key, (Integer)seconds, value).getResult();
    }

    public OperationResult<String> d_setex(final byte[] key, final Integer seconds, final byte[] value) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.SETEX){

            public String execute(Jedis client, ConnectionContext state) throws DynoException {
                return client.setex(key, seconds.intValue(), value);
            }
        });
    }

    public String psetex(byte[] key, long milliseconds, byte[] value) {
        return (String)this.d_psetex(key, (Long)milliseconds, value).getResult();
    }

    public OperationResult<String> d_psetex(final byte[] key, final Long milliseconds, final byte[] value) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.PSETEX){

            public String execute(Jedis client, ConnectionContext state) throws DynoException {
                return client.psetex(key, milliseconds.longValue(), value);
            }
        });
    }

    public String set(byte[] key, byte[] value, SetParams setParams) {
        return (String)this.d_set(key, value, setParams).getResult();
    }

    public OperationResult<String> d_set(final byte[] key, final byte[] value, final SetParams setParams) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.SET){

            public String execute(Jedis client, ConnectionContext state) throws DynoException {
                return client.set(key, value, setParams);
            }
        });
    }

    public Boolean exists(byte[] key) {
        return (Boolean)this.d_exists(key).getResult();
    }

    public OperationResult<Boolean> d_exists(final byte[] key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Boolean>(key, OpName.EXISTS){

            public Boolean execute(Jedis client, ConnectionContext state) {
                return client.exists(key);
            }
        });
    }

    public Long persist(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String type(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public byte[] dump(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String restore(byte[] key, int ttl, byte[] serializedValue) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String restoreReplace(byte[] key, int ttl, byte[] serializedValue) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long expire(byte[] key, int seconds) {
        return (Long)this.d_expire(key, seconds).getResult();
    }

    public OperationResult<Long> d_expire(final byte[] key, final int seconds) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.EXPIRE){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.expire(key, seconds);
            }
        });
    }

    public Long pexpire(byte[] key, long milliseconds) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long expireAt(byte[] key, long unixTime) {
        return (Long)this.d_expireAt(key, unixTime).getResult();
    }

    public OperationResult<Long> d_expireAt(final byte[] key, final long unixTime) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.EXPIREAT){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.expireAt(key, unixTime);
            }
        });
    }

    public Long pexpireAt(byte[] key, long millisecondsTimestamp) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long ttl(byte[] key) {
        return (Long)this.d_ttl(key).getResult();
    }

    public OperationResult<Long> d_ttl(final byte[] key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.TTL){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.ttl(key);
            }
        });
    }

    public Long pttl(byte[] key) {
        return (Long)this.d_pttl(key).getResult();
    }

    public OperationResult<Long> d_pttl(final byte[] key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.PTTL){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.pttl(key);
            }
        });
    }

    public Long touch(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Boolean setbit(byte[] key, long offset, boolean value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Boolean setbit(byte[] key, long offset, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Boolean getbit(byte[] key, long offset) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long setrange(byte[] key, long offset, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public byte[] getrange(byte[] key, long startOffset, long endOffset) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public byte[] getSet(byte[] key, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long setnx(byte[] key, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long decrBy(byte[] key, long integer) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long decr(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long incrBy(byte[] key, long integer) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Double incrByFloat(byte[] key, double value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long incr(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long append(byte[] key, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public byte[] substr(byte[] key, int start, int end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long hset(byte[] key, byte[] field, byte[] value) {
        return (Long)this.d_hset(key, field, value).getResult();
    }

    public Long hset(byte[] key, Map<byte[], byte[]> hash) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public OperationResult<Long> d_hset(final byte[] key, final byte[] field, final byte[] value) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.HSET){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.hset(key, field, value);
            }
        });
    }

    public byte[] hget(byte[] key, byte[] field) {
        return (byte[])this.d_hget(key, field).getResult();
    }

    public OperationResult<byte[]> d_hget(final byte[] key, final byte[] field) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<byte[]>(key, OpName.HGET){

            public byte[] execute(Jedis client, ConnectionContext state) throws DynoException {
                return client.hget(key, field);
            }
        });
    }

    public Long hsetnx(byte[] key, byte[] field, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String hmset(byte[] key, Map<byte[], byte[]> hash) {
        return (String)this.d_hmset(key, hash).getResult();
    }

    public OperationResult<String> d_hmset(final byte[] key, final Map<byte[], byte[]> hash) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<String>(key, OpName.HMSET){

            public String execute(Jedis client, ConnectionContext state) {
                return client.hmset(key, hash);
            }
        });
    }

    public List<byte[]> hmget(byte[] key, byte[] ... fields) {
        return (List)this.d_hmget(key, fields).getResult();
    }

    public OperationResult<List<byte[]>> d_hmget(final byte[] key, final byte[] ... fields) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<List<byte[]>>(key, OpName.HMGET){

            public List<byte[]> execute(Jedis client, ConnectionContext state) {
                return client.hmget(key, fields);
            }
        });
    }

    public Long hincrBy(byte[] key, byte[] field, long value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Double hincrByFloat(byte[] key, byte[] field, double value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Boolean hexists(byte[] key, byte[] field) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long hdel(byte[] key, byte[] ... fields) {
        return (Long)this.d_hdel(key, fields).getResult();
    }

    public OperationResult<Long> d_hdel(final byte[] key, final byte[] ... fields) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.HDEL){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.hdel(key, fields);
            }
        });
    }

    public Long hlen(byte[] key) {
        return (Long)this.d_hlen(key).getResult();
    }

    public OperationResult<Long> d_hlen(final byte[] key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.HLEN){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.hlen(key);
            }
        });
    }

    public Set<byte[]> hkeys(byte[] key) {
        return (Set)this.d_hkeys(key).getResult();
    }

    public OperationResult<Set<byte[]>> d_hkeys(final byte[] key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<byte[]>>(key, OpName.HKEYS){

            public Set<byte[]> execute(Jedis client, ConnectionContext state) {
                return client.hkeys(key);
            }
        });
    }

    public Collection<byte[]> hvals(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Map<byte[], byte[]> hgetAll(byte[] key) {
        return (Map)this.d_hgetAll(key).getResult();
    }

    public OperationResult<Map<byte[], byte[]>> d_hgetAll(final byte[] key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Map<byte[], byte[]>>(key, OpName.HGETALL){

            public Map<byte[], byte[]> execute(Jedis client, ConnectionContext state) throws DynoException {
                return client.hgetAll(key);
            }
        });
    }

    public Long rpush(byte[] key, byte[] ... args) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long lpush(byte[] key, byte[] ... args) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long llen(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<byte[]> lrange(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String ltrim(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public byte[] lindex(byte[] key, long index) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String lset(byte[] key, long index, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long lrem(byte[] key, long count, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public byte[] lpop(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public byte[] rpop(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long sadd(byte[] key, byte[] ... members) {
        return (Long)this.d_sadd(key, members).getResult();
    }

    public OperationResult<Long> d_sadd(final byte[] key, final byte[] ... members) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.SADD){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.sadd(key, members);
            }
        });
    }

    public Set<byte[]> smembers(byte[] key) {
        return (Set)this.d_smembers(key).getResult();
    }

    public OperationResult<Set<byte[]>> d_smembers(final byte[] key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Set<byte[]>>(key, OpName.SMEMBERS){

            public Set<byte[]> execute(Jedis client, ConnectionContext state) {
                return client.smembers(key);
            }
        });
    }

    public Long srem(byte[] key, byte[] ... members) {
        return (Long)this.d_srem(key, members).getResult();
    }

    public OperationResult<Long> d_srem(final byte[] key, final byte[] ... members) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.SREM){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.srem(key, members);
            }
        });
    }

    public byte[] spop(byte[] key) {
        return (byte[])this.d_spop(key).getResult();
    }

    public OperationResult<byte[]> d_spop(final byte[] key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<byte[]>(key, OpName.SPOP){

            public byte[] execute(Jedis client, ConnectionContext state) {
                return client.spop(key);
            }
        });
    }

    public Set<byte[]> spop(byte[] key, long count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long scard(byte[] key) {
        return (Long)this.d_scard(key).getResult();
    }

    public OperationResult<Long> d_scard(final byte[] key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.SCARD){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.scard(key);
            }
        });
    }

    public Boolean sismember(byte[] key, byte[] member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public byte[] srandmember(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<byte[]> srandmember(byte[] key, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long strlen(byte[] key) {
        return (Long)this.d_strlen(key).getResult();
    }

    public OperationResult<Long> d_strlen(final byte[] key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.STRLEN){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.strlen(key);
            }
        });
    }

    public Long zadd(byte[] key, double score, byte[] member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrange(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zrem(byte[] key, byte[] ... member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Double zincrby(byte[] key, double score, byte[] member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zrank(byte[] key, byte[] member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zrevrank(byte[] key, byte[] member) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrevrange(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<Tuple> zrangeWithScores(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<Tuple> zrevrangeWithScores(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zcard(byte[] key) {
        return (Long)this.d_zcard(key).getResult();
    }

    public OperationResult<Long> d_zcard(final byte[] key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.ZCARD){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.zcard(key);
            }
        });
    }

    public Double zscore(byte[] key, byte[] member) {
        return (Double)this.d_zscore(key, member).getResult();
    }

    public OperationResult<Double> d_zscore(final byte[] key, final byte[] member) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Double>(key, OpName.ZSCORE){

            public Double execute(Jedis client, ConnectionContext state) {
                return client.zscore(key, member);
            }
        });
    }

    public List<byte[]> sort(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<byte[]> sort(byte[] key, SortingParams sortingParameters) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zcount(byte[] key, double min, double max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zcount(byte[] key, byte[] min, byte[] max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrangeByScore(byte[] key, double min, double max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zremrangeByRank(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zremrangeByScore(byte[] key, double start, double end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zremrangeByScore(byte[] key, byte[] start, byte[] end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zlexcount(byte[] key, byte[] min, byte[] max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrangeByLex(byte[] key, byte[] min, byte[] max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrangeByLex(byte[] key, byte[] min, byte[] max, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max, byte[] min) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max, byte[] min, int offset, int count) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zremrangeByLex(byte[] key, byte[] min, byte[] max) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long linsert(byte[] key, ListPosition where, byte[] pivot, byte[] value) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long lpushx(byte[] key, byte[] ... arg) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long rpushx(byte[] key, byte[] ... arg) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long del(byte[] key) {
        return (Long)this.d_del(key).getResult();
    }

    public OperationResult<Long> d_del(final byte[] key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.DEL){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.del(key);
            }
        });
    }

    public Long unlink(byte[] key) {
        return (Long)this.d_unlink(key).getResult();
    }

    public OperationResult<Long> d_unlink(final byte[] key) {
        return this.connPool.executeWithFailover((Operation)new BaseKeyOperation<Long>(key, OpName.UNLINK){

            public Long execute(Jedis client, ConnectionContext state) {
                return client.unlink(key);
            }
        });
    }

    public byte[] echo(byte[] arg) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long move(byte[] key, int dbIndex) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long bitcount(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long bitcount(byte[] key, long start, long end) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long pfadd(byte[] key, byte[] ... elements) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public long pfcount(byte[] key) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public ScanResult<String> scan(String cursor) {
        throw new UnsupportedOperationException("Not supported - use dyno_scan(String, CursorBasedResult");
    }

    public CursorBasedResult<String> dyno_scan(String ... pattern) {
        return this.dyno_scan(10, pattern);
    }

    public CursorBasedResult<String> dyno_scan(int count, String ... pattern) {
        return this.dyno_scan(null, count, pattern);
    }

    public CursorBasedResult<String> dyno_scan(CursorBasedResult<String> cursor, int count, String ... pattern) {
        if (cursor == null) {
            cursor = new CursorBasedResultImpl<String>(new LinkedHashMap());
        }
        LinkedHashMap results = new LinkedHashMap();
        List<OperationResult<ScanResult<String>>> opResults = this.scatterGatherScan(cursor, count, pattern);
        for (OperationResult<ScanResult<String>> opResult : opResults) {
            results.put(opResult.getNode().getHostAddress(), opResult.getResult());
        }
        return new CursorBasedResultImpl<String>(results, ((TokenRackMapper)cursor).getTokenRackMap());
    }

    public String pfmerge(String destkey, String ... sourcekeys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public long pfcount(String ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long touch(String ... keys) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    private boolean validHashtag(String hashtag) {
        return !Strings.isNullOrEmpty((String)hashtag) && hashtag.length() == 2;
    }

    private String ehashDataKey(String key) {
        String hashtag = this.connPool.getConfiguration().getHashtag();
        if (!this.validHashtag(hashtag)) {
            throw new IllegalStateException("hashtags not set");
        }
        return new StringBuilder(hashtag).insert(1, key).toString();
    }

    @VisibleForTesting
    String ehashMetadataKey(String key) {
        String hashtag = this.connPool.getConfiguration().getHashtag();
        if (!this.validHashtag(hashtag)) {
            throw new IllegalStateException("hashtags not set");
        }
        return new StringBuilder(hashtag).insert(0, DYNO_EXIPREHASH_METADATA_KEYPREFIX).insert(DYNO_EXIPREHASH_METADATA_KEYPREFIX.length() + 1, key).toString();
    }

    private double timeInEpochSeconds(long ttl) {
        long timeSinceEpoch = System.currentTimeMillis() / 1000L;
        return timeSinceEpoch + ttl;
    }

    private EHMetadataUpdateResult ehPurgeExpiredFields(DynoJedisPipeline pipeline, String key) {
        String metadataKey = this.ehashMetadataKey(key);
        String dataKey = this.ehashDataKey(key);
        double now = this.timeInEpochSeconds(0L);
        Set<String> expiredFields = this.zrangeByScore(metadataKey, 0.0, now);
        Response<Long> hdelResponse = null;
        Response<Long> zremResponse = null;
        if (expiredFields.size() > 0) {
            hdelResponse = pipeline.hdel(dataKey, expiredFields.toArray(new String[0]));
            zremResponse = pipeline.zremrangeByScore(metadataKey, 0.0, now);
        }
        return new EHMetadataUpdateResult(dataKey, metadataKey, expiredFields, hdelResponse, zremResponse);
    }

    private void ehVerifyMetadataUpdate(EHMetadataUpdateResult ehMetadataUpdateResult) {
        if (ehMetadataUpdateResult.expiredFields.size() > 0 && ehMetadataUpdateResult.hdelResponse != null && (long)ehMetadataUpdateResult.expiredFields.size() != (Long)ehMetadataUpdateResult.hdelResponse.get()) {
            Logger.debug("Expire hash:{} inconsistent with metadata:{}. Failed to delete expired fields from hash", (Object)ehMetadataUpdateResult.dataKey, (Object)ehMetadataUpdateResult.metadataKey);
        }
        if (ehMetadataUpdateResult.expiredFields.size() > 0 && ehMetadataUpdateResult.zremResponse != null && (long)ehMetadataUpdateResult.expiredFields.size() != (Long)ehMetadataUpdateResult.zremResponse.get()) {
            Logger.debug("Expire hash:{} inconsistent with metadata:{}. Failed to delete expired fields from metadata", (Object)ehMetadataUpdateResult.dataKey, (Object)ehMetadataUpdateResult.metadataKey);
        }
    }

    @Override
    public Long ehset(String key, String field, String value, long ttl) throws UnsupportedOperationException, DynoException {
        DynoJedisPipeline pipeline = this.pipelined();
        Response<Long> zResponse = pipeline.zadd(this.ehashMetadataKey(key), this.timeInEpochSeconds(ttl), field, ZAddParams.zAddParams().ch());
        Response<Long> hResponse = pipeline.hset(this.ehashDataKey(key), field, value);
        pipeline.sync();
        return (Long)hResponse.get();
    }

    @Override
    public Long ehsetnx(String key, String field, String value, long ttl) {
        String ehashDataKey = this.ehashDataKey(key);
        String ehashMetadataKey = this.ehashMetadataKey(key);
        DynoJedisPipeline pipeline = this.pipelined();
        Response<Long> zResponse = pipeline.zadd(ehashMetadataKey, this.timeInEpochSeconds(ttl), field, ZAddParams.zAddParams().ch());
        Response<Long> hResponse = pipeline.hsetnx(ehashDataKey, field, value);
        pipeline.sync();
        if (!((Long)zResponse.get()).equals(hResponse.get())) {
            this.d_hdel(ehashDataKey, field);
            this.d_zrem(ehashMetadataKey, field);
            throw new DynoException("Metadata inconsistent with data for expireHash: " + ehashDataKey);
        }
        return (Long)hResponse.get();
    }

    @Override
    public String ehget(String key, String field) throws UnsupportedOperationException, DynoException {
        String dataKey = this.ehashDataKey(key);
        DynoJedisPipeline pipeline = this.pipelined();
        EHMetadataUpdateResult ehMetadataUpdateResult = this.ehPurgeExpiredFields(pipeline, key);
        Response<String> getResponse = pipeline.hget(dataKey, field);
        pipeline.sync();
        this.ehVerifyMetadataUpdate(ehMetadataUpdateResult);
        if (ehMetadataUpdateResult.expiredFields.size() > 0 && ehMetadataUpdateResult.hdelResponse != null && (long)ehMetadataUpdateResult.expiredFields.size() != (Long)ehMetadataUpdateResult.hdelResponse.get() && ehMetadataUpdateResult.expiredFields.contains(field)) {
            throw new DynoException("Failed to update expire hash metadata");
        }
        return (String)getResponse.get();
    }

    @Override
    public Long ehdel(String key, String ... fields) {
        DynoJedisPipeline pipeline = this.pipelined();
        Response<Long> zResponse = pipeline.zrem(this.ehashMetadataKey(key), fields);
        Response<Long> hResponse = pipeline.hdel(this.ehashDataKey(key), fields);
        pipeline.sync();
        if (((Long)zResponse.get()).compareTo((Long)hResponse.get()) != 0) {
            Logger.error("Operation: {} - data: {} and metadata: {} field count mismatch", new Object[]{OpName.EHDEL, hResponse.get(), zResponse.get()});
        }
        return (Long)hResponse.get();
    }

    @Override
    public Boolean ehexists(String key, String field) {
        String dataKey = this.ehashDataKey(key);
        DynoJedisPipeline pipeline = this.pipelined();
        EHMetadataUpdateResult ehMetadataUpdateResult = this.ehPurgeExpiredFields(pipeline, key);
        Response<Boolean> existsResponse = pipeline.hexists(dataKey, field);
        pipeline.sync();
        this.ehVerifyMetadataUpdate(ehMetadataUpdateResult);
        if (ehMetadataUpdateResult.expiredFields.size() > 0 && ehMetadataUpdateResult.hdelResponse != null && (long)ehMetadataUpdateResult.expiredFields.size() != (Long)ehMetadataUpdateResult.hdelResponse.get() && ehMetadataUpdateResult.expiredFields.contains(field)) {
            throw new DynoException("Failed to update expire hash metadata");
        }
        return (Boolean)existsResponse.get();
    }

    @Override
    public Map<String, String> ehgetall(String key) {
        String dataKey = this.ehashDataKey(key);
        DynoJedisPipeline pipeline = this.pipelined();
        EHMetadataUpdateResult ehMetadataUpdateResult = this.ehPurgeExpiredFields(pipeline, key);
        Response<Map<String, String>> getallResponse = pipeline.hgetAll(dataKey);
        pipeline.sync();
        this.ehVerifyMetadataUpdate(ehMetadataUpdateResult);
        if (ehMetadataUpdateResult.expiredFields.size() > 0 && ehMetadataUpdateResult.hdelResponse != null && (long)ehMetadataUpdateResult.expiredFields.size() != (Long)ehMetadataUpdateResult.hdelResponse.get()) {
            throw new DynoException("Failed to expire hash fields");
        }
        return (Map)getallResponse.get();
    }

    @Override
    public Set<String> ehkeys(String key) {
        String dataKey = this.ehashDataKey(key);
        DynoJedisPipeline pipeline = this.pipelined();
        EHMetadataUpdateResult ehMetadataUpdateResult = this.ehPurgeExpiredFields(pipeline, key);
        Response<Set<String>> getkeysResponse = pipeline.hkeys(dataKey);
        pipeline.sync();
        this.ehVerifyMetadataUpdate(ehMetadataUpdateResult);
        if (ehMetadataUpdateResult.expiredFields.size() > 0 && ehMetadataUpdateResult.hdelResponse != null && (long)ehMetadataUpdateResult.expiredFields.size() != (Long)ehMetadataUpdateResult.hdelResponse.get()) {
            throw new DynoException("Failed to expire hash fields");
        }
        return (Set)getkeysResponse.get();
    }

    @Override
    public List<String> ehvals(String key) {
        String dataKey = this.ehashDataKey(key);
        DynoJedisPipeline pipeline = this.pipelined();
        EHMetadataUpdateResult ehMetadataUpdateResult = this.ehPurgeExpiredFields(pipeline, key);
        Response<List<String>> getvalsResponse = pipeline.hvals(dataKey);
        pipeline.sync();
        this.ehVerifyMetadataUpdate(ehMetadataUpdateResult);
        if (ehMetadataUpdateResult.expiredFields.size() > 0 && ehMetadataUpdateResult.hdelResponse != null && (long)ehMetadataUpdateResult.expiredFields.size() != (Long)ehMetadataUpdateResult.hdelResponse.get()) {
            throw new DynoException("Failed to expire hash fields");
        }
        return (List)getvalsResponse.get();
    }

    @Override
    public List<String> ehmget(String key, String ... fields) {
        String dataKey = this.ehashDataKey(key);
        DynoJedisPipeline pipeline = this.pipelined();
        EHMetadataUpdateResult ehMetadataUpdateResult = this.ehPurgeExpiredFields(pipeline, key);
        Response<List<String>> mgetResponse = pipeline.hmget(dataKey, fields);
        pipeline.sync();
        this.ehVerifyMetadataUpdate(ehMetadataUpdateResult);
        if (ehMetadataUpdateResult.expiredFields.size() > 0 && ehMetadataUpdateResult.hdelResponse != null && (long)ehMetadataUpdateResult.expiredFields.size() != (Long)ehMetadataUpdateResult.hdelResponse.get()) {
            if (Arrays.stream(fields).anyMatch(ehMetadataUpdateResult.expiredFields::contains)) {
                throw new DynoException("Failed to expire hash fields");
            }
        }
        return (List)mgetResponse.get();
    }

    @Override
    public String ehmset(String key, Map<String, Pair<String, Long>> hash) {
        DynoJedisPipeline pipeline = this.pipelined();
        HashMap<String, String> fields = new HashMap<String, String>();
        HashMap<String, Double> metadataFields = new HashMap<String, Double>();
        hash.keySet().forEach(f -> {
            fields.put((String)f, (String)((Pair)hash.get(f)).getLeft());
            metadataFields.put((String)f, this.timeInEpochSeconds((Long)((Pair)hash.get(f)).getRight()));
        });
        Response<Long> zResponse = pipeline.zadd(this.ehashMetadataKey(key), metadataFields, ZAddParams.zAddParams().ch());
        Response<String> hResponse = pipeline.hmset(this.ehashDataKey(key), fields);
        pipeline.sync();
        return (String)hResponse.get();
    }

    @Override
    public ScanResult<Map.Entry<String, String>> ehscan(String key, String cursor) {
        String dataKey = this.ehashDataKey(key);
        DynoJedisPipeline pipeline = this.pipelined();
        EHMetadataUpdateResult ehMetadataUpdateResult = this.ehPurgeExpiredFields(pipeline, key);
        if (ehMetadataUpdateResult.expiredFields.size() > 0) {
            pipeline.sync();
        } else {
            pipeline.discardPipelineAndReleaseConnection();
        }
        this.ehVerifyMetadataUpdate(ehMetadataUpdateResult);
        if (ehMetadataUpdateResult.expiredFields.size() > 0 && ehMetadataUpdateResult.hdelResponse != null && (long)ehMetadataUpdateResult.expiredFields.size() != (Long)ehMetadataUpdateResult.hdelResponse.get()) {
            throw new DynoException("Failed to expire hash fields");
        }
        return this.hscan(dataKey, cursor);
    }

    @Override
    public Long ehincrby(String key, String field, long value) {
        String dataKey = this.ehashDataKey(key);
        DynoJedisPipeline pipeline = this.pipelined();
        EHMetadataUpdateResult ehMetadataUpdateResult = this.ehPurgeExpiredFields(pipeline, key);
        Response<Long> incrbyResponse = pipeline.hincrBy(dataKey, field, value);
        pipeline.sync();
        this.ehVerifyMetadataUpdate(ehMetadataUpdateResult);
        if (ehMetadataUpdateResult.expiredFields.size() > 0 && ehMetadataUpdateResult.hdelResponse != null && (long)ehMetadataUpdateResult.expiredFields.size() != (Long)ehMetadataUpdateResult.hdelResponse.get() && ehMetadataUpdateResult.expiredFields.contains(field)) {
            throw new DynoException("Failed to expire hash fields");
        }
        return (Long)incrbyResponse.get();
    }

    @Override
    public Double ehincrbyfloat(String key, String field, double value) {
        String dataKey = this.ehashDataKey(key);
        DynoJedisPipeline pipeline = this.pipelined();
        EHMetadataUpdateResult ehMetadataUpdateResult = this.ehPurgeExpiredFields(pipeline, key);
        Response<Double> incrbyFloatResponse = pipeline.hincrByFloat(dataKey, field, value);
        pipeline.sync();
        this.ehVerifyMetadataUpdate(ehMetadataUpdateResult);
        if (ehMetadataUpdateResult.expiredFields.size() > 0 && ehMetadataUpdateResult.hdelResponse != null && (long)ehMetadataUpdateResult.expiredFields.size() != (Long)ehMetadataUpdateResult.hdelResponse.get() && ehMetadataUpdateResult.expiredFields.contains(field)) {
            throw new DynoException("Failed to expire hash fields");
        }
        return (Double)incrbyFloatResponse.get();
    }

    @Override
    public Long ehlen(String key) {
        String dataKey = this.ehashDataKey(key);
        DynoJedisPipeline pipeline = this.pipelined();
        EHMetadataUpdateResult ehMetadataUpdateResult = this.ehPurgeExpiredFields(pipeline, key);
        Response<Long> hlenResponse = pipeline.hlen(dataKey);
        pipeline.sync();
        this.ehVerifyMetadataUpdate(ehMetadataUpdateResult);
        if (ehMetadataUpdateResult.expiredFields.size() > 0 && ehMetadataUpdateResult.hdelResponse != null && (long)ehMetadataUpdateResult.expiredFields.size() != (Long)ehMetadataUpdateResult.hdelResponse.get()) {
            throw new DynoException("Failed to expire hash fields");
        }
        return (Long)hlenResponse.get();
    }

    @Override
    public String ehrename(String oldKey, String newKey) {
        String dataOldKey = this.ehashDataKey(oldKey);
        String dataNewKey = this.ehashDataKey(newKey);
        String metadataOldKey = this.ehashMetadataKey(oldKey);
        String metadataNewKey = this.ehashMetadataKey(newKey);
        DynoJedisPipeline pipeline = this.pipelined();
        Response<String> zrenameResponse = pipeline.rename(metadataOldKey, metadataNewKey);
        Response<String> hrenameResponse = pipeline.rename(dataOldKey, dataNewKey);
        pipeline.sync();
        if (((String)zrenameResponse.get()).compareTo("OK") != 0) {
            this.rename(dataNewKey, dataOldKey);
            throw new DynoException("Unable to rename key: " + metadataOldKey + " to key:" + metadataNewKey);
        }
        return (String)hrenameResponse.get();
    }

    @Override
    public Long ehrenamenx(String oldKey, String newKey) {
        String dataOldKey = this.ehashDataKey(oldKey);
        String dataNewKey = this.ehashDataKey(newKey);
        String metadataOldKey = this.ehashMetadataKey(oldKey);
        String metadataNewKey = this.ehashMetadataKey(newKey);
        DynoJedisPipeline pipeline = this.pipelined();
        Response<Long> zrenamenxResponse = pipeline.renamenx(metadataOldKey, metadataNewKey);
        Response<Long> hrenamenxResponse = pipeline.renamenx(dataOldKey, dataNewKey);
        pipeline.sync();
        if ((Long)zrenamenxResponse.get() != 1L && (Long)hrenamenxResponse.get() == 1L) {
            this.rename(dataNewKey, dataOldKey);
            throw new DynoException("Unable to rename key: " + metadataOldKey + " to key:" + metadataNewKey);
        }
        return (Long)hrenamenxResponse.get();
    }

    @Override
    public Long ehexpire(String key, int seconds) {
        String dataKey = this.ehashDataKey(key);
        String metadataKey = this.ehashMetadataKey(key);
        DynoJedisPipeline pipeline = this.pipelined();
        Response<Long> metadataExpireResponse = pipeline.expire(metadataKey, seconds);
        Response<Long> dataExpireResponse = pipeline.expire(dataKey, seconds);
        pipeline.sync();
        if (((Long)metadataExpireResponse.get()).compareTo((Long)dataExpireResponse.get()) != 0) {
            throw new DynoException("Metadata and data timeout do not match");
        }
        return (Long)dataExpireResponse.get();
    }

    @Override
    public Long ehexpireat(String key, long timestamp) {
        String dataKey = this.ehashDataKey(key);
        String metadataKey = this.ehashMetadataKey(key);
        DynoJedisPipeline pipeline = this.pipelined();
        Response<Long> metadataExpireResponse = pipeline.expireAt(metadataKey, timestamp);
        Response<Long> dataExpireResponse = pipeline.expireAt(dataKey, timestamp);
        pipeline.sync();
        if (((Long)metadataExpireResponse.get()).compareTo((Long)dataExpireResponse.get()) != 0) {
            throw new DynoException("Metadata and data timeout do not match");
        }
        return (Long)dataExpireResponse.get();
    }

    @Override
    public Long ehpexpireat(String key, long timestamp) {
        String dataKey = this.ehashDataKey(key);
        String metadataKey = this.ehashMetadataKey(key);
        DynoJedisPipeline pipeline = this.pipelined();
        Response<Long> metadataExpireResponse = pipeline.pexpireAt(metadataKey, timestamp);
        Response<Long> dataExpireResponse = pipeline.pexpireAt(dataKey, timestamp);
        pipeline.sync();
        if (((Long)metadataExpireResponse.get()).compareTo((Long)dataExpireResponse.get()) != 0) {
            throw new DynoException("Metadata and data timeout do not match");
        }
        return (Long)dataExpireResponse.get();
    }

    @Override
    public Long ehpersist(String key) {
        String dataKey = this.ehashDataKey(key);
        String metadataKey = this.ehashMetadataKey(key);
        DynoJedisPipeline pipeline = this.pipelined();
        Response<Long> metadataPersistResponse = pipeline.persist(metadataKey);
        Response<Long> dataPersistResponse = pipeline.persist(dataKey);
        pipeline.sync();
        if (((Long)metadataPersistResponse.get()).compareTo((Long)dataPersistResponse.get()) != 0) {
            throw new DynoException("Metadata and data expiry do not match");
        }
        return (Long)dataPersistResponse.get();
    }

    @Override
    public Long ehttl(String key) {
        return this.ttl(this.ehashDataKey(key));
    }

    @Override
    public Long ehttl(String key, String field) {
        double now = this.timeInEpochSeconds(0L);
        String metadataKey = this.ehashMetadataKey(key);
        DynoJedisPipeline pipeline = this.pipelined();
        EHMetadataUpdateResult ehMetadataUpdateResult = this.ehPurgeExpiredFields(pipeline, key);
        Response<Double> zscoreResponse = pipeline.zscore(metadataKey, field);
        pipeline.sync();
        this.ehVerifyMetadataUpdate(ehMetadataUpdateResult);
        if (ehMetadataUpdateResult.expiredFields.size() > 0 && ehMetadataUpdateResult.hdelResponse != null && (long)ehMetadataUpdateResult.expiredFields.size() != (Long)ehMetadataUpdateResult.hdelResponse.get() && ehMetadataUpdateResult.expiredFields.contains(field)) {
            throw new DynoException("Failed to expire hash fields");
        }
        if ((Double)zscoreResponse.get() > 0.0) {
            return ((Double)zscoreResponse.get()).longValue() - (long)now;
        }
        return ((Double)zscoreResponse.get()).longValue();
    }

    @Override
    public Long ehpttl(String key) {
        return this.pttl(this.ehashDataKey(key));
    }

    @Override
    public Long ehpttl(String key, String field) {
        return this.ehttl(key, field);
    }

    public void stopClient() {
        if (this.pipelineMonitor.get() != null) {
            this.pipelineMonitor.get().stop();
        }
        this.connPool.shutdown();
    }

    public DynoJedisPipeline pipelined() {
        return new DynoJedisPipeline(this.getConnPool(), this.checkAndInitPipelineMonitor(), this.getConnPool().getMonitor());
    }

    private DynoJedisPipelineMonitor checkAndInitPipelineMonitor() {
        if (this.pipelineMonitor.get() != null) {
            return this.pipelineMonitor.get();
        }
        int flushTimerFrequency = this.connPool.getConfiguration().getTimingCountersResetFrequencySeconds();
        DynoJedisPipelineMonitor plMonitor = new DynoJedisPipelineMonitor(this.appName, flushTimerFrequency);
        boolean success = this.pipelineMonitor.compareAndSet(null, plMonitor);
        if (success) {
            this.pipelineMonitor.get().init();
        }
        return this.pipelineMonitor.get();
    }

    public ScanResult<String> scan(String arg0, ScanParams arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long geoadd(byte[] arg0, Map<byte[], GeoCoordinate> arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long geoadd(byte[] arg0, double arg1, double arg2, byte[] arg3) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Double geodist(byte[] arg0, byte[] arg1, byte[] arg2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Double geodist(byte[] arg0, byte[] arg1, byte[] arg2, GeoUnit arg3) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<byte[]> geohash(byte[] arg0, byte[] ... arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoCoordinate> geopos(byte[] arg0, byte[] ... arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoRadiusResponse> georadius(byte[] arg0, double arg1, double arg2, double arg3, GeoUnit arg4) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoRadiusResponse> georadiusReadonly(byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoRadiusResponse> georadius(byte[] arg0, double arg1, double arg2, double arg3, GeoUnit arg4, GeoRadiusParam arg5) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoRadiusResponse> georadiusReadonly(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoRadiusResponse> georadiusByMember(byte[] arg0, byte[] arg1, double arg2, GeoUnit arg3) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoRadiusResponse> georadiusByMemberReadonly(byte[] key, byte[] member, double radius, GeoUnit unit) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoRadiusResponse> georadiusByMember(byte[] arg0, byte[] arg1, double arg2, GeoUnit arg3, GeoRadiusParam arg4) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoRadiusResponse> georadiusByMemberReadonly(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] arg0, byte[] arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] arg0, byte[] arg1, ScanParams arg2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public ScanResult<byte[]> sscan(byte[] arg0, byte[] arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public ScanResult<byte[]> sscan(byte[] arg0, byte[] arg1, ScanParams arg2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zadd(byte[] arg0, Map<byte[], Double> arg1, ZAddParams arg2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zadd(byte[] arg0, double arg1, byte[] arg2, ZAddParams arg3) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Double zincrby(byte[] arg0, double arg1, byte[] arg2, ZIncrByParams arg3) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public ScanResult<Tuple> zscan(byte[] arg0, byte[] arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public ScanResult<Tuple> zscan(byte[] arg0, byte[] arg1, ScanParams arg2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<Long> bitfield(byte[] key, byte[] ... arguments) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long hstrlen(byte[] key, byte[] field) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long bitpos(String arg0, boolean arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long bitpos(String arg0, boolean arg1, BitPosParams arg2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long geoadd(String arg0, Map<String, GeoCoordinate> arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long geoadd(String arg0, double arg1, double arg2, String arg3) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Double geodist(String arg0, String arg1, String arg2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Double geodist(String arg0, String arg1, String arg2, GeoUnit arg3) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<String> geohash(String arg0, String ... arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoCoordinate> geopos(String arg0, String ... arg1) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoRadiusResponse> georadius(String arg0, double arg1, double arg2, double arg3, GeoUnit arg4) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoRadiusResponse> georadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoRadiusResponse> georadius(String arg0, double arg1, double arg2, double arg3, GeoUnit arg4, GeoRadiusParam arg5) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoRadiusResponse> georadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoRadiusResponse> georadiusByMember(String arg0, String arg1, double arg2, GeoUnit arg3) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoRadiusResponse> georadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoRadiusResponse> georadiusByMember(String arg0, String arg1, double arg2, GeoUnit arg3, GeoRadiusParam arg4) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<GeoRadiusResponse> georadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<Long> bitfield(String key, String ... arguments) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long hstrlen(String key, String field) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public ScanResult<Map.Entry<String, String>> hscan(String arg0, String arg1, ScanParams arg2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Long zadd(String arg0, Map<String, Double> arg1, ZAddParams arg2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Double zincrby(String arg0, double arg1, String arg2, ZIncrByParams arg3) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public ScanResult<Tuple> zscan(String arg0, String arg1, ScanParams arg2) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    static class TestBuilder {
        private ConnectionPool cp;
        private String appName;

        TestBuilder() {
        }

        public TestBuilder withAppname(String appName) {
            this.appName = appName;
            return this;
        }

        public TestBuilder withConnectionPool(ConnectionPool cp) {
            this.cp = cp;
            return this;
        }

        public DynoJedisClient build() {
            return new DynoJedisClient(this.appName, "TestCluster", (ConnectionPool<Jedis>)this.cp, null, null);
        }
    }

    public static class Builder {
        private String appName;
        private String clusterName;
        private ConnectionPoolConfigurationImpl cpConfig;
        private HostSupplier hostSupplier;
        private EurekaClient discoveryClient;
        private String dualWriteClusterName;
        private HostSupplier dualWriteHostSupplier;
        private DynoDualWriterClient.Dial dualWriteDial;
        private ConnectionPoolMonitor cpMonitor;
        private SSLSocketFactory sslSocketFactory;
        private TokenMapSupplier tokenMapSupplier;
        private TokenMapSupplier dualWriteTokenMapSupplier;
        private boolean isDatastoreClient;
        private String connectionPoolConsistency;

        public Builder withApplicationName(String applicationName) {
            this.appName = applicationName;
            return this;
        }

        public Builder withDynomiteClusterName(String cluster) {
            this.clusterName = cluster;
            return this;
        }

        public Builder withCPConfig(ConnectionPoolConfigurationImpl config) {
            this.cpConfig = config;
            return this;
        }

        public Builder withHostSupplier(HostSupplier hSupplier) {
            this.hostSupplier = hSupplier;
            return this;
        }

        public Builder withTokenMapSupplier(TokenMapSupplier tokenMapSupplier) {
            this.tokenMapSupplier = tokenMapSupplier;
            return this;
        }

        @Deprecated
        public Builder withDiscoveryClient(DiscoveryClient client) {
            this.discoveryClient = client;
            return this;
        }

        public Builder withDiscoveryClient(EurekaClient client) {
            this.discoveryClient = client;
            return this;
        }

        public Builder withDualWriteClusterName(String dualWriteCluster) {
            this.dualWriteClusterName = dualWriteCluster;
            return this;
        }

        public Builder withDualWriteHostSupplier(HostSupplier dualWriteHostSupplier) {
            this.dualWriteHostSupplier = dualWriteHostSupplier;
            return this;
        }

        public Builder withDualWriteTokenMapSupplier(TokenMapSupplier dualWriteTokenMapSupplier) {
            this.dualWriteTokenMapSupplier = dualWriteTokenMapSupplier;
            return this;
        }

        public Builder withDualWriteDial(DynoDualWriterClient.Dial dial) {
            this.dualWriteDial = dial;
            return this;
        }

        public Builder withConnectionPoolMonitor(ConnectionPoolMonitor cpMonitor) {
            this.cpMonitor = cpMonitor;
            return this;
        }

        public Builder withSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
            return this;
        }

        public Builder isDatastoreClient(boolean isDatastoreClient) {
            this.isDatastoreClient = isDatastoreClient;
            return this;
        }

        public Builder withConnectionPoolConsistency(String consistency) {
            this.connectionPoolConsistency = consistency;
            return this;
        }

        public DynoJedisClient build() {
            assert (this.appName != null);
            assert (this.clusterName != null);
            if (this.isDatastoreClient && this.connectionPoolConsistency != null) {
                throw new DynoException("Cannot set isDatastoreClient(true) and also set withConnectionPoolConsistency() together");
            }
            if (this.cpConfig == null) {
                this.cpConfig = new ArchaiusConnectionPoolConfiguration(this.appName);
                Logger.info("Dyno Client runtime properties: " + this.cpConfig.toString());
            }
            this.cpConfig.setConnectToDatastore(this.isDatastoreClient);
            if (this.connectionPoolConsistency != null) {
                this.cpConfig.setConnectionPoolConsistency(this.connectionPoolConsistency);
            }
            if (this.cpConfig.isDualWriteEnabled()) {
                return this.buildDynoDualWriterClient();
            }
            return this.buildDynoJedisClient();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private DynoDualWriterClient buildDynoDualWriterClient() {
            HostSupplier shadowSupplier;
            ConnectionPoolConfigurationImpl shadowConfig = new ConnectionPoolConfigurationImpl(this.cpConfig);
            Logger.info("Dyno Client Shadow Config runtime properties: " + shadowConfig.toString());
            shadowConfig.setFailOnStartupIfNoHosts(false);
            if (this.dualWriteHostSupplier == null) {
                if (this.hostSupplier != null && this.hostSupplier instanceof EurekaHostsSupplier) {
                    EurekaHostsSupplier eurekaSupplier = (EurekaHostsSupplier)this.hostSupplier;
                    shadowSupplier = EurekaHostsSupplier.newInstance((String)shadowConfig.getDualWriteClusterName(), (EurekaHostsSupplier)eurekaSupplier);
                } else {
                    if (this.discoveryClient == null) throw new DynoConnectException("HostSupplier for DualWrite cluster is REQUIRED if you are not using EurekaHostsSupplier implementation or using a EurekaClient");
                    shadowSupplier = new EurekaHostsSupplier(shadowConfig.getDualWriteClusterName(), this.discoveryClient);
                }
            } else {
                shadowSupplier = this.dualWriteHostSupplier;
            }
            shadowConfig.withHostSupplier(shadowSupplier);
            if (this.dualWriteTokenMapSupplier != null) {
                shadowConfig.withTokenSupplier(this.dualWriteTokenMapSupplier);
            }
            String shadowAppName = shadowConfig.getName();
            DynoCPMonitor shadowCPMonitor = new DynoCPMonitor(shadowAppName);
            DynoOPMonitor shadowOPMonitor = new DynoOPMonitor(shadowAppName);
            DynoJedisUtils.updateConnectionPoolConfig(shadowConfig, shadowSupplier, this.dualWriteTokenMapSupplier, this.discoveryClient, this.clusterName);
            ConnectionPool<Jedis> shadowPool = DynoJedisUtils.createConnectionPool(shadowAppName, shadowOPMonitor, (ConnectionPoolMonitor)shadowCPMonitor, (ConnectionPoolConfiguration)shadowConfig, this.sslSocketFactory);
            DynoJedisClient shadowClient = new DynoJedisClient(shadowAppName, this.dualWriteClusterName, shadowPool, shadowOPMonitor, (ConnectionPoolMonitor)shadowCPMonitor);
            DynoOPMonitor opMonitor = new DynoOPMonitor(this.appName);
            DynoCPMonitor cpMonitor = this.cpMonitor == null ? new DynoCPMonitor(this.appName) : this.cpMonitor;
            DynoJedisUtils.updateConnectionPoolConfig(this.cpConfig, this.dualWriteHostSupplier, this.dualWriteTokenMapSupplier, this.discoveryClient, this.clusterName);
            ConnectionPool<Jedis> pool = DynoJedisUtils.createConnectionPool(this.appName, opMonitor, (ConnectionPoolMonitor)cpMonitor, (ConnectionPoolConfiguration)this.cpConfig, this.sslSocketFactory);
            if (this.dualWriteDial == null) return new DynoDualWriterClient(this.appName, this.clusterName, pool, opMonitor, (ConnectionPoolMonitor)cpMonitor, shadowClient);
            if (shadowConfig.getDualWritePercentage() <= 0) return new DynoDualWriterClient(this.appName, this.clusterName, pool, opMonitor, (ConnectionPoolMonitor)cpMonitor, shadowClient, this.dualWriteDial);
            this.dualWriteDial.setRange(shadowConfig.getDualWritePercentage());
            return new DynoDualWriterClient(this.appName, this.clusterName, pool, opMonitor, (ConnectionPoolMonitor)cpMonitor, shadowClient, this.dualWriteDial);
        }

        private DynoJedisClient buildDynoJedisClient() {
            DynoOPMonitor opMonitor = new DynoOPMonitor(this.appName);
            DynoCPMonitor cpMonitor = this.cpMonitor == null ? new DynoCPMonitor(this.appName) : this.cpMonitor;
            DynoJedisUtils.updateConnectionPoolConfig(this.cpConfig, this.hostSupplier, this.tokenMapSupplier, this.discoveryClient, this.clusterName);
            ConnectionPool<Jedis> pool = DynoJedisUtils.createConnectionPool(this.appName, opMonitor, (ConnectionPoolMonitor)cpMonitor, (ConnectionPoolConfiguration)this.cpConfig, this.sslSocketFactory);
            return new DynoJedisClient(this.appName, this.clusterName, pool, opMonitor, (ConnectionPoolMonitor)cpMonitor);
        }
    }

    private class EHMetadataUpdateResult {
        private final String dataKey;
        private final String metadataKey;
        private final Set<String> expiredFields;
        private final Response<Long> hdelResponse;
        private final Response<Long> zremResponse;

        public EHMetadataUpdateResult(String dataKey, String metadataKey, Set<String> expiredFields, Response<Long> hdelResponse, Response<Long> zremResponse) {
            this.dataKey = dataKey;
            this.metadataKey = metadataKey;
            this.expiredFields = expiredFields;
            this.hdelResponse = hdelResponse;
            this.zremResponse = zremResponse;
        }

        public String getDataKey() {
            return this.dataKey;
        }

        public String getMetadataKey() {
            return this.metadataKey;
        }

        public Set<String> getExpiredFields() {
            return this.expiredFields;
        }

        public Response<Long> getHdelResponse() {
            return this.hdelResponse;
        }

        public Response<Long> getZremResponse() {
            return this.zremResponse;
        }
    }

    private abstract class CompressionValueMultiKeyOperation<T>
    extends MultiKeyOperation<T>
    implements MultiKeyCompressionOperation<Jedis, T> {
        private CompressionValueMultiKeyOperation(List keys, OpName o) {
            super(keys, o);
        }

        public String[] compressMultiKeyValue(ConnectionContext ctx, String ... keyValues) {
            List<String> items = Arrays.asList(keyValues);
            ArrayList<String> newItems = new ArrayList<String>();
            for (int i = 0; i < items.size(); ++i) {
                if (i % 2 == 0) {
                    String value = items.get(i);
                    try {
                        if (2 * value.length() <= DynoJedisClient.this.connPool.getConfiguration().getValueCompressionThreshold()) continue;
                        newItems.add(i, ZipUtils.compressStringToBase64String((String)value));
                        ctx.setMetadata("compression", (Object)true);
                    }
                    catch (IOException e) {
                        Logger.warn("UNABLE to compress [" + value + "] for key [" + this.getStringKey() + "]; sending value uncompressed");
                    }
                    continue;
                }
                newItems.add(items.get(i));
            }
            return (String[])newItems.toArray();
        }

        public String decompressValue(ConnectionContext ctx, String value) {
            try {
                if (ZipUtils.isCompressed((String)value)) {
                    ctx.setMetadata("decompression", (Object)true);
                    return ZipUtils.decompressFromBase64String((String)value);
                }
            }
            catch (IOException e) {
                Logger.warn("Unable to decompress value [" + value + "]");
            }
            return value;
        }
    }

    private abstract class CompressionValueOperation<T>
    extends BaseKeyOperation<T>
    implements CompressionOperation<Jedis, T> {
        private CompressionValueOperation(String k, OpName o) {
            super(k, o);
        }

        public String compressValue(String value, ConnectionContext ctx) {
            String result = value;
            int thresholdBytes = DynoJedisClient.this.connPool.getConfiguration().getValueCompressionThreshold();
            try {
                if (2 * value.length() > thresholdBytes) {
                    result = ZipUtils.compressStringToBase64String((String)value);
                    ctx.setMetadata("compression", (Object)true);
                }
            }
            catch (IOException e) {
                Logger.warn("UNABLE to compress [" + value + "] for key [" + this.getStringKey() + "]; sending value uncompressed");
            }
            return result;
        }

        public String decompressValue(String value, ConnectionContext ctx) {
            try {
                if (ZipUtils.isCompressed((String)value)) {
                    ctx.setMetadata("decompression", (Object)true);
                    return ZipUtils.decompressFromBase64String((String)value);
                }
            }
            catch (IOException e) {
                Logger.warn("Unable to decompress value [" + value + "]");
            }
            return value;
        }
    }
}

