/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.jedis;

import com.netflix.dyno.connectionpool.impl.utils.EstimatedHistogram;
import com.netflix.dyno.contrib.EstimatedHistogramBasedCounter;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.tag.BasicTag;
import com.netflix.servo.tag.Tag;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynoJedisPipelineMonitor {
    private static final Logger Logger = LoggerFactory.getLogger(DynoJedisPipelineMonitor.class);
    private final ConcurrentHashMap<String, BasicCounter> counterMap = new ConcurrentHashMap();
    private final String appName;
    private final BasicCounter pipelineSync;
    private final BasicCounter pipelineDiscard;
    private final PipelineTimer timer;
    private final PipelineSendTimer sendTimer;
    private final int resetTimingsFrequencyInSeconds;
    private final ScheduledExecutorService threadPool = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "DynoJedisPipelineMonitor");
        }
    });

    public DynoJedisPipelineMonitor(String applicationName, int resetTimingsFrequencyInSeconds) {
        this.appName = applicationName;
        this.pipelineSync = this.getNewPipelineCounter("SYNC");
        this.pipelineDiscard = this.getNewPipelineCounter("DISCARD");
        this.timer = new PipelineTimer(this.appName);
        this.sendTimer = new PipelineSendTimer(this.appName);
        this.resetTimingsFrequencyInSeconds = resetTimingsFrequencyInSeconds;
    }

    public DynoJedisPipelineMonitor(String applicationName) {
        this(applicationName, 0);
    }

    public void init() {
        DefaultMonitorRegistry.getInstance().register((Monitor)this.pipelineSync);
        DefaultMonitorRegistry.getInstance().register((Monitor)this.pipelineDiscard);
        DefaultMonitorRegistry.getInstance().register((Monitor)this.timer.latMean);
        DefaultMonitorRegistry.getInstance().register((Monitor)this.timer.lat99);
        DefaultMonitorRegistry.getInstance().register((Monitor)this.timer.lat995);
        DefaultMonitorRegistry.getInstance().register((Monitor)this.timer.lat999);
        Logger.debug(String.format("Initializing DynoJedisPipelineMonitor with timing counter reset frequency %d", this.resetTimingsFrequencyInSeconds));
        if (this.resetTimingsFrequencyInSeconds > 0) {
            this.threadPool.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    DynoJedisPipelineMonitor.this.timer.reset();
                    DynoJedisPipelineMonitor.this.sendTimer.reset();
                }
            }, 1L, this.resetTimingsFrequencyInSeconds, TimeUnit.SECONDS);
        }
    }

    public void recordOperation(String opName) {
        this.getOrCreateCounter(opName).increment();
    }

    public void recordPipelineSync() {
        this.pipelineSync.increment();
    }

    public void recordPipelineDiscard() {
        this.pipelineDiscard.increment();
    }

    public void recordLatency(long duration, TimeUnit unit) {
        this.timer.recordLatency(duration, unit);
    }

    public void recordSendLatency(String opName, long duration, TimeUnit unit) {
        this.sendTimer.recordLatency(opName, duration, unit);
    }

    public void stop() {
        this.threadPool.shutdownNow();
    }

    private BasicCounter getOrCreateCounter(String opName) {
        BasicCounter counter = this.counterMap.get(opName);
        if (counter != null) {
            return counter;
        }
        counter = this.getNewPipelineCounter(opName);
        BasicCounter prevCounter = this.counterMap.putIfAbsent(opName, counter);
        if (prevCounter != null) {
            return prevCounter;
        }
        DefaultMonitorRegistry.getInstance().register((Monitor)counter);
        return counter;
    }

    private BasicCounter getNewPipelineCounter(String opName) {
        String metricName = "Dyno__" + this.appName + "__PL__" + opName;
        MonitorConfig config = MonitorConfig.builder((String)metricName).withTag((Tag)new BasicTag("dyno_pl_op", opName)).build();
        return new BasicCounter(config);
    }

    private class PipelineSendTimer {
        private final Map<String, EstimatedHistogramBasedCounter.EstimatedHistogramMean> histograms = new ConcurrentHashMap<String, EstimatedHistogramBasedCounter.EstimatedHistogramMean>();
        private final String appName;

        private PipelineSendTimer(String appName) {
            this.appName = appName;
        }

        public void recordLatency(String opName, long duration, TimeUnit unit) {
            long durationMicros = TimeUnit.MICROSECONDS.convert(duration, unit);
            this.getOrCreateHistogram(opName).add(durationMicros);
        }

        private EstimatedHistogramBasedCounter.EstimatedHistogramMean getOrCreateHistogram(String opName) {
            if (this.histograms.containsKey(opName)) {
                return this.histograms.get(opName);
            }
            EstimatedHistogram histogram = new EstimatedHistogram();
            EstimatedHistogramBasedCounter.EstimatedHistogramMean histogramMean = new EstimatedHistogramBasedCounter.EstimatedHistogramMean("Dyno__" + this.appName + "__PL__latMean", "PL_SEND", opName, histogram);
            this.histograms.put(opName, histogramMean);
            DefaultMonitorRegistry.getInstance().register((Monitor)histogramMean);
            return histogramMean;
        }

        public void reset() {
            Logger.info("resetting all SEND histograms");
            for (EstimatedHistogramBasedCounter.EstimatedHistogramMean hm : this.histograms.values()) {
                hm.reset();
            }
        }
    }

    private class PipelineTimer {
        private final EstimatedHistogramBasedCounter.EstimatedHistogramMean latMean;
        private final EstimatedHistogramBasedCounter.EstimatedHistogramPercentile lat99;
        private final EstimatedHistogramBasedCounter.EstimatedHistogramPercentile lat995;
        private final EstimatedHistogramBasedCounter.EstimatedHistogramPercentile lat999;
        private final EstimatedHistogram estHistogram = new EstimatedHistogram();

        private PipelineTimer(String appName) {
            this.latMean = new EstimatedHistogramBasedCounter.EstimatedHistogramMean("Dyno__" + appName + "__PL__latMean", "PL", "dyno_pl_op", this.estHistogram);
            this.lat99 = new EstimatedHistogramBasedCounter.EstimatedHistogramPercentile("Dyno__" + appName + "__PL__lat990", "PL", "dyno_pl_op", this.estHistogram, 0.99);
            this.lat995 = new EstimatedHistogramBasedCounter.EstimatedHistogramPercentile("Dyno__" + appName + "__PL__lat995", "PL", "dyno_pl_op", this.estHistogram, 0.995);
            this.lat999 = new EstimatedHistogramBasedCounter.EstimatedHistogramPercentile("Dyno__" + appName + "__PL__lat999", "PL", "dyno_pl_op", this.estHistogram, 0.999);
        }

        public void recordLatency(long duration, TimeUnit unit) {
            long durationMicros = TimeUnit.MICROSECONDS.convert(duration, unit);
            this.estHistogram.add(durationMicros);
        }

        public void reset() {
            Logger.info("resetting histogram");
            this.estHistogram.getBuckets(true);
        }
    }
}

