/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.jedis.operation;

import com.netflix.dyno.connectionpool.Operation;
import com.netflix.dyno.jedis.OpName;
import java.util.List;
import redis.clients.jedis.Jedis;

public abstract class MultiKeyOperation<T>
implements Operation<Jedis, T> {
    private final List<String> keys;
    private final List<byte[]> binaryKeys;
    private final OpName op;

    public MultiKeyOperation(List keys, OpName o) {
        Object firstKey;
        Object v0 = firstKey = keys != null && keys.size() > 0 ? keys.get(0) : null;
        if (firstKey != null) {
            if (firstKey instanceof String) {
                this.keys = keys;
                this.binaryKeys = null;
            } else if (firstKey instanceof byte[]) {
                this.keys = null;
                this.binaryKeys = keys;
            } else {
                this.keys = null;
                this.binaryKeys = null;
            }
        } else {
            this.keys = null;
            this.binaryKeys = null;
        }
        this.op = o;
    }

    public String getName() {
        return this.op.name();
    }

    public String getStringKey() {
        return this.keys != null ? this.keys.get(0) : null;
    }

    public byte[] getBinaryKey() {
        return this.binaryKeys != null ? this.binaryKeys.get(0) : null;
    }
}

