/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.recipes.counter;

import com.netflix.dyno.jedis.DynoJedisClient;
import com.netflix.dyno.recipes.counter.DynoCounter;
import com.netflix.dyno.recipes.counter.DynoJedisCounter;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class DynoJedisBatchCounter
implements DynoCounter {
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final AtomicLong localCounter;
    private final AtomicReference<DynoJedisCounter> counter = new AtomicReference<Object>(null);
    private final Long frequencyInMillis;
    private final ScheduledExecutorService counterThreadPool = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "DynoJedisBatchCounter-Poller");
        }
    });

    public DynoJedisBatchCounter(String key, DynoJedisClient client, Long frequencyInMillis) {
        this.counter.compareAndSet(null, new DynoJedisCounter(key, client));
        this.localCounter = new AtomicLong(0L);
        this.frequencyInMillis = frequencyInMillis;
    }

    @Override
    public void initialize() {
        if (this.initialized.compareAndSet(false, true)) {
            this.counter.get().initialize();
            this.counterThreadPool.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (DynoJedisBatchCounter.this.localCounter.get() > 0L) {
                        ((DynoJedisCounter)DynoJedisBatchCounter.this.counter.get()).incrBy(DynoJedisBatchCounter.this.localCounter.getAndSet(0L));
                    }
                }
            }, 1000L, this.frequencyInMillis, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void incr() {
        if (!this.initialized.get()) {
            throw new IllegalStateException("Counter has not been initialized");
        }
        this.localCounter.incrementAndGet();
    }

    @Override
    public void incrBy(long value) {
        if (!this.initialized.get()) {
            throw new IllegalStateException("Counter has not been initialized");
        }
        this.localCounter.addAndGet(value);
    }

    @Override
    public Long get() {
        return this.counter.get().get();
    }

    @Override
    public String getKey() {
        return this.counter.get().getKey();
    }

    @Override
    public List<String> getGeneratedKeys() {
        return this.counter.get().getGeneratedKeys();
    }

    @Override
    public void close() throws Exception {
        try {
            this.counterThreadPool.shutdownNow();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

