/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.recipes.counter;

import com.netflix.dyno.connectionpool.TokenPoolTopology;
import com.netflix.dyno.connectionpool.TopologyView;
import com.netflix.dyno.jedis.DynoJedisClient;
import com.netflix.dyno.recipes.counter.DynoCounter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DynoJedisCounter
implements DynoCounter {
    private static final Logger logger = LoggerFactory.getLogger(DynoJedisCounter.class);
    private static final int MAX_ITERATIONS = 1000;
    protected final String key;
    protected final DynoJedisClient client;
    protected final List<String> generatedKeys;

    public DynoJedisCounter(String key, DynoJedisClient client) {
        this.key = key;
        this.client = client;
        this.generatedKeys = this.generateKeys();
    }

    @Override
    public void initialize() {
    }

    @Override
    public void incr() {
        this.client.incr(this.generatedKeys.get(this.randomIntFrom0toN()));
    }

    @Override
    public void incrBy(long value) {
        this.client.incrBy(this.generatedKeys.get(this.randomIntFrom0toN()), value);
    }

    @Override
    public Long get() {
        Long result = 0L;
        ArrayList<String> values = new ArrayList<String>(this.generatedKeys.size());
        for (String key : this.generatedKeys) {
            String val = this.client.get(key);
            if (val == null) continue;
            result = result + Long.valueOf(val);
            values.add(val);
        }
        logger.debug("result=>" + result + ", key: " + this.key + ", values: " + values.toString());
        return result;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public List<String> getGeneratedKeys() {
        return Collections.unmodifiableList(this.generatedKeys);
    }

    List<String> generateKeys() {
        TopologyView view = this.client.getTopologyView();
        Map topology = view.getTopologySnapshot();
        if (topology.keySet().isEmpty()) {
            throw new RuntimeException("Unable to determine dynomite topology");
        }
        ArrayList racks = new ArrayList(topology.keySet());
        HashSet<Long> tokens = new HashSet<Long>();
        for (TokenPoolTopology.TokenStatus status : (List)topology.get(racks.get(0))) {
            tokens.add(status.getToken());
        }
        ArrayList<String> generatedKeys = new ArrayList<String>(tokens.size());
        int i = 0;
        while (tokens.size() > 0 && i++ < 1000) {
            Long token = view.getTokenForKey(this.key + "_" + i);
            if (!tokens.contains(token) || !tokens.remove(token)) continue;
            String generated = this.key + "_" + i;
            logger.debug(String.format("Found key=>%s for token=>%s", generated, token));
            generatedKeys.add(generated);
        }
        return generatedKeys;
    }

    int randomIntFrom0toN() {
        long x = System.nanoTime();
        x ^= x << 21;
        x ^= x >>> 35;
        x ^= x << 4;
        return Math.abs((int)x % this.generatedKeys.size());
    }

    @Override
    public void close() throws Exception {
    }
}

