/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.recipes.json;

import com.google.gson.Gson;
import com.netflix.dyno.connectionpool.ConnectionContext;
import com.netflix.dyno.connectionpool.OperationResult;
import com.netflix.dyno.connectionpool.exception.DynoException;
import com.netflix.dyno.jedis.DynoJedisClient;
import com.netflix.dyno.jedis.JedisGenericOperation;
import com.netflix.dyno.recipes.json.ExistenceModifier;
import com.netflix.dyno.recipes.json.JsonCommand;
import com.netflix.dyno.recipes.json.JsonPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class DynoJedisJsonClient {
    private static final Logger LOG = LoggerFactory.getLogger(DynoJedisJsonClient.class);
    private static final Gson gson = new Gson();
    private final DynoJedisClient client;

    public DynoJedisJsonClient(DynoJedisClient client) {
        this.client = client;
    }

    public OperationResult<String> set(String key, Object object) {
        return this.set(key, JsonPath.ROOT_PATH, object, ExistenceModifier.DEFAULT);
    }

    public OperationResult<String> set(String key, ExistenceModifier flag, Object object) {
        return this.set(key, JsonPath.ROOT_PATH, object, flag);
    }

    public OperationResult<String> set(String key, JsonPath path, Object object) {
        return this.set(key, path, object, ExistenceModifier.DEFAULT);
    }

    public OperationResult<String> set(final String key, final JsonPath path, final Object object, final ExistenceModifier flag) {
        return this.client.moduleCommand((JedisGenericOperation)new JedisGenericOperation<String>(key, JsonCommand.GET.toString()){

            public String execute(Jedis client, ConnectionContext state) throws DynoException {
                ArrayList<byte[]> args = new ArrayList<byte[]>();
                args.add(SafeEncoder.encode((String)key));
                args.add(SafeEncoder.encode((String)path.toString()));
                args.add(SafeEncoder.encode((String)gson.toJson(object)));
                if (flag != ExistenceModifier.DEFAULT) {
                    args.add(flag.getRaw());
                }
                client.getClient().sendCommand((ProtocolCommand)JsonCommand.SET, (byte[][])args.toArray((T[])new byte[args.size()][]));
                return client.getClient().getStatusCodeReply();
            }
        });
    }

    public OperationResult<Object> get(String key) {
        return this.get(key, JsonPath.ROOT_PATH);
    }

    public OperationResult<Object> get(final String key, final JsonPath ... paths) {
        return this.client.moduleCommand((JedisGenericOperation)new JedisGenericOperation<Object>(key, JsonCommand.GET.toString()){

            public Object execute(Jedis client, ConnectionContext state) throws DynoException {
                ArrayList<byte[]> args = new ArrayList<byte[]>();
                args.add(SafeEncoder.encode((String)key));
                Arrays.stream(paths).forEach(x -> args.add(SafeEncoder.encode((String)x.toString())));
                client.getClient().sendCommand((ProtocolCommand)JsonCommand.GET, (byte[][])args.toArray((T[])new byte[args.size()][]));
                return gson.fromJson(client.getClient().getBulkReply(), Object.class);
            }
        });
    }

    public OperationResult<Long> del(String key) {
        return this.del(key, JsonPath.ROOT_PATH);
    }

    public OperationResult<Long> del(final String key, final JsonPath path) {
        return this.client.moduleCommand((JedisGenericOperation)new JedisGenericOperation<Long>(key, JsonCommand.DEL.toString()){

            public Long execute(Jedis client, ConnectionContext state) throws DynoException {
                ArrayList<byte[]> args = new ArrayList<byte[]>();
                args.add(SafeEncoder.encode((String)key));
                args.add(SafeEncoder.encode((String)path.toString()));
                client.getClient().sendCommand((ProtocolCommand)JsonCommand.DEL, (byte[][])args.toArray((T[])new byte[args.size()][]));
                return client.getClient().getIntegerReply();
            }
        });
    }

    public OperationResult<Class<?>> type(String key) {
        return this.type(key, JsonPath.ROOT_PATH);
    }

    public OperationResult<Class<?>> type(final String key, final JsonPath path) {
        return this.client.moduleCommand(new JedisGenericOperation<Class<?>>(key, JsonCommand.DEL.toString()){

            public Class<?> execute(Jedis client, ConnectionContext state) throws DynoException {
                String reply;
                ArrayList<byte[]> args = new ArrayList<byte[]>();
                args.add(SafeEncoder.encode((String)key));
                args.add(SafeEncoder.encode((String)path.toString()));
                client.getClient().sendCommand((ProtocolCommand)JsonCommand.TYPE, (byte[][])args.toArray((T[])new byte[args.size()][]));
                switch (reply = client.getClient().getBulkReply()) {
                    case "null": {
                        return null;
                    }
                    case "boolean": {
                        return Boolean.TYPE;
                    }
                    case "integer": {
                        return Integer.TYPE;
                    }
                    case "number": {
                        return Float.TYPE;
                    }
                    case "string": {
                        return String.class;
                    }
                    case "object": {
                        return Object.class;
                    }
                    case "array": {
                        return List.class;
                    }
                }
                throw new RuntimeException(reply);
            }
        });
    }

    public OperationResult<List<Object>> mget(final List<String> keys, final JsonPath path) {
        return this.client.moduleCommand((JedisGenericOperation)new JedisGenericOperation<List<Object>>("", JsonCommand.MGET.toString()){

            public List<Object> execute(Jedis client, ConnectionContext state) throws DynoException {
                ArrayList<byte[]> args = new ArrayList<byte[]>();
                keys.forEach(key -> args.add(SafeEncoder.encode((String)key)));
                args.add(SafeEncoder.encode((String)path.toString()));
                client.getClient().sendCommand((ProtocolCommand)JsonCommand.MGET, (byte[][])args.toArray((T[])new byte[args.size()][]));
                List reply = client.getClient().getMultiBulkReply();
                ArrayList<Object> response = new ArrayList<Object>(reply.size());
                reply.forEach(r -> response.add(gson.fromJson(r, Object.class)));
                return response;
            }
        });
    }

    public OperationResult<Long> arrappend(final String key, final JsonPath path, final Object ... items) {
        return this.client.moduleCommand((JedisGenericOperation)new JedisGenericOperation<Long>(key, JsonCommand.ARRAPPEND.toString()){

            public Long execute(Jedis client, ConnectionContext state) throws DynoException {
                ArrayList<byte[]> args = new ArrayList<byte[]>();
                args.add(SafeEncoder.encode((String)key));
                args.add(SafeEncoder.encode((String)path.toString()));
                Arrays.asList(items).forEach(i -> args.add(SafeEncoder.encode((String)gson.toJson(i))));
                client.getClient().sendCommand((ProtocolCommand)JsonCommand.ARRAPPEND, (byte[][])args.toArray((T[])new byte[args.size()][]));
                return client.getClient().getIntegerReply();
            }
        });
    }

    public OperationResult<Long> arrinsert(final String key, final JsonPath path, final int index, final Object ... items) {
        return this.client.moduleCommand((JedisGenericOperation)new JedisGenericOperation<Long>(key, JsonCommand.ARRINSERT.toString()){

            public Long execute(Jedis client, ConnectionContext state) throws DynoException {
                ArrayList<byte[]> args = new ArrayList<byte[]>();
                args.add(SafeEncoder.encode((String)key));
                args.add(SafeEncoder.encode((String)path.toString()));
                args.add(SafeEncoder.encode((String)Integer.toString(index)));
                Arrays.asList(items).forEach(i -> args.add(SafeEncoder.encode((String)gson.toJson(i))));
                client.getClient().sendCommand((ProtocolCommand)JsonCommand.ARRINSERT, (byte[][])args.toArray((T[])new byte[args.size()][]));
                return client.getClient().getIntegerReply();
            }
        });
    }

    public OperationResult<Long> arrlen(final String key, final JsonPath path) {
        return this.client.moduleCommand((JedisGenericOperation)new JedisGenericOperation<Long>(key, JsonCommand.ARRLEN.toString()){

            public Long execute(Jedis client, ConnectionContext state) throws DynoException {
                ArrayList<byte[]> args = new ArrayList<byte[]>();
                args.add(SafeEncoder.encode((String)key));
                args.add(SafeEncoder.encode((String)path.toString()));
                client.getClient().sendCommand((ProtocolCommand)JsonCommand.ARRLEN, (byte[][])args.toArray((T[])new byte[args.size()][]));
                return client.getClient().getIntegerReply();
            }
        });
    }

    public OperationResult<List<String>> objkeys(String key) {
        return this.objkeys(key, JsonPath.ROOT_PATH);
    }

    public OperationResult<List<String>> objkeys(final String key, final JsonPath path) {
        return this.client.moduleCommand((JedisGenericOperation)new JedisGenericOperation<List<String>>(key, JsonCommand.OBJKEYS.toString()){

            public List<String> execute(Jedis client, ConnectionContext state) throws DynoException {
                ArrayList<byte[]> args = new ArrayList<byte[]>();
                args.add(SafeEncoder.encode((String)key));
                args.add(SafeEncoder.encode((String)path.toString()));
                client.getClient().sendCommand((ProtocolCommand)JsonCommand.OBJKEYS, (byte[][])args.toArray((T[])new byte[args.size()][]));
                return client.getClient().getMultiBulkReply();
            }
        });
    }

    public OperationResult<Long> objlen(String key) {
        return this.objlen(key, JsonPath.ROOT_PATH);
    }

    public OperationResult<Long> objlen(final String key, final JsonPath path) {
        return this.client.moduleCommand((JedisGenericOperation)new JedisGenericOperation<Long>(key, JsonCommand.OBJLEN.toString()){

            public Long execute(Jedis client, ConnectionContext state) throws DynoException {
                ArrayList<byte[]> args = new ArrayList<byte[]>();
                args.add(SafeEncoder.encode((String)key));
                args.add(SafeEncoder.encode((String)path.toString()));
                client.getClient().sendCommand((ProtocolCommand)JsonCommand.OBJLEN, (byte[][])args.toArray((T[])new byte[args.size()][]));
                return client.getClient().getIntegerReply();
            }
        });
    }
}

