/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.recipes.lock;

import com.google.common.collect.ImmutableSet;
import com.netflix.dyno.connectionpool.Host;
import com.netflix.dyno.connectionpool.HostSupplier;
import com.netflix.dyno.connectionpool.TokenMapSupplier;
import com.netflix.dyno.connectionpool.impl.lb.CircularList;
import com.netflix.dyno.connectionpool.impl.lb.HostToken;
import com.netflix.dyno.recipes.lock.VotingHostsSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;

public class VotingHostsFromTokenRange
implements VotingHostsSelector {
    private final TokenMapSupplier tokenMapSupplier;
    private final HostSupplier hostSupplier;
    private final CircularList<Host> votingHosts = new CircularList(new ArrayList());
    private final int MIN_VOTING_SIZE = 1;
    private final int MAX_VOTING_SIZE = 5;
    private final int effectiveVotingSize;
    private final AtomicInteger calculatedVotingSize = new AtomicInteger(0);

    public VotingHostsFromTokenRange(HostSupplier hostSupplier, TokenMapSupplier tokenMapSupplier, int votingSize) {
        this.tokenMapSupplier = tokenMapSupplier;
        this.hostSupplier = hostSupplier;
        int n = this.effectiveVotingSize = votingSize == -1 ? 5 : votingSize;
        if (votingSize % 2 == 0) {
            throw new IllegalStateException("Cannot perform voting with even number of hosts");
        }
        this.getVotingHosts();
    }

    @Override
    public CircularList<Host> getVotingHosts() {
        if (this.votingHosts.getSize() == 0) {
            if (this.effectiveVotingSize % 2 == 0) {
                throw new IllegalStateException("Cannot do voting with even number of nodes for voting");
            }
            List allHostTokens = this.tokenMapSupplier.getTokens((Set)ImmutableSet.copyOf((Collection)this.hostSupplier.getHosts()));
            if (allHostTokens.size() < 1) {
                throw new IllegalStateException(String.format("Cannot perform voting with less than %d nodes", 1));
            }
            Map numHostsPerRack = allHostTokens.stream().map(ht -> ht.getHost().getRack()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            AtomicInteger numHostsRequired = new AtomicInteger(this.effectiveVotingSize);
            HashMap<String, Integer> numHosts = new HashMap<String, Integer>();
            List racks = numHostsPerRack.keySet().stream().sorted(Comparator.comparing(String::toString)).collect(Collectors.toList());
            for (String rack : racks) {
                int v = (int)Math.min((long)numHostsRequired.get(), numHostsPerRack.get(rack));
                numHostsRequired.addAndGet(-v);
                numHosts.put(rack, v);
                this.calculatedVotingSize.addAndGet(v);
            }
            if (this.calculatedVotingSize.get() % 2 == 0) {
                throw new IllegalStateException("Could not construct voting pool. Min number of hosts not met!");
            }
            Map<String, List<HostToken>> rackToHostToken = allHostTokens.stream().collect(Collectors.groupingBy(ht -> ht.getHost().getRack()));
            List finalVotingHosts = rackToHostToken.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).flatMap(e -> {
                List temp = (List)e.getValue();
                temp.sort(HostToken::compareTo);
                return temp.subList(0, (Integer)numHosts.get(e.getKey())).stream();
            }).map(ht -> ht.getHost()).collect(Collectors.toList());
            this.votingHosts.swapWithList(finalVotingHosts);
        }
        return this.votingHosts;
    }

    @Override
    public int getVotingSize() {
        return this.calculatedVotingSize.get();
    }
}

