/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.recipes.lock.command;

import com.netflix.dyno.connectionpool.Connection;
import com.netflix.dyno.connectionpool.ConnectionContext;
import com.netflix.dyno.connectionpool.ConnectionPool;
import com.netflix.dyno.connectionpool.Host;
import com.netflix.dyno.connectionpool.Operation;
import com.netflix.dyno.connectionpool.OperationResult;
import com.netflix.dyno.jedis.OpName;
import com.netflix.dyno.jedis.operation.BaseKeyOperation;
import com.netflix.dyno.recipes.lock.command.CommandHost;
import redis.clients.jedis.Jedis;

public class CheckAndRunHost
extends CommandHost<Object> {
    private static final String cmdScript = " if redis.call(\"get\",KEYS[1]) == ARGV[1] then\n        return redis.call(\"%s\",KEYS[1])\n    else\n        return 0\n    end";
    private final String resource;
    private final String randomKey;
    private final String command;

    public CheckAndRunHost(Host host, ConnectionPool pool, String command, String resource, String randomKey) {
        super(host, pool);
        this.command = String.format(cmdScript, command);
        this.resource = resource;
        this.randomKey = randomKey;
    }

    @Override
    public OperationResult<Object> get() {
        Connection connection = this.getConnection();
        OperationResult result = connection.execute((Operation)new BaseKeyOperation<Object>(this.randomKey, OpName.EVAL){

            public Object execute(Jedis client, ConnectionContext state) {
                if (CheckAndRunHost.this.randomKey == null) {
                    throw new IllegalStateException("Cannot extend lock with null value for key");
                }
                Object result = client.eval(CheckAndRunHost.this.command, 1, new String[]{CheckAndRunHost.this.resource, CheckAndRunHost.this.randomKey});
                return result;
            }
        });
        this.cleanConnection(connection);
        return result;
    }
}

