/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.recipes.lock.command;

import com.netflix.dyno.connectionpool.Connection;
import com.netflix.dyno.connectionpool.ConnectionContext;
import com.netflix.dyno.connectionpool.ConnectionPool;
import com.netflix.dyno.connectionpool.Host;
import com.netflix.dyno.connectionpool.Operation;
import com.netflix.dyno.connectionpool.OperationResult;
import com.netflix.dyno.jedis.OpName;
import com.netflix.dyno.jedis.operation.BaseKeyOperation;
import com.netflix.dyno.recipes.lock.LockResource;
import com.netflix.dyno.recipes.lock.command.CommandHost;
import java.util.concurrent.CountDownLatch;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.params.SetParams;

public class LockHost
extends CommandHost<LockResource> {
    private final String value;
    private final LockResource lockResource;
    private final SetParams params;
    private final String randomKey;
    private final CountDownLatch latch;

    public LockHost(Host host, ConnectionPool pool, LockResource lockResource, CountDownLatch latch, String randomKey) {
        super(host, pool);
        this.lockResource = lockResource;
        this.value = lockResource.getResource();
        this.params = SetParams.setParams().nx().px(lockResource.getTtlMs());
        this.randomKey = randomKey;
        this.latch = latch;
    }

    @Override
    public OperationResult<LockResource> get() {
        Connection connection = this.getConnection();
        OperationResult result = connection.execute((Operation)new BaseKeyOperation<LockResource>(this.value, OpName.SET){

            public LockResource execute(Jedis client, ConnectionContext state) {
                String result = client.set(LockHost.this.value, LockHost.this.randomKey, LockHost.this.params);
                if (result != null && result.equals("OK")) {
                    LockHost.this.lockResource.incrementLocked();
                    LockHost.this.latch.countDown();
                }
                return LockHost.this.lockResource;
            }
        });
        this.cleanConnection(connection);
        return result;
    }
}

