/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.transport.jersey2;

import com.netflix.appinfo.AbstractEurekaIdentity;
import com.netflix.appinfo.EurekaClientIdentity;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.TransportClientFactory;
import com.netflix.discovery.shared.transport.decorator.MetricsCollectingEurekaHttpClient;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClient;
import com.netflix.discovery.shared.transport.jersey.TransportClientFactories;
import com.netflix.discovery.shared.transport.jersey2.Jersey2ApplicationClientFactory;
import java.util.Collection;
import javax.ws.rs.client.ClientRequestFilter;

public class Jersey2TransportClientFactories
implements TransportClientFactories<ClientRequestFilter> {
    private static final Jersey2TransportClientFactories INSTANCE = new Jersey2TransportClientFactories();

    public static Jersey2TransportClientFactories getInstance() {
        return INSTANCE;
    }

    public TransportClientFactory newTransportClientFactory(EurekaClientConfig clientConfig, Collection<ClientRequestFilter> additionalFilters, InstanceInfo myInstanceInfo) {
        final Jersey2ApplicationClientFactory jerseyFactory = Jersey2ApplicationClientFactory.create(clientConfig, additionalFilters, myInstanceInfo, (AbstractEurekaIdentity)new EurekaClientIdentity(myInstanceInfo.getIPAddr(), "Jersey2DefaultClient"));
        final TransportClientFactory metricsFactory = MetricsCollectingEurekaHttpClient.createFactory((TransportClientFactory)jerseyFactory);
        return new TransportClientFactory(){

            public EurekaHttpClient newClient(EurekaEndpoint serviceUrl) {
                return metricsFactory.newClient(serviceUrl);
            }

            public void shutdown() {
                metricsFactory.shutdown();
                jerseyFactory.shutdown();
            }
        };
    }

    public TransportClientFactory newTransportClientFactory(Collection<ClientRequestFilter> additionalFilters, EurekaJerseyClient providedJerseyClient) {
        throw new UnsupportedOperationException();
    }
}

