/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery;

import com.netflix.discovery.util.SpectatorUtil;
import com.netflix.spectator.api.Counter;
import java.util.TimerTask;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedSupervisorTask
extends TimerTask {
    private static final Logger logger = LoggerFactory.getLogger(TimedSupervisorTask.class);
    private final Counter successCounter;
    private final Counter timeoutCounter;
    private final Counter rejectedCounter;
    private final Counter throwableCounter;
    private final AtomicLong threadPoolLevelGauge;
    private final String name;
    private final ScheduledExecutorService scheduler;
    private final ThreadPoolExecutor executor;
    private final long timeoutMillis;
    private final Runnable task;
    private final AtomicLong delay;
    private final long maxDelay;

    public TimedSupervisorTask(String name, ScheduledExecutorService scheduler, ThreadPoolExecutor executor, int timeout, TimeUnit timeUnit, int expBackOffBound, Runnable task) {
        this.name = name;
        this.scheduler = scheduler;
        this.executor = executor;
        this.timeoutMillis = timeUnit.toMillis(timeout);
        this.task = task;
        this.delay = new AtomicLong(this.timeoutMillis);
        this.maxDelay = this.timeoutMillis * (long)expBackOffBound;
        this.successCounter = SpectatorUtil.counter("success", name, TimedSupervisorTask.class);
        this.timeoutCounter = SpectatorUtil.counter("timeouts", name, TimedSupervisorTask.class);
        this.rejectedCounter = SpectatorUtil.counter("rejectedExecutions", name, TimedSupervisorTask.class);
        this.throwableCounter = SpectatorUtil.counter("throwables", name, TimedSupervisorTask.class);
        this.threadPoolLevelGauge = SpectatorUtil.monitoredLong("threadPoolUsed", name, TimedSupervisorTask.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Future<?> future = null;
        try {
            future = this.executor.submit(this.task);
            this.threadPoolLevelGauge.set(this.executor.getActiveCount());
            future.get(this.timeoutMillis, TimeUnit.MILLISECONDS);
            this.delay.set(this.timeoutMillis);
            this.threadPoolLevelGauge.set(this.executor.getActiveCount());
            this.successCounter.increment();
        }
        catch (TimeoutException e) {
            logger.warn("task supervisor timed out", (Throwable)e);
            this.timeoutCounter.increment();
            long currentDelay = this.delay.get();
            long newDelay = Math.min(this.maxDelay, currentDelay * 2L);
            this.delay.compareAndSet(currentDelay, newDelay);
        }
        catch (RejectedExecutionException e) {
            if (this.executor.isShutdown() || this.scheduler.isShutdown()) {
                logger.warn("task supervisor shutting down, reject the task", (Throwable)e);
            } else {
                logger.warn("task supervisor rejected the task", (Throwable)e);
            }
            this.rejectedCounter.increment();
        }
        catch (Throwable e) {
            if (this.executor.isShutdown() || this.scheduler.isShutdown()) {
                logger.warn("task supervisor shutting down, can't accept the task");
            } else {
                logger.warn("task supervisor threw an exception", e);
            }
            this.throwableCounter.increment();
        }
        finally {
            if (future != null) {
                future.cancel(true);
            }
            if (!this.scheduler.isShutdown()) {
                this.scheduler.schedule(this, this.delay.get(), TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public boolean cancel() {
        return super.cancel();
    }
}

