/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery;

import com.netflix.discovery.AzToRegionMapper;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.InstanceRegionChecker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAzToRegionMapper
implements AzToRegionMapper {
    private static final Logger logger = LoggerFactory.getLogger(InstanceRegionChecker.class);
    private static final String[] EMPTY_STR_ARRAY = new String[0];
    protected final EurekaClientConfig clientConfig;
    private final ConcurrentHashMap<String, List<String>> defaultRegionVsAzMap = new ConcurrentHashMap();
    private final Map<String, String> availabilityZoneVsRegion = new ConcurrentHashMap<String, String>();
    private String[] regionsToFetch;

    protected AbstractAzToRegionMapper(EurekaClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.populateDefaultAZToRegionMap();
    }

    @Override
    public synchronized void setRegionsToFetch(String[] regionsToFetch) {
        if (null != regionsToFetch) {
            this.regionsToFetch = regionsToFetch;
            logger.info("Fetching availability zone to region mapping for regions {}", (Object)regionsToFetch);
            this.availabilityZoneVsRegion.clear();
            for (String remoteRegion : regionsToFetch) {
                Set<String> availabilityZones = this.getZonesForARegion(remoteRegion);
                if (null == availabilityZones || availabilityZones.size() == 1 && availabilityZones.contains("defaultZone") || availabilityZones.isEmpty()) {
                    logger.info("No availability zone information available for remote region: {}. Now checking in the default mapping.", (Object)remoteRegion);
                    if (this.defaultRegionVsAzMap.containsKey(remoteRegion)) {
                        Collection defaultAvailabilityZones = this.defaultRegionVsAzMap.get(remoteRegion);
                        for (String defaultAvailabilityZone : defaultAvailabilityZones) {
                            this.availabilityZoneVsRegion.put(defaultAvailabilityZone, remoteRegion);
                        }
                        continue;
                    }
                    String msg = "No availability zone information available for remote region: " + remoteRegion + ". This is required if registry information for this region is configured to be fetched.";
                    logger.error(msg);
                    throw new RuntimeException(msg);
                }
                for (String availabilityZone : availabilityZones) {
                    this.availabilityZoneVsRegion.put(availabilityZone, remoteRegion);
                }
            }
            logger.info("Availability zone to region mapping for all remote regions: {}", this.availabilityZoneVsRegion);
        } else {
            logger.info("Regions to fetch is null. Erasing older mapping if any.");
            this.availabilityZoneVsRegion.clear();
            this.regionsToFetch = EMPTY_STR_ARRAY;
        }
    }

    protected abstract Set<String> getZonesForARegion(String var1);

    @Override
    public String getRegionForAvailabilityZone(String availabilityZone) {
        String region = this.availabilityZoneVsRegion.get(availabilityZone);
        if (null == region) {
            return this.parseAzToGetRegion(availabilityZone);
        }
        return region;
    }

    @Override
    public synchronized void refreshMapping() {
        logger.info("Refreshing availability zone to region mappings.");
        this.setRegionsToFetch(this.regionsToFetch);
    }

    protected String parseAzToGetRegion(String availabilityZone) {
        String possibleRegion;
        if (!availabilityZone.isEmpty() && this.availabilityZoneVsRegion.containsValue(possibleRegion = availabilityZone.substring(0, availabilityZone.length() - 1))) {
            return possibleRegion;
        }
        return null;
    }

    private void populateDefaultAZToRegionMap() {
        ArrayList<String> east = new ArrayList<String>();
        east.add("us-east-1a");
        east.add("us-east-1c");
        east.add("us-east-1d");
        east.add("us-east-1e");
        this.defaultRegionVsAzMap.put("us-east-1", east);
        ArrayList<String> west1 = new ArrayList<String>();
        west1.add("us-west-1a");
        west1.add("us-west-1c");
        this.defaultRegionVsAzMap.put("us-west-1", west1);
        ArrayList<String> west2 = new ArrayList<String>();
        this.defaultRegionVsAzMap.put("us-west-2", west2);
        west2.add("us-west-2a");
        west2.add("us-west-2b");
        west2.add("us-west-2c");
        ArrayList<String> euwest1 = new ArrayList<String>();
        euwest1.add("eu-west-1a");
        euwest1.add("eu-west-1b");
        euwest1.add("eu-west-1c");
        this.defaultRegionVsAzMap.put("eu-west-1", euwest1);
    }
}

