/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.resolver;

import com.netflix.discovery.TimedSupervisorTask;
import com.netflix.discovery.shared.resolver.ClosableResolver;
import com.netflix.discovery.shared.resolver.ClusterResolver;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.util.SpectatorUtil;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncResolver<T extends EurekaEndpoint>
implements ClosableResolver<T> {
    private static final Logger logger = LoggerFactory.getLogger(AsyncResolver.class);
    private final AtomicBoolean warmedUp = new AtomicBoolean(false);
    private final AtomicBoolean scheduled = new AtomicBoolean(false);
    private final String name;
    private final ClusterResolver<T> delegate;
    private final ScheduledExecutorService executorService;
    private final ThreadPoolExecutor threadPoolExecutor;
    private final TimedSupervisorTask backgroundTask;
    private final AtomicReference<List<T>> resultsRef;
    private final int refreshIntervalMs;
    private final int warmUpTimeoutMs;
    private volatile long lastLoadTimestamp = -1L;
    private final Runnable updateTask = new Runnable(){

        @Override
        public void run() {
            try {
                List newList = AsyncResolver.this.delegate.getClusterEndpoints();
                if (newList != null) {
                    AsyncResolver.this.resultsRef.getAndSet(newList);
                    AsyncResolver.this.lastLoadTimestamp = System.currentTimeMillis();
                } else {
                    logger.warn("Delegate returned null list of cluster endpoints");
                }
                logger.debug("Resolved to {}", newList);
            }
            catch (Exception e) {
                logger.warn("Failed to retrieve cluster endpoints from the delegate", (Throwable)e);
            }
        }
    };

    public AsyncResolver(String name, ClusterResolver<T> delegate, int executorThreadPoolSize, int refreshIntervalMs, int warmUpTimeoutMs) {
        this(name, delegate, Collections.emptyList(), executorThreadPoolSize, refreshIntervalMs, warmUpTimeoutMs);
    }

    public AsyncResolver(String name, ClusterResolver<T> delegate, List<T> initialValues, int executorThreadPoolSize, int refreshIntervalMs) {
        this(name, delegate, initialValues, executorThreadPoolSize, refreshIntervalMs, 0);
        this.warmedUp.set(true);
    }

    AsyncResolver(final String name, ClusterResolver<T> delegate, List<T> initialValue, int executorThreadPoolSize, int refreshIntervalMs, int warmUpTimeoutMs) {
        this.name = name;
        this.delegate = delegate;
        this.refreshIntervalMs = refreshIntervalMs;
        this.warmUpTimeoutMs = warmUpTimeoutMs;
        SpectatorUtil.monitoredValue("eurekaClient.resolver.lastLoadTimestamp", this, AsyncResolver::getLastLoadTimestamp);
        this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "AsyncResolver-" + name + "-%d");
                thread.setDaemon(true);
                return thread;
            }
        });
        this.threadPoolExecutor = new ThreadPoolExecutor(1, executorThreadPoolSize, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "AsyncResolver-" + name + "-executor-%d");
                thread.setDaemon(true);
                return thread;
            }
        });
        this.backgroundTask = new TimedSupervisorTask(this.getClass().getSimpleName(), this.executorService, this.threadPoolExecutor, refreshIntervalMs, TimeUnit.MILLISECONDS, 5, this.updateTask);
        this.resultsRef = new AtomicReference<List<T>>(initialValue);
        SpectatorUtil.monitoredValue("eurekaClient.resolver.endpointsSize", this, AsyncResolver::getEndpointsSize);
    }

    @Override
    public void shutdown() {
        this.executorService.shutdownNow();
        this.threadPoolExecutor.shutdownNow();
        this.backgroundTask.cancel();
    }

    @Override
    public String getRegion() {
        return this.delegate.getRegion();
    }

    @Override
    public List<T> getClusterEndpoints() {
        long delay = this.refreshIntervalMs;
        if (this.warmedUp.compareAndSet(false, true) && !this.doWarmUp()) {
            delay = 0L;
        }
        if (this.scheduled.compareAndSet(false, true)) {
            this.scheduleTask(delay);
        }
        return this.resultsRef.get();
    }

    boolean doWarmUp() {
        Future<?> future = null;
        try {
            future = this.threadPoolExecutor.submit(this.updateTask);
            future.get(this.warmUpTimeoutMs, TimeUnit.MILLISECONDS);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.warn("Best effort warm up failed", (Throwable)e);
        }
        finally {
            if (future != null) {
                future.cancel(true);
            }
        }
        return false;
    }

    void scheduleTask(long delay) {
        this.executorService.schedule(this.backgroundTask, delay, TimeUnit.MILLISECONDS);
    }

    public long getLastLoadTimestamp() {
        return this.lastLoadTimestamp < 0L ? 0L : System.currentTimeMillis() - this.lastLoadTimestamp;
    }

    public long getEndpointsSize() {
        return this.resultsRef.get().size();
    }
}

