/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.MyDataCenterInstanceConfig;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.discovery.guice.EurekaModule;
import com.netflix.eureka.ExampleServiceBase;
import com.netflix.governator.Governator;
import com.netflix.governator.LifecycleInjector;

public class ExampleEurekaGovernatedService {
    private static LifecycleInjector init() throws Exception {
        System.out.println("Creating injector for Example Service");
        LifecycleInjector injector = Governator.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{new EurekaModule()}).with(new Module[]{new AbstractModule(){

            protected void configure() {
                DynamicPropertyFactory configInstance = DynamicPropertyFactory.getInstance();
                this.bind(DynamicPropertyFactory.class).toInstance((Object)configInstance);
                this.bind(EurekaInstanceConfig.class).to(MyDataCenterInstanceConfig.class);
            }
        }}), new ExampleServiceModule()});
        System.out.println("Done creating the injector");
        return injector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        LifecycleInjector injector = null;
        try {
            injector = ExampleEurekaGovernatedService.init();
            injector.awaitTermination();
        }
        catch (Exception e) {
            System.out.println("Error starting the sample service: " + e);
            e.printStackTrace();
        }
        finally {
            if (injector != null) {
                injector.shutdown();
            }
        }
    }

    static class ExampleServiceModule
    extends AbstractModule {
        ExampleServiceModule() {
        }

        protected void configure() {
            this.bind(ExampleServiceBase.class).asEagerSingleton();
        }
    }
}

