/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.discovery.EurekaClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ExampleServiceBase {
    private final ApplicationInfoManager applicationInfoManager;
    private final EurekaClient eurekaClient;
    private final DynamicPropertyFactory configInstance;

    @Inject
    public ExampleServiceBase(ApplicationInfoManager applicationInfoManager, EurekaClient eurekaClient, DynamicPropertyFactory configInstance) {
        this.applicationInfoManager = applicationInfoManager;
        this.eurekaClient = eurekaClient;
        this.configInstance = configInstance;
    }

    @PostConstruct
    public void start() {
        System.out.println("Registering service to eureka with STARTING status");
        this.applicationInfoManager.setInstanceStatus(InstanceInfo.InstanceStatus.STARTING);
        System.out.println("Simulating service initialization by sleeping for 2 seconds...");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("Done sleeping, now changing status to UP");
        this.applicationInfoManager.setInstanceStatus(InstanceInfo.InstanceStatus.UP);
        this.waitForRegistrationWithEureka(this.eurekaClient);
        System.out.println("Service started and ready to process requests..");
        try {
            ServerSocket serverSocket = new ServerSocket(this.configInstance.getIntProperty("eureka.port", 8010).get());
            Socket s = serverSocket.accept();
            System.out.println("Client got connected... processing request from the client");
            this.processRequest(s);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Simulating service doing work by sleeping for 10 seconds...");
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("Removing registration from eureka");
        this.stop();
        System.out.println("Shutting down server. Demo over.");
    }

    @PreDestroy
    public void stop() {
        if (this.eurekaClient != null) {
            this.eurekaClient.shutdown();
        }
    }

    private void waitForRegistrationWithEureka(EurekaClient eurekaClient) {
        String vipAddress = this.configInstance.getStringProperty("eureka.vipAddress", "sampleservice.mydomain.net").get();
        InstanceInfo nextServerInfo = null;
        while (nextServerInfo == null) {
            try {
                nextServerInfo = eurekaClient.getNextServerFromEureka(vipAddress, false);
            }
            catch (Throwable e) {
                System.out.println("Waiting ... verifying service registration with eureka ...");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(Socket s) {
        try {
            BufferedReader rd = new BufferedReader(new InputStreamReader(s.getInputStream()));
            String line = rd.readLine();
            if (line != null) {
                System.out.println("Received a request from the example client: " + line);
            }
            String response = "BAR " + new Date();
            System.out.println("Sending the response to the client: " + response);
            PrintStream out = new PrintStream(s.getOutputStream());
            out.println(response);
        }
        catch (Throwable e) {
            System.err.println("Error processing requests");
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

