/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.util;

import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.LeaseInfo;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.util.EurekaEntityFunctions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class InstanceInfoGenerator {
    public static final int RENEW_INTERVAL = 5;
    private final int instanceCount;
    private final String[] appNames;
    private final String zone;
    private final boolean taggedId;
    private Iterator<InstanceInfo> currentIt;
    private Applications allApplications = new Applications();
    private final boolean withMetaData;
    private final boolean includeAsg;
    private final boolean useInstanceId;

    InstanceInfoGenerator(InstanceInfoGeneratorBuilder builder) {
        this.instanceCount = builder.instanceCount;
        this.appNames = builder.appNames;
        this.zone = builder.zone == null ? "us-east-1c" : builder.zone;
        this.taggedId = builder.taggedId;
        this.withMetaData = builder.includeMetaData;
        this.includeAsg = builder.includeAsg;
        this.useInstanceId = builder.useInstanceId;
    }

    public Applications takeDelta(int count) {
        if (this.currentIt == null) {
            this.currentIt = this.serviceIterator();
            this.allApplications = new Applications();
        }
        ArrayList<InstanceInfo> instanceBatch = new ArrayList<InstanceInfo>();
        for (int i = 0; i < count; ++i) {
            InstanceInfo next = this.currentIt.next();
            next.setActionType(InstanceInfo.ActionType.ADDED);
            instanceBatch.add(next);
        }
        Applications nextBatch = EurekaEntityFunctions.toApplications((Map)EurekaEntityFunctions.toApplicationMap(instanceBatch));
        this.allApplications = EurekaEntityFunctions.mergeApplications((Applications)this.allApplications, (Applications)nextBatch);
        nextBatch.setAppsHashCode(this.allApplications.getAppsHashCode());
        return nextBatch;
    }

    public Iterator<InstanceInfo> serviceIterator() {
        return new Iterator<InstanceInfo>(){
            private int returned;
            private final int[] appInstanceIds;
            private int currentApp;
            {
                this.appInstanceIds = new int[InstanceInfoGenerator.this.appNames.length];
            }

            @Override
            public boolean hasNext() {
                return this.returned < InstanceInfoGenerator.this.instanceCount;
            }

            @Override
            public InstanceInfo next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("no more InstanceInfo elements");
                }
                InstanceInfo toReturn = InstanceInfoGenerator.this.generateInstanceInfo(this.currentApp, this.appInstanceIds[this.currentApp], InstanceInfoGenerator.this.useInstanceId, InstanceInfo.ActionType.ADDED);
                int n = this.currentApp;
                this.appInstanceIds[n] = this.appInstanceIds[n] + 1;
                this.currentApp = (this.currentApp + 1) % InstanceInfoGenerator.this.appNames.length;
                ++this.returned;
                return toReturn;
            }

            @Override
            public void remove() {
                throw new IllegalStateException("method not supported");
            }
        };
    }

    public Applications toApplications() {
        HashMap<String, Application> appsByName = new HashMap<String, Application>();
        Iterator<InstanceInfo> it = this.serviceIterator();
        while (it.hasNext()) {
            InstanceInfo instanceInfo = it.next();
            Application instanceApp = (Application)appsByName.get(instanceInfo.getAppName());
            if (instanceApp == null) {
                instanceApp = new Application(instanceInfo.getAppName());
                appsByName.put(instanceInfo.getAppName(), instanceApp);
            }
            instanceApp.addInstance(instanceInfo);
        }
        Applications applications = new Applications();
        for (Application app : appsByName.values()) {
            applications.addApplication(app);
        }
        applications.shuffleInstances(false);
        applications.setAppsHashCode(applications.getReconcileHashCode());
        applications.setVersion(Long.valueOf(1L));
        return applications;
    }

    public List<InstanceInfo> toInstanceList() {
        ArrayList<InstanceInfo> result = new ArrayList<InstanceInfo>(this.instanceCount);
        Iterator<InstanceInfo> it = this.serviceIterator();
        while (it.hasNext()) {
            InstanceInfo instanceInfo = it.next();
            result.add(instanceInfo);
        }
        return result;
    }

    public InstanceInfo first() {
        return this.take(0);
    }

    public InstanceInfo take(int idx) {
        return this.toInstanceList().get(idx);
    }

    public static InstanceInfo takeOne() {
        return InstanceInfoGenerator.newBuilder(1, 1).withMetaData(true).build().serviceIterator().next();
    }

    public static InstanceInfoGeneratorBuilder newBuilder(int instanceCount, int applicationCount) {
        return new InstanceInfoGeneratorBuilder(instanceCount, applicationCount);
    }

    public static InstanceInfoGeneratorBuilder newBuilder(int instanceCount, String ... appNames) {
        return new InstanceInfoGeneratorBuilder(instanceCount, appNames);
    }

    public Applications takeDeltaForDelete(boolean useInstanceId, int instanceCount) {
        ArrayList<InstanceInfo> instanceInfoList = new ArrayList<InstanceInfo>();
        for (int i = 0; i < instanceCount; ++i) {
            instanceInfoList.add(this.generateInstanceInfo(i, i, useInstanceId, InstanceInfo.ActionType.DELETED));
        }
        Applications delete = EurekaEntityFunctions.toApplications((Map)EurekaEntityFunctions.toApplicationMap(instanceInfoList));
        this.allApplications = EurekaEntityFunctions.mergeApplications((Applications)this.allApplications, (Applications)delete);
        delete.setAppsHashCode(this.allApplications.getAppsHashCode());
        return delete;
    }

    private InstanceInfo generateInstanceInfo(int appIndex, int appInstanceId, boolean useInstanceId, InstanceInfo.ActionType actionType) {
        String appName = this.appNames[appIndex];
        String hostName = "instance" + appInstanceId + '.' + appName + ".com";
        String privateHostname = "ip-10.0" + appIndex + "." + appInstanceId + ".compute.internal";
        String publicIp = "20.0." + appIndex + '.' + appInstanceId;
        String privateIp = "192.168." + appIndex + '.' + appInstanceId;
        String instanceId = String.format("i-%04d%04d", appIndex, appInstanceId);
        if (this.taggedId) {
            instanceId = instanceId + '_' + appName;
        }
        AmazonInfo dataCenterInfo = AmazonInfo.Builder.newBuilder().addMetadata(AmazonInfo.MetaDataKey.accountId, "testAccountId").addMetadata(AmazonInfo.MetaDataKey.amiId, String.format("ami-%04d%04d", appIndex, appInstanceId)).addMetadata(AmazonInfo.MetaDataKey.availabilityZone, this.zone).addMetadata(AmazonInfo.MetaDataKey.instanceId, instanceId).addMetadata(AmazonInfo.MetaDataKey.instanceType, "m2.xlarge").addMetadata(AmazonInfo.MetaDataKey.localHostname, privateHostname).addMetadata(AmazonInfo.MetaDataKey.localIpv4, privateIp).addMetadata(AmazonInfo.MetaDataKey.publicHostname, hostName).addMetadata(AmazonInfo.MetaDataKey.publicIpv4, publicIp).build();
        String unsecureURL = "http://" + hostName + ":8080";
        String secureURL = "https://" + hostName + ":8081";
        long now = System.currentTimeMillis();
        LeaseInfo leaseInfo = LeaseInfo.Builder.newBuilder().setDurationInSecs(15).setRenewalIntervalInSecs(5).setServiceUpTimestamp(now - 5L).setRegistrationTimestamp(now).setEvictionTimestamp(now + 15L).setRenewalTimestamp(now + 5L).build();
        InstanceInfo.Builder builder = useInstanceId ? InstanceInfo.Builder.newBuilder().setInstanceId(instanceId) : InstanceInfo.Builder.newBuilder();
        builder.setActionType(actionType).setAppGroupName(appName + "Group").setAppName(appName).setHostName(hostName).setIPAddr(publicIp).setPort(8080).setSecurePort(8081).enablePort(InstanceInfo.PortType.SECURE, true).setHealthCheckUrls("/healthcheck", unsecureURL + "/healthcheck", secureURL + "/healthcheck").setHomePageUrl("/homepage", unsecureURL + "/homepage").setStatusPageUrl("/status", unsecureURL + "/status").setLeaseInfo(leaseInfo).setStatus(InstanceInfo.InstanceStatus.UP).setVIPAddress(appName + ":8080").setSecureVIPAddress(appName + ":8081").setDataCenterInfo((DataCenterInfo)dataCenterInfo).setLastUpdatedTimestamp(System.currentTimeMillis() - 100L).setLastDirtyTimestamp(System.currentTimeMillis() - 100L).setIsCoordinatingDiscoveryServer(true).enablePort(InstanceInfo.PortType.UNSECURE, true);
        if (this.includeAsg) {
            builder.setASGName(appName + "ASG");
        }
        if (this.withMetaData) {
            builder.add("appKey" + appIndex, Integer.toString(appInstanceId));
        }
        return builder.build();
    }

    public static class InstanceInfoGeneratorBuilder {
        private final int instanceCount;
        private String[] appNames;
        private boolean includeMetaData;
        private boolean includeAsg = true;
        private String zone;
        private boolean taggedId;
        private boolean useInstanceId = true;

        public InstanceInfoGeneratorBuilder(int instanceCount, int applicationCount) {
            this.instanceCount = instanceCount;
            String[] appNames = new String[applicationCount];
            for (int i = 0; i < appNames.length; ++i) {
                appNames[i] = "application" + i;
            }
            this.appNames = appNames;
        }

        public InstanceInfoGeneratorBuilder(int instanceCount, String ... appNames) {
            this.instanceCount = instanceCount;
            this.appNames = appNames;
        }

        public InstanceInfoGeneratorBuilder withZone(String zone) {
            this.zone = zone;
            return this;
        }

        public InstanceInfoGeneratorBuilder withTaggedId(boolean taggedId) {
            this.taggedId = taggedId;
            return this;
        }

        public InstanceInfoGeneratorBuilder withMetaData(boolean includeMetaData) {
            this.includeMetaData = includeMetaData;
            return this;
        }

        public InstanceInfoGeneratorBuilder withAsg(boolean includeAsg) {
            this.includeAsg = includeAsg;
            return this;
        }

        public InstanceInfoGeneratorBuilder withUseInstanceId(boolean useInstanceId) {
            this.useInstanceId = useInstanceId;
            return this;
        }

        public InstanceInfoGenerator build() {
            return new InstanceInfoGenerator(this);
        }
    }
}

