/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.transport;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.util.InstanceInfoGenerator;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.cluster.protocol.ReplicationInstance;
import com.netflix.eureka.cluster.protocol.ReplicationInstanceResponse;
import com.netflix.eureka.registry.PeerAwareInstanceRegistryImpl;
import java.util.Iterator;
import org.mockito.Mockito;

public final class ClusterSampleData {
    public static final long REPLICATION_EXPIRY_TIME_MS = 100L;
    public static final long RETRY_SLEEP_TIME_MS = 1L;
    public static final long SERVER_UNAVAILABLE_SLEEP_TIME_MS = 1L;
    public static final long EUREKA_NODES_UPDATE_INTERVAL_MS = 10L;

    private ClusterSampleData() {
    }

    public static EurekaServerConfig newEurekaServerConfig() {
        EurekaServerConfig config = (EurekaServerConfig)Mockito.mock(EurekaServerConfig.class);
        Mockito.when((Object)config.getPeerEurekaNodesUpdateIntervalMs()).thenReturn((Object)10);
        Mockito.when((Object)config.shouldSyncWhenTimestampDiffers()).thenReturn((Object)true);
        Mockito.when((Object)config.getMaxTimeForReplication()).thenReturn((Object)100);
        Mockito.when((Object)config.getMaxElementsInPeerReplicationPool()).thenReturn((Object)10);
        Mockito.when((Object)config.getMaxElementsInStatusReplicationPool()).thenReturn((Object)10);
        Mockito.when((Object)config.getMaxThreadsForPeerReplication()).thenReturn((Object)1);
        Mockito.when((Object)config.getMaxThreadsForStatusReplication()).thenReturn((Object)1);
        return config;
    }

    public static InstanceInfo newInstanceInfo(int index) {
        Iterator<InstanceInfo> instanceGenerator = InstanceInfoGenerator.newBuilder(10, 10).withMetaData(true).build().serviceIterator();
        for (int i = 0; i < index; ++i) {
            instanceGenerator.next();
        }
        return instanceGenerator.next();
    }

    public static ReplicationInstance newReplicationInstance() {
        return ClusterSampleData.newReplicationInstanceOf(PeerAwareInstanceRegistryImpl.Action.Register, ClusterSampleData.newInstanceInfo(0));
    }

    public static ReplicationInstance newReplicationInstanceOf(PeerAwareInstanceRegistryImpl.Action action, InstanceInfo instance) {
        switch (action) {
            case Register: {
                return new ReplicationInstance(instance.getAppName(), instance.getId(), Long.valueOf(System.currentTimeMillis()), null, instance.getStatus().name(), instance, action);
            }
            case Cancel: {
                return new ReplicationInstance(instance.getAppName(), instance.getId(), Long.valueOf(System.currentTimeMillis()), null, null, null, action);
            }
            case Heartbeat: {
                return new ReplicationInstance(instance.getAppName(), instance.getId(), Long.valueOf(System.currentTimeMillis()), InstanceInfo.InstanceStatus.OUT_OF_SERVICE.name(), instance.getStatus().name(), instance, action);
            }
            case StatusUpdate: {
                return new ReplicationInstance(instance.getAppName(), instance.getId(), Long.valueOf(System.currentTimeMillis()), InstanceInfo.InstanceStatus.OUT_OF_SERVICE.name(), null, null, action);
            }
            case DeleteStatusOverride: {
                return new ReplicationInstance(instance.getAppName(), instance.getId(), Long.valueOf(System.currentTimeMillis()), InstanceInfo.InstanceStatus.OUT_OF_SERVICE.name(), null, null, action);
            }
        }
        throw new IllegalStateException("Unexpected action " + action);
    }

    public static ReplicationInstanceResponse newReplicationInstanceResponse(boolean withInstanceInfo) {
        return new ReplicationInstanceResponse(200, withInstanceInfo ? ClusterSampleData.newInstanceInfo(1) : null);
    }
}

