/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.util;

import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.util.ApplicationFunctions;
import com.netflix.eureka.DefaultEurekaServerConfig;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.cluster.JerseyReplicationClient;

public class DiagnosticClient {
    public static void main(String[] args) throws InterruptedException {
        String discoveryURL = args[0];
        long startTime = System.currentTimeMillis();
        JerseyReplicationClient client = new JerseyReplicationClient((EurekaServerConfig)new DefaultEurekaServerConfig("eureka."), discoveryURL);
        Applications applications = (Applications)client.getApplications().getEntity();
        System.out.println("Applications count=" + applications.getRegisteredApplications().size());
        System.out.println("Instance count=" + ApplicationFunctions.countInstances(applications));
        while (true) {
            long delay;
            if ((delay = System.currentTimeMillis() - startTime) >= 30000L) {
                System.out.println("Processing delay exceeds 30sec; we may be out of sync");
            } else {
                long waitTime = 30000L - delay;
                System.out.println("Waiting " + waitTime / 1000L + "sec before next fetch...");
                Thread.sleep(15000L);
            }
            startTime = System.currentTimeMillis();
            Applications delta = (Applications)client.getDelta().getEntity();
            Applications merged = ApplicationFunctions.merge(applications, delta);
            if (merged.getAppsHashCode().equals(delta.getAppsHashCode())) {
                System.out.println("Hash codes match: " + delta.getAppsHashCode() + "(delta count=" + ApplicationFunctions.countInstances(delta) + ')');
                applications = merged;
                continue;
            }
            System.out.println("ERROR: hash codes do not match (" + delta.getAppsHashCode() + "(delta) != " + merged.getAppsHashCode() + " (merged) != " + applications.getAppsHashCode() + "(old apps)" + "(delta count=" + ApplicationFunctions.countInstances(delta) + ')');
            applications = (Applications)client.getApplications().getEntity();
        }
    }
}

