/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.util;

import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.util.EurekaEntityFunctions;
import com.netflix.eureka.DefaultEurekaServerConfig;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.resources.DefaultServerCodecs;
import com.netflix.eureka.resources.ServerCodecs;
import com.netflix.eureka.transport.JerseyReplicationClient;

public class DiagnosticClient {
    public static void main(String[] args) throws InterruptedException {
        String discoveryURL = args[0];
        long startTime = System.currentTimeMillis();
        DefaultEurekaServerConfig serverConfig = new DefaultEurekaServerConfig("eureka.");
        JerseyReplicationClient client = JerseyReplicationClient.createReplicationClient((EurekaServerConfig)serverConfig, (ServerCodecs)new DefaultServerCodecs((EurekaServerConfig)serverConfig), (String)discoveryURL);
        Applications applications = (Applications)client.getApplications().getEntity();
        System.out.println("Applications count=" + applications.getRegisteredApplications().size());
        System.out.println("Instance count=" + EurekaEntityFunctions.countInstances((Applications)applications));
        while (true) {
            long delay;
            if ((delay = System.currentTimeMillis() - startTime) >= 30000L) {
                System.out.println("Processing delay exceeds 30sec; we may be out of sync");
            } else {
                long waitTime = 30000L - delay;
                System.out.println("Waiting " + waitTime / 1000L + "sec before next fetch...");
                Thread.sleep(15000L);
            }
            startTime = System.currentTimeMillis();
            Applications delta = (Applications)client.getDelta().getEntity();
            Applications merged = EurekaEntityFunctions.mergeApplications((Applications)applications, (Applications)delta);
            if (merged.getAppsHashCode().equals(delta.getAppsHashCode())) {
                System.out.println("Hash codes match: " + delta.getAppsHashCode() + "(delta count=" + EurekaEntityFunctions.countInstances((Applications)delta) + ')');
                applications = merged;
                continue;
            }
            System.out.println("ERROR: hash codes do not match (" + delta.getAppsHashCode() + "(delta) != " + merged.getAppsHashCode() + " (merged) != " + applications.getAppsHashCode() + "(old apps)" + "(delta count=" + EurekaEntityFunctions.countInstances((Applications)delta) + ')');
            applications = (Applications)client.getApplications().getEntity();
        }
    }
}

