/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.transport;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.converters.wrappers.CodecWrappers;
import com.netflix.discovery.converters.wrappers.DecoderWrapper;
import com.netflix.discovery.converters.wrappers.EncoderWrapper;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleEurekaHttpServer {
    private static final Logger logger = LoggerFactory.getLogger(SimpleEurekaHttpServer.class);
    private final EurekaHttpClient requestHandler;
    private final HttpServer httpServer;
    private final EncoderWrapper encoder = CodecWrappers.getEncoder(CodecWrappers.JacksonJson.class);
    private final DecoderWrapper decoder = CodecWrappers.getDecoder(CodecWrappers.JacksonJson.class);

    public SimpleEurekaHttpServer(EurekaHttpClient requestHandler) throws IOException {
        this.requestHandler = requestHandler;
        this.httpServer = HttpServer.create(new InetSocketAddress(0), 1);
        this.httpServer.createContext("/v2", this.createEurekaV2Handle());
        this.httpServer.setExecutor(null);
        this.httpServer.start();
    }

    public void shutdown() {
        this.httpServer.stop(0);
    }

    public URI getServiceURI() {
        try {
            return new URI("http://localhost:" + this.getServerPort() + "/v2/");
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Cannot parse service URI", e);
        }
    }

    public int getServerPort() {
        return this.httpServer.getAddress().getPort();
    }

    private HttpHandler createEurekaV2Handle() {
        return new HttpHandler(){

            @Override
            public void handle(HttpExchange httpExchange) throws IOException {
                try {
                    String method = httpExchange.getRequestMethod();
                    String path = httpExchange.getRequestURI().getPath();
                    if (path.startsWith("/v2/apps")) {
                        if ("GET".equals(method)) {
                            SimpleEurekaHttpServer.this.handleAppsGET(httpExchange);
                        } else if ("POST".equals(method)) {
                            SimpleEurekaHttpServer.this.handleAppsPost(httpExchange);
                        } else if ("PUT".equals(method)) {
                            SimpleEurekaHttpServer.this.handleAppsPut(httpExchange);
                        } else if ("DELETE".equals(method)) {
                            SimpleEurekaHttpServer.this.handleAppsDelete(httpExchange);
                        } else {
                            httpExchange.sendResponseHeaders(404, 0L);
                        }
                    } else if (path.startsWith("/v2/vips")) {
                        SimpleEurekaHttpServer.this.handleVipsGET(httpExchange);
                    } else if (path.startsWith("/v2/svips")) {
                        SimpleEurekaHttpServer.this.handleSecureVipsGET(httpExchange);
                    } else if (path.startsWith("/v2/instances")) {
                        SimpleEurekaHttpServer.this.handleInstanceGET(httpExchange);
                    }
                }
                catch (Exception e) {
                    logger.error("HttpServer error", (Throwable)e);
                    httpExchange.sendResponseHeaders(500, 0L);
                }
                httpExchange.close();
            }
        };
    }

    private void handleAppsGET(HttpExchange httpExchange) throws IOException {
        EurekaHttpResponse httpResponse;
        String path = httpExchange.getRequestURI().getPath();
        if (path.matches("/v2/apps[/]?")) {
            String regions = SimpleEurekaHttpServer.getQueryParam(httpExchange, "regions");
            httpResponse = regions == null ? this.requestHandler.getApplications(new String[0]) : this.requestHandler.getApplications(new String[]{regions});
        } else if (path.matches("/v2/apps/delta[/]?")) {
            String regions = SimpleEurekaHttpServer.getQueryParam(httpExchange, "regions");
            httpResponse = regions == null ? this.requestHandler.getDelta(new String[0]) : this.requestHandler.getDelta(new String[]{regions});
        } else {
            Matcher matcher = Pattern.compile("/v2/apps/([^/]+)/([^/]+)").matcher(path);
            if (matcher.matches()) {
                httpResponse = this.requestHandler.getInstance(matcher.group(1), matcher.group(2));
            } else {
                httpExchange.sendResponseHeaders(404, 0L);
                return;
            }
        }
        this.mapResponse(httpExchange, httpResponse);
    }

    private void handleAppsPost(HttpExchange httpExchange) throws IOException {
        String path = httpExchange.getRequestURI().getPath();
        if (!path.matches("/v2/apps/([^/]+)(/)?")) {
            httpExchange.sendResponseHeaders(404, 0L);
            return;
        }
        InstanceInfo instance = (InstanceInfo)this.decoder.decode(httpExchange.getRequestBody(), InstanceInfo.class);
        EurekaHttpResponse httpResponse = this.requestHandler.register(instance);
        this.mapResponse(httpExchange, httpResponse);
    }

    private void handleAppsPut(HttpExchange httpExchange) throws IOException {
        EurekaHttpResponse httpResponse;
        String path = httpExchange.getRequestURI().getPath();
        Matcher matcher = Pattern.compile("/v2/apps/([^/]+)/([^/]+)").matcher(path);
        if (matcher.matches()) {
            String overriddenstatus = SimpleEurekaHttpServer.getQueryParam(httpExchange, "overriddenstatus");
            httpResponse = this.requestHandler.sendHeartBeat(matcher.group(1), matcher.group(2), null, overriddenstatus == null ? null : InstanceInfo.InstanceStatus.valueOf((String)overriddenstatus));
        } else {
            matcher = Pattern.compile("/v2/apps/([^/]+)/([^/]+)/status").matcher(path);
            if (matcher.matches()) {
                String newStatus = SimpleEurekaHttpServer.getQueryParam(httpExchange, "value");
                httpResponse = this.requestHandler.statusUpdate(matcher.group(1), matcher.group(2), newStatus == null ? null : InstanceInfo.InstanceStatus.valueOf((String)newStatus), null);
            } else {
                httpExchange.sendResponseHeaders(404, 0L);
                return;
            }
        }
        this.mapResponse(httpExchange, httpResponse);
    }

    private void handleAppsDelete(HttpExchange httpExchange) throws IOException {
        EurekaHttpResponse httpResponse;
        String path = httpExchange.getRequestURI().getPath();
        Matcher matcher = Pattern.compile("/v2/apps/([^/]+)/([^/]+)").matcher(path);
        if (matcher.matches()) {
            httpResponse = this.requestHandler.cancel(matcher.group(1), matcher.group(2));
        } else {
            matcher = Pattern.compile("/v2/apps/([^/]+)/([^/]+)/status").matcher(path);
            if (matcher.matches()) {
                httpResponse = this.requestHandler.deleteStatusOverride(matcher.group(1), matcher.group(2), null);
            } else {
                httpExchange.sendResponseHeaders(404, 0L);
                return;
            }
        }
        this.mapResponse(httpExchange, httpResponse);
    }

    private void handleVipsGET(HttpExchange httpExchange) throws IOException {
        Matcher matcher = Pattern.compile("/v2/vips/([^/]+)").matcher(httpExchange.getRequestURI().getPath());
        if (matcher.matches()) {
            String regions = SimpleEurekaHttpServer.getQueryParam(httpExchange, "regions");
            EurekaHttpResponse httpResponse = regions == null ? this.requestHandler.getVip(matcher.group(1), new String[0]) : this.requestHandler.getVip(matcher.group(1), new String[]{regions});
            this.mapResponse(httpExchange, httpResponse);
        } else {
            httpExchange.sendResponseHeaders(404, 0L);
        }
    }

    private void handleSecureVipsGET(HttpExchange httpExchange) throws IOException {
        Matcher matcher = Pattern.compile("/v2/svips/([^/]+)").matcher(httpExchange.getRequestURI().getPath());
        if (matcher.matches()) {
            String regions = SimpleEurekaHttpServer.getQueryParam(httpExchange, "regions");
            EurekaHttpResponse httpResponse = regions == null ? this.requestHandler.getSecureVip(matcher.group(1), new String[0]) : this.requestHandler.getSecureVip(matcher.group(1), new String[]{regions});
            this.mapResponse(httpExchange, httpResponse);
        } else {
            httpExchange.sendResponseHeaders(404, 0L);
        }
    }

    private void handleInstanceGET(HttpExchange httpExchange) throws IOException {
        Matcher matcher = Pattern.compile("/v2/instances/([^/]+)").matcher(httpExchange.getRequestURI().getPath());
        if (matcher.matches()) {
            this.mapResponse(httpExchange, this.requestHandler.getInstance(matcher.group(1)));
        } else {
            httpExchange.sendResponseHeaders(404, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void mapResponse(HttpExchange httpExchange, EurekaHttpResponse<T> response) throws IOException {
        for (Map.Entry headerEntry : response.getHeaders().entrySet()) {
            httpExchange.getResponseHeaders().add((String)headerEntry.getKey(), (String)headerEntry.getValue());
        }
        if (response.getStatusCode() / 100 != 2) {
            httpExchange.sendResponseHeaders(response.getStatusCode(), 0L);
            return;
        }
        Object entity = response.getEntity();
        byte[] body = null;
        if (entity != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.encoder.encode(entity, (OutputStream)bos);
            body = bos.toByteArray();
        }
        httpExchange.sendResponseHeaders(response.getStatusCode(), body == null ? 0L : (long)body.length);
        if (body != null) {
            try (OutputStream responseStream = httpExchange.getResponseBody();){
                responseStream.write(body);
                responseStream.flush();
            }
        }
    }

    private static String getQueryParam(HttpExchange httpExchange, String queryParam) {
        String query = httpExchange.getRequestURI().getQuery();
        if (query != null) {
            for (String part : query.split("&")) {
                String[] keyValue = part.split("=");
                if (keyValue.length <= 1 || !keyValue[0].equals(queryParam)) continue;
                return keyValue[1];
            }
        }
        return null;
    }
}

