/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.junit.resource;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.LeaseInfo;
import com.netflix.appinfo.MyDataCenterInstanceConfig;
import com.netflix.config.ConfigurationManager;
import com.netflix.discovery.CacheRefreshedEvent;
import com.netflix.discovery.DefaultEurekaClientConfig;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.transport.SimpleEurekaHttpServer;
import com.netflix.eventbus.impl.EventBusImpl;
import com.netflix.eventbus.spi.EventBus;
import com.netflix.eventbus.spi.InvalidSubscriberException;
import com.netflix.eventbus.spi.Subscribe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.rules.ExternalResource;

public class DiscoveryClientResource
extends ExternalResource {
    public static final String REMOTE_REGION = "myregion";
    public static final String REMOTE_ZONE = "myzone";
    public static final int CLIENT_REFRESH_RATE = 10;
    public static final String EUREKA_TEST_NAMESPACE = "eurekaTestNamespace.";
    private static final Set<String> SYSTEM_PROPERTY_TRACKER = new HashSet<String>();
    private final boolean registrationEnabled;
    private final boolean registryFetchEnabled;
    private final InstanceInfo instance;
    private final SimpleEurekaHttpServer eurekaHttpServer;
    private final Callable<Integer> portResolverCallable;
    private final List<String> remoteRegions;
    private final String vipFetch;
    private EventBus eventBus;
    private ApplicationInfoManager applicationManager;
    private EurekaClient client;
    private final List<DiscoveryClientResource> forkedDiscoveryClientResources = new ArrayList<DiscoveryClientResource>();
    private ApplicationInfoManager applicationInfoManager;

    DiscoveryClientResource(DiscoveryClientRuleBuilder builder) {
        this.registrationEnabled = builder.registrationEnabled;
        this.registryFetchEnabled = builder.registryFetchEnabled;
        this.portResolverCallable = builder.portResolverCallable;
        this.eurekaHttpServer = builder.eurekaHttpServer;
        this.instance = builder.instance;
        this.remoteRegions = builder.remoteRegions;
        this.vipFetch = builder.vipFetch;
    }

    public InstanceInfo getMyInstanceInfo() {
        return this.createApplicationManager().getInfo();
    }

    public EventBus getEventBus() {
        if (this.client == null) {
            this.getClient();
        }
        return this.eventBus;
    }

    public ApplicationInfoManager getApplicationInfoManager() {
        return this.applicationInfoManager;
    }

    public EurekaClient getClient() {
        if (this.client == null) {
            try {
                this.applicationInfoManager = this.createApplicationManager();
                EurekaClientConfig clientConfig = this.createEurekaClientConfig();
                DiscoveryClient.DiscoveryClientOptionalArgs optionalArgs = new DiscoveryClient.DiscoveryClientOptionalArgs();
                this.eventBus = new EventBusImpl();
                optionalArgs.setEventBus(this.eventBus);
                this.client = new DiscoveryClient(this.applicationInfoManager, clientConfig, optionalArgs);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitCacheUpdate(long timeout, TimeUnit unit) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        Object eventListener = new Object(){

            @Subscribe
            public void consume(CacheRefreshedEvent event) {
                latch.countDown();
            }
        };
        try {
            this.getEventBus().registerSubscriber(eventListener);
        }
        catch (InvalidSubscriberException e) {
            throw new IllegalStateException("Unexpected error during subscriber registration", e);
        }
        try {
            boolean bl = latch.await(timeout, unit);
            return bl;
        }
        finally {
            this.getEventBus().unregisterSubscriber(eventListener);
        }
    }

    private ApplicationInfoManager createApplicationManager() {
        if (this.applicationManager == null) {
            MyDataCenterInstanceConfig instanceConfig = new MyDataCenterInstanceConfig(EUREKA_TEST_NAMESPACE){

                public String getAppname() {
                    return "discoveryClientTest";
                }

                public int getLeaseRenewalIntervalInSeconds() {
                    return 1;
                }
            };
            this.applicationManager = new ApplicationInfoManager((EurekaInstanceConfig)instanceConfig);
        }
        return this.applicationManager;
    }

    private EurekaClientConfig createEurekaClientConfig() throws Exception {
        String serviceURI;
        if (this.portResolverCallable != null) {
            serviceURI = "http://localhost:" + this.portResolverCallable.call() + "/eureka/v2/";
        } else if (this.eurekaHttpServer != null) {
            serviceURI = this.eurekaHttpServer.getServiceURI().toString();
        } else {
            throw new IllegalStateException("Either port or EurekaHttpServer must be configured");
        }
        DiscoveryClientResource.bindProperty("eurekaTestNamespace.serviceUrl.default", serviceURI);
        if (this.remoteRegions != null && !this.remoteRegions.isEmpty()) {
            StringBuilder regions = new StringBuilder();
            for (String region : this.remoteRegions) {
                regions.append(',').append(region);
            }
            DiscoveryClientResource.bindProperty("eurekaTestNamespace.fetchRemoteRegionsRegistry", regions.substring(1));
        }
        DiscoveryClientResource.bindProperty("eurekaTestNamespace.registration.enabled", Boolean.toString(this.registrationEnabled));
        DiscoveryClientResource.bindProperty("eurekaTestNamespace.appinfo.initial.replicate.time", Integer.toString(0));
        DiscoveryClientResource.bindProperty("eurekaTestNamespace.appinfo.replicate.interval", Integer.toString(1));
        DiscoveryClientResource.bindProperty("eurekaTestNamespace.shouldFetchRegistry", Boolean.toString(this.registryFetchEnabled));
        DiscoveryClientResource.bindProperty("eurekaTestNamespace.client.refresh.interval", Integer.toString(1));
        if (this.vipFetch != null) {
            DiscoveryClientResource.bindProperty("eurekaTestNamespace.registryRefreshSingleVipAddress", this.vipFetch);
        }
        return new DefaultEurekaClientConfig(EUREKA_TEST_NAMESPACE);
    }

    protected void after() {
        if (this.client != null) {
            this.client.shutdown();
        }
        for (DiscoveryClientResource resource : this.forkedDiscoveryClientResources) {
            resource.after();
        }
        for (String property : SYSTEM_PROPERTY_TRACKER) {
            ConfigurationManager.getConfigInstance().clearProperty(property);
        }
        DiscoveryClientResource.clearDiscoveryClientConfig();
    }

    public DiscoveryClientRuleBuilder fork() {
        DiscoveryClientRuleBuilder builder = new DiscoveryClientRuleBuilder(){

            @Override
            public DiscoveryClientResource build() {
                DiscoveryClientResource clientResource = super.build();
                try {
                    clientResource.before();
                }
                catch (Throwable e) {
                    throw new IllegalStateException("Unexpected error during forking the client resource", e);
                }
                DiscoveryClientResource.this.forkedDiscoveryClientResources.add(clientResource);
                return clientResource;
            }
        };
        return builder.withInstanceInfo(this.instance).connectWith(this.eurekaHttpServer).withPortResolver(this.portResolverCallable).withRegistration(this.registrationEnabled).withRegistryFetch(this.registryFetchEnabled).withRemoteRegions(this.remoteRegions.toArray(new String[this.remoteRegions.size()]));
    }

    public static DiscoveryClientRuleBuilder newBuilder() {
        return new DiscoveryClientRuleBuilder();
    }

    public static void setupDiscoveryClientConfig(int serverPort, String path) {
        ConfigurationManager.getConfigInstance().setProperty("eureka.shouldFetchRegistry", (Object)"true");
        ConfigurationManager.getConfigInstance().setProperty("eureka.responseCacheAutoExpirationInSeconds", (Object)"10");
        ConfigurationManager.getConfigInstance().setProperty("eureka.client.refresh.interval", (Object)10);
        ConfigurationManager.getConfigInstance().setProperty("eureka.registration.enabled", (Object)"false");
        ConfigurationManager.getConfigInstance().setProperty("eureka.fetchRemoteRegionsRegistry", (Object)REMOTE_REGION);
        ConfigurationManager.getConfigInstance().setProperty("eureka.myregion.availabilityZones", (Object)REMOTE_ZONE);
        ConfigurationManager.getConfigInstance().setProperty("eureka.serviceUrl.default", (Object)("http://localhost:" + serverPort + path));
    }

    public static void clearDiscoveryClientConfig() {
        ConfigurationManager.getConfigInstance().clearProperty("eureka.client.refresh.interval");
        ConfigurationManager.getConfigInstance().clearProperty("eureka.registration.enabled");
        ConfigurationManager.getConfigInstance().clearProperty("eureka.fetchRemoteRegionsRegistry");
        ConfigurationManager.getConfigInstance().clearProperty("eureka.myregion.availabilityZones");
        ConfigurationManager.getConfigInstance().clearProperty("eureka.serviceUrl.default");
    }

    public static EurekaClient setupDiscoveryClient(InstanceInfo clientInstanceInfo) {
        DefaultEurekaClientConfig config = new DefaultEurekaClientConfig();
        ApplicationInfoManager applicationInfoManager = new ApplicationInfoManager((EurekaInstanceConfig)new MyDataCenterInstanceConfig(), clientInstanceInfo);
        DiscoveryManager.getInstance().setEurekaClientConfig((EurekaClientConfig)config);
        DiscoveryClient client = new DiscoveryClient(applicationInfoManager, (EurekaClientConfig)config);
        return client;
    }

    public static EurekaClient setupInjector(InstanceInfo clientInstanceInfo) {
        DefaultEurekaClientConfig config = new DefaultEurekaClientConfig();
        DiscoveryManager.getInstance().setEurekaClientConfig((EurekaClientConfig)config);
        DiscoveryClient client = new DiscoveryClient(clientInstanceInfo, (EurekaClientConfig)config);
        ApplicationInfoManager.getInstance().initComponent((EurekaInstanceConfig)new MyDataCenterInstanceConfig());
        return client;
    }

    public static InstanceInfo.Builder newInstanceInfoBuilder(int renewalIntervalInSecs) {
        InstanceInfo.Builder builder = InstanceInfo.Builder.newBuilder();
        builder.setIPAddr("10.10.101.00");
        builder.setHostName("Hosttt");
        builder.setAppName("EurekaTestApp-" + UUID.randomUUID());
        builder.setDataCenterInfo(new DataCenterInfo(){

            public DataCenterInfo.Name getName() {
                return DataCenterInfo.Name.MyOwn;
            }
        });
        builder.setLeaseInfo(LeaseInfo.Builder.newBuilder().setRenewalIntervalInSecs(renewalIntervalInSecs).build());
        return builder;
    }

    private static void bindProperty(String propertyName, String value) {
        SYSTEM_PROPERTY_TRACKER.add(propertyName);
        ConfigurationManager.getConfigInstance().setProperty(propertyName, (Object)value);
    }

    public static class DiscoveryClientRuleBuilder {
        private boolean registrationEnabled;
        private boolean registryFetchEnabled;
        private Callable<Integer> portResolverCallable;
        private InstanceInfo instance;
        private SimpleEurekaHttpServer eurekaHttpServer;
        private List<String> remoteRegions;
        private String vipFetch;

        public DiscoveryClientRuleBuilder withInstanceInfo(InstanceInfo instance) {
            this.instance = instance;
            return this;
        }

        public DiscoveryClientRuleBuilder withRegistration(boolean enabled) {
            this.registrationEnabled = enabled;
            return this;
        }

        public DiscoveryClientRuleBuilder withRegistryFetch(boolean enabled) {
            this.registryFetchEnabled = enabled;
            return this;
        }

        public DiscoveryClientRuleBuilder withPortResolver(Callable<Integer> portResolverCallable) {
            this.portResolverCallable = portResolverCallable;
            return this;
        }

        public DiscoveryClientRuleBuilder connectWith(SimpleEurekaHttpServer eurekaHttpServer) {
            this.eurekaHttpServer = eurekaHttpServer;
            return this;
        }

        public DiscoveryClientRuleBuilder withRemoteRegions(String ... remoteRegions) {
            if (this.remoteRegions == null) {
                this.remoteRegions = new ArrayList<String>();
            }
            Collections.addAll(this.remoteRegions, remoteRegions);
            return this;
        }

        public DiscoveryClientRuleBuilder withVipFetch(String vipFetch) {
            this.vipFetch = vipFetch;
            return this;
        }

        public DiscoveryClientResource build() {
            return new DiscoveryClientResource(this);
        }
    }
}

