/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.util;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ApplicationFunctions {
    private ApplicationFunctions() {
    }

    public static Map<String, Application> toApplicationMap(List<InstanceInfo> instances) {
        HashMap<String, Application> applicationMap = new HashMap<String, Application>();
        for (InstanceInfo instance : instances) {
            String appName = instance.getAppName();
            Application application = (Application)applicationMap.get(appName);
            if (application == null) {
                application = new Application(appName);
                applicationMap.put(appName, application);
            }
            application.addInstance(instance);
        }
        return applicationMap;
    }

    public static Applications toApplications(Map<String, Application> applicationMap) {
        Applications applications = new Applications();
        for (Application application : applicationMap.values()) {
            applications.addApplication(application);
        }
        return ApplicationFunctions.updateMeta(applications);
    }

    public static Set<String> applicationNames(Applications applications) {
        HashSet<String> names = new HashSet<String>();
        for (Application application : applications.getRegisteredApplications()) {
            names.add(application.getName());
        }
        return names;
    }

    public static Application copyOf(Application application) {
        Application copy = new Application(application.getName());
        for (InstanceInfo instance : application.getInstances()) {
            copy.addInstance(instance);
        }
        return copy;
    }

    public static Application merge(Application first, Application second) {
        if (!first.getName().equals(second.getName())) {
            throw new IllegalArgumentException("Cannot merge applications with different names");
        }
        Application merged = ApplicationFunctions.copyOf(first);
        for (InstanceInfo instance : second.getInstances()) {
            switch (instance.getActionType()) {
                case ADDED: 
                case MODIFIED: {
                    merged.addInstance(instance);
                    break;
                }
                case DELETED: {
                    merged.removeInstance(instance);
                }
            }
        }
        return merged;
    }

    public static Applications merge(Applications first, Applications second) {
        Set<String> firstNames = ApplicationFunctions.applicationNames(first);
        Set<String> secondNames = ApplicationFunctions.applicationNames(second);
        HashSet<String> allNames = new HashSet<String>(firstNames);
        allNames.addAll(secondNames);
        Applications merged = new Applications();
        for (String appName : allNames) {
            if (firstNames.contains(appName)) {
                if (secondNames.contains(appName)) {
                    merged.addApplication(ApplicationFunctions.merge(first.getRegisteredApplications(appName), second.getRegisteredApplications(appName)));
                    continue;
                }
                merged.addApplication(ApplicationFunctions.copyOf(first.getRegisteredApplications(appName)));
                continue;
            }
            merged.addApplication(ApplicationFunctions.copyOf(second.getRegisteredApplications(appName)));
        }
        return ApplicationFunctions.updateMeta(merged);
    }

    public static Applications updateMeta(Applications applications) {
        applications.setVersion(Long.valueOf(1L));
        applications.setAppsHashCode(applications.getReconcileHashCode());
        return applications;
    }

    public static int countInstances(Applications applications) {
        int count = 0;
        for (Application application : applications.getRegisteredApplications()) {
            count += application.getInstances().size();
        }
        return count;
    }
}

