/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.transport;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpRequest;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.discovery.shared.transport.EurekaTransportEventListener;
import com.netflix.discovery.shared.transport.SimpleEurekaHttpServer;
import com.netflix.discovery.util.EurekaEntityComparators;
import com.netflix.discovery.util.InstanceInfoGenerator;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public abstract class EurekaHttpClientCompatibilityTestSuite {
    private static final String REMOTE_REGION = "us-east-1";
    private final EurekaHttpClient requestHandler = (EurekaHttpClient)Mockito.mock(EurekaHttpClient.class);
    private final List<EurekaHttpRequest> observedHttpRequests = new CopyOnWriteArrayList<EurekaHttpRequest>();
    private final EurekaTransportEventListener transportEventListener = new EurekaTransportEventListener(){

        @Override
        public void onHttpRequest(EurekaHttpRequest request) {
            EurekaHttpClientCompatibilityTestSuite.this.observedHttpRequests.add(request);
        }
    };
    private SimpleEurekaHttpServer httpServer;

    protected EurekaHttpClientCompatibilityTestSuite() {
    }

    @Before
    public void setUp() throws Exception {
        this.httpServer = new SimpleEurekaHttpServer(this.requestHandler, this.transportEventListener);
    }

    @After
    public void tearDown() throws Exception {
        this.httpServer.shutdown();
    }

    protected abstract EurekaHttpClient getEurekaHttpClient(URI var1);

    protected EurekaHttpClient getEurekaHttpClient() {
        return this.getEurekaHttpClient(this.getHttpServer().getServiceURI());
    }

    protected EurekaHttpClient getEurekaClientWithBasicAuthentication(String userName, String password) {
        URI serviceURI = UriBuilder.fromUri((URI)this.getHttpServer().getServiceURI()).userInfo(userName + ':' + password).build(new Object[0]);
        return this.getEurekaHttpClient(serviceURI);
    }

    protected SimpleEurekaHttpServer getHttpServer() {
        return this.httpServer;
    }

    @Test
    public void testRegisterRequest() throws Exception {
        InstanceInfo instance = InstanceInfoGenerator.takeOne();
        Mockito.when((Object)this.requestHandler.register(instance)).thenReturn((Object)EurekaHttpResponse.status((int)204));
        EurekaHttpResponse httpResponse = this.getEurekaHttpClient().register(instance);
        Assert.assertThat((Object)httpResponse.getStatusCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)204)));
    }

    @Test
    public void testCancelRequest() throws Exception {
        InstanceInfo instance = InstanceInfoGenerator.takeOne();
        Mockito.when((Object)this.requestHandler.cancel(instance.getAppName(), instance.getId())).thenReturn((Object)EurekaHttpResponse.status((int)200));
        EurekaHttpResponse httpResponse = this.getEurekaHttpClient().cancel(instance.getAppName(), instance.getId());
        Assert.assertThat((Object)httpResponse.getStatusCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)200)));
    }

    @Test
    public void testHeartbeatRequest() throws Exception {
        InstanceInfo instance = InstanceInfoGenerator.takeOne();
        InstanceInfo updated = new InstanceInfo.Builder(instance).setHostName("another.host").build();
        Mockito.when((Object)this.requestHandler.sendHeartBeat(instance.getAppName(), instance.getId(), null, null)).thenReturn(EurekaHttpClientCompatibilityTestSuite.createResponse(updated));
        EurekaHttpResponse httpResponse = this.getEurekaHttpClient().sendHeartBeat(instance.getAppName(), instance.getId(), instance, null);
        EurekaHttpClientCompatibilityTestSuite.verifyResponseOkWithEntity(updated, (EurekaHttpResponse<InstanceInfo>)httpResponse);
    }

    @Test
    public void testStatusUpdateRequest() throws Exception {
        InstanceInfo instance = InstanceInfoGenerator.takeOne();
        Mockito.when((Object)this.requestHandler.statusUpdate(instance.getAppName(), instance.getId(), InstanceInfo.InstanceStatus.OUT_OF_SERVICE, null)).thenReturn((Object)EurekaHttpResponse.status((int)200));
        EurekaHttpResponse httpResponse = this.getEurekaHttpClient().statusUpdate(instance.getAppName(), instance.getId(), InstanceInfo.InstanceStatus.OUT_OF_SERVICE, instance);
        Assert.assertThat((Object)httpResponse.getStatusCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)200)));
    }

    @Test
    public void testGetApplicationsRequest() throws Exception {
        Applications apps = InstanceInfoGenerator.newBuilder(2, 1).build().toApplications();
        Mockito.when((Object)this.requestHandler.getApplications(new String[0])).thenReturn(EurekaHttpClientCompatibilityTestSuite.createResponse(apps));
        EurekaHttpResponse httpResponse = this.getEurekaHttpClient().getApplications(new String[0]);
        EurekaHttpClientCompatibilityTestSuite.verifyResponseOkWithEntity(apps, (EurekaHttpResponse<Applications>)httpResponse);
    }

    @Test
    public void testGetApplicationsWithRemoteRegionRequest() throws Exception {
        Applications apps = InstanceInfoGenerator.newBuilder(2, 1).build().toApplications();
        Mockito.when((Object)this.requestHandler.getApplications(new String[]{REMOTE_REGION})).thenReturn(EurekaHttpClientCompatibilityTestSuite.createResponse(apps));
        EurekaHttpResponse httpResponse = this.getEurekaHttpClient().getApplications(new String[]{REMOTE_REGION});
        EurekaHttpClientCompatibilityTestSuite.verifyResponseOkWithEntity(apps, (EurekaHttpResponse<Applications>)httpResponse);
    }

    @Test
    public void testGetDeltaRequest() throws Exception {
        Applications delta = InstanceInfoGenerator.newBuilder(2, 1).build().takeDelta(2);
        Mockito.when((Object)this.requestHandler.getDelta(new String[0])).thenReturn(EurekaHttpClientCompatibilityTestSuite.createResponse(delta));
        EurekaHttpResponse httpResponse = this.getEurekaHttpClient().getDelta(new String[0]);
        EurekaHttpClientCompatibilityTestSuite.verifyResponseOkWithEntity(delta, (EurekaHttpResponse<Applications>)httpResponse);
    }

    @Test
    public void testGetDeltaWithRemoteRegionRequest() throws Exception {
        Applications delta = InstanceInfoGenerator.newBuilder(2, 1).build().takeDelta(2);
        Mockito.when((Object)this.requestHandler.getDelta(new String[]{REMOTE_REGION})).thenReturn(EurekaHttpClientCompatibilityTestSuite.createResponse(delta));
        EurekaHttpResponse httpResponse = this.getEurekaHttpClient().getDelta(new String[]{REMOTE_REGION});
        EurekaHttpClientCompatibilityTestSuite.verifyResponseOkWithEntity(delta, (EurekaHttpResponse<Applications>)httpResponse);
    }

    @Test
    public void testGetInstanceRequest() throws Exception {
        InstanceInfo instance = InstanceInfoGenerator.takeOne();
        Mockito.when((Object)this.requestHandler.getInstance(instance.getId())).thenReturn(EurekaHttpClientCompatibilityTestSuite.createResponse(instance));
        EurekaHttpResponse httpResponse = this.getEurekaHttpClient().getInstance(instance.getId());
        EurekaHttpClientCompatibilityTestSuite.verifyResponseOkWithEntity(instance, (EurekaHttpResponse<InstanceInfo>)httpResponse);
    }

    @Test
    public void testGetApplicationInstanceRequest() throws Exception {
        InstanceInfo instance = InstanceInfoGenerator.takeOne();
        Mockito.when((Object)this.requestHandler.getInstance(instance.getAppName(), instance.getId())).thenReturn(EurekaHttpClientCompatibilityTestSuite.createResponse(instance));
        EurekaHttpResponse httpResponse = this.getEurekaHttpClient().getInstance(instance.getAppName(), instance.getId());
        EurekaHttpClientCompatibilityTestSuite.verifyResponseOkWithEntity(instance, (EurekaHttpResponse<InstanceInfo>)httpResponse);
    }

    @Test
    public void testGetVipRequest() throws Exception {
        Applications vipApps = InstanceInfoGenerator.newBuilder(1, 2).build().toApplications();
        String vipAddress = ((InstanceInfo)((Application)vipApps.getRegisteredApplications().get(0)).getInstances().get(0)).getVIPAddress();
        Mockito.when((Object)this.requestHandler.getVip(vipAddress, new String[0])).thenReturn(EurekaHttpClientCompatibilityTestSuite.createResponse(vipApps));
        EurekaHttpResponse httpResponse = this.getEurekaHttpClient().getVip(vipAddress, new String[0]);
        EurekaHttpClientCompatibilityTestSuite.verifyResponseOkWithEntity(vipApps, (EurekaHttpResponse<Applications>)httpResponse);
    }

    @Test
    public void testGetVipWithRemoteRegionRequest() throws Exception {
        Applications vipApps = InstanceInfoGenerator.newBuilder(1, 2).build().toApplications();
        String vipAddress = ((InstanceInfo)((Application)vipApps.getRegisteredApplications().get(0)).getInstances().get(0)).getVIPAddress();
        Mockito.when((Object)this.requestHandler.getVip(vipAddress, new String[]{REMOTE_REGION})).thenReturn(EurekaHttpClientCompatibilityTestSuite.createResponse(vipApps));
        EurekaHttpResponse httpResponse = this.getEurekaHttpClient().getVip(vipAddress, new String[]{REMOTE_REGION});
        EurekaHttpClientCompatibilityTestSuite.verifyResponseOkWithEntity(vipApps, (EurekaHttpResponse<Applications>)httpResponse);
    }

    @Test
    public void testGetSecureVipRequest() throws Exception {
        Applications vipApps = InstanceInfoGenerator.newBuilder(1, 2).build().toApplications();
        String secureVipAddress = ((InstanceInfo)((Application)vipApps.getRegisteredApplications().get(0)).getInstances().get(0)).getSecureVipAddress();
        Mockito.when((Object)this.requestHandler.getSecureVip(secureVipAddress, new String[0])).thenReturn(EurekaHttpClientCompatibilityTestSuite.createResponse(vipApps));
        EurekaHttpResponse httpResponse = this.getEurekaHttpClient().getSecureVip(secureVipAddress, new String[0]);
        EurekaHttpClientCompatibilityTestSuite.verifyResponseOkWithEntity(vipApps, (EurekaHttpResponse<Applications>)httpResponse);
    }

    @Test
    public void testGetSecureVipWithRemoteRegionRequest() throws Exception {
        Applications vipApps = InstanceInfoGenerator.newBuilder(1, 2).build().toApplications();
        String secureVipAddress = ((InstanceInfo)((Application)vipApps.getRegisteredApplications().get(0)).getInstances().get(0)).getSecureVipAddress();
        Mockito.when((Object)this.requestHandler.getSecureVip(secureVipAddress, new String[]{REMOTE_REGION})).thenReturn(EurekaHttpClientCompatibilityTestSuite.createResponse(vipApps));
        EurekaHttpResponse httpResponse = this.getEurekaHttpClient().getSecureVip(secureVipAddress, new String[]{REMOTE_REGION});
        EurekaHttpClientCompatibilityTestSuite.verifyResponseOkWithEntity(vipApps, (EurekaHttpResponse<Applications>)httpResponse);
    }

    @Test
    public void testStatusUpdateDeleteRequest() throws Exception {
        InstanceInfo instance = InstanceInfoGenerator.takeOne();
        Mockito.when((Object)this.requestHandler.deleteStatusOverride(instance.getAppName(), instance.getId(), null)).thenReturn((Object)EurekaHttpResponse.status((int)200));
        EurekaHttpResponse httpResponse = this.getEurekaHttpClient().deleteStatusOverride(instance.getAppName(), instance.getId(), instance);
        Assert.assertThat((Object)httpResponse.getStatusCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)200)));
    }

    @Test
    public void testBasicAuthentication() throws Exception {
        InstanceInfo instance = InstanceInfoGenerator.takeOne();
        Mockito.when((Object)this.requestHandler.register(instance)).thenReturn((Object)EurekaHttpResponse.status((int)204));
        EurekaHttpResponse httpResponse = this.getEurekaClientWithBasicAuthentication("myuser", "mypassword").register(instance);
        Assert.assertThat((Object)httpResponse.getStatusCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)204)));
        Assert.assertThat((Object)this.observedHttpRequests.get(0).getHeaders().containsKey("Authorization"), (Matcher)CoreMatchers.is((Object)true));
    }

    private static void verifyResponseOkWithEntity(Applications original, EurekaHttpResponse<Applications> httpResponse) {
        Assert.assertThat((Object)httpResponse.getStatusCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)200)));
        Assert.assertThat((Object)((Applications)httpResponse.getEntity()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)EurekaEntityComparators.equal((Applications)((Applications)httpResponse.getEntity()), (Applications)original), (Matcher)CoreMatchers.is((Object)true));
    }

    private static void verifyResponseOkWithEntity(InstanceInfo original, EurekaHttpResponse<InstanceInfo> httpResponse) {
        Assert.assertThat((Object)httpResponse.getStatusCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)200)));
        Assert.assertThat((Object)((InstanceInfo)httpResponse.getEntity()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)EurekaEntityComparators.equal((InstanceInfo)((InstanceInfo)httpResponse.getEntity()), (InstanceInfo)original), (Matcher)CoreMatchers.is((Object)true));
    }

    private static <T> EurekaHttpResponse<T> createResponse(T entity) {
        return EurekaHttpResponse.anEurekaHttpResponse((int)200, entity).headers("Content-Type", (Object)"application/json").build();
    }
}

