/*
 * Decompiled with CFR 0.152.
 */
package com.eureka2.shading.apache.avro.io;

import com.eureka2.shading.apache.avro.AvroTypeException;
import com.eureka2.shading.apache.avro.Schema;
import com.eureka2.shading.apache.avro.io.Decoder;
import com.eureka2.shading.apache.avro.io.DecoderFactory;
import com.eureka2.shading.apache.avro.io.ValidatingDecoder;
import com.eureka2.shading.apache.avro.io.parsing.ResolvingGrammarGenerator;
import com.eureka2.shading.apache.avro.io.parsing.Symbol;
import com.eureka2.shading.apache.avro.util.Utf8;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class ResolvingDecoder
extends ValidatingDecoder {
    private Decoder backup;
    private static final Charset UTF8 = Charset.forName("UTF-8");

    ResolvingDecoder(Schema writer, Schema reader, Decoder in) throws IOException {
        this(ResolvingDecoder.resolve(writer, reader), in);
    }

    private ResolvingDecoder(Object resolver, Decoder in) throws IOException {
        super((Symbol)resolver, in);
    }

    public static Object resolve(Schema writer, Schema reader) throws IOException {
        if (null == writer) {
            throw new NullPointerException("writer cannot be null!");
        }
        if (null == reader) {
            throw new NullPointerException("reader cannot be null!");
        }
        return new ResolvingGrammarGenerator().generate(writer, reader);
    }

    public final Schema.Field[] readFieldOrder() throws IOException {
        return ((Symbol.FieldOrderAction)this.parser.advance((Symbol)Symbol.FIELD_ACTION)).fields;
    }

    public final void drain() throws IOException {
        this.parser.processImplicitActions();
    }

    @Override
    public long readLong() throws IOException {
        Symbol actual = this.parser.advance(Symbol.LONG);
        if (actual == Symbol.INT) {
            return this.in.readInt();
        }
        if (actual == Symbol.DOUBLE) {
            return (long)this.in.readDouble();
        }
        assert (actual == Symbol.LONG);
        return this.in.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        Symbol actual = this.parser.advance(Symbol.FLOAT);
        if (actual == Symbol.INT) {
            return this.in.readInt();
        }
        if (actual == Symbol.LONG) {
            return this.in.readLong();
        }
        assert (actual == Symbol.FLOAT);
        return this.in.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        Symbol actual = this.parser.advance(Symbol.DOUBLE);
        if (actual == Symbol.INT) {
            return this.in.readInt();
        }
        if (actual == Symbol.LONG) {
            return this.in.readLong();
        }
        if (actual == Symbol.FLOAT) {
            return this.in.readFloat();
        }
        assert (actual == Symbol.DOUBLE);
        return this.in.readDouble();
    }

    @Override
    public Utf8 readString(Utf8 old) throws IOException {
        Symbol actual = this.parser.advance(Symbol.STRING);
        if (actual == Symbol.BYTES) {
            return new Utf8(this.in.readBytes(null).array());
        }
        assert (actual == Symbol.STRING);
        return this.in.readString(old);
    }

    @Override
    public String readString() throws IOException {
        Symbol actual = this.parser.advance(Symbol.STRING);
        if (actual == Symbol.BYTES) {
            return new String(this.in.readBytes(null).array(), UTF8);
        }
        assert (actual == Symbol.STRING);
        return this.in.readString();
    }

    @Override
    public void skipString() throws IOException {
        Symbol actual = this.parser.advance(Symbol.STRING);
        if (actual == Symbol.BYTES) {
            this.in.skipBytes();
        } else {
            assert (actual == Symbol.STRING);
            this.in.skipString();
        }
    }

    @Override
    public ByteBuffer readBytes(ByteBuffer old) throws IOException {
        Symbol actual = this.parser.advance(Symbol.BYTES);
        if (actual == Symbol.STRING) {
            Utf8 s = this.in.readString(null);
            return ByteBuffer.wrap(s.getBytes(), 0, s.getByteLength());
        }
        assert (actual == Symbol.BYTES);
        return this.in.readBytes(old);
    }

    @Override
    public void skipBytes() throws IOException {
        Symbol actual = this.parser.advance(Symbol.BYTES);
        if (actual == Symbol.STRING) {
            this.in.skipString();
        } else {
            assert (actual == Symbol.BYTES);
            this.in.skipBytes();
        }
    }

    @Override
    public int readEnum() throws IOException {
        this.parser.advance(Symbol.ENUM);
        Symbol.EnumAdjustAction top = (Symbol.EnumAdjustAction)this.parser.popSymbol();
        int n = this.in.readEnum();
        Object o = top.adjustments[n];
        if (o instanceof Integer) {
            return (Integer)o;
        }
        throw new AvroTypeException((String)o);
    }

    @Override
    public int readIndex() throws IOException {
        this.parser.advance(Symbol.UNION);
        Symbol.UnionAdjustAction top = (Symbol.UnionAdjustAction)this.parser.popSymbol();
        this.parser.pushSymbol(top.symToParse);
        return top.rindex;
    }

    @Override
    public Symbol doAction(Symbol input, Symbol top) throws IOException {
        if (top instanceof Symbol.FieldOrderAction) {
            return input == Symbol.FIELD_ACTION ? top : null;
        }
        if (top instanceof Symbol.ResolvingAction) {
            Symbol.ResolvingAction t = (Symbol.ResolvingAction)top;
            if (t.reader != input) {
                throw new AvroTypeException("Found " + t.reader + " while looking for " + input);
            }
            return t.writer;
        }
        if (top instanceof Symbol.SkipAction) {
            Symbol symToSkip = ((Symbol.SkipAction)top).symToSkip;
            this.parser.skipSymbol(symToSkip);
        } else if (top instanceof Symbol.WriterUnionAction) {
            Symbol.Alternative branches = (Symbol.Alternative)this.parser.popSymbol();
            this.parser.pushSymbol(branches.getSymbol(this.in.readIndex()));
        } else {
            if (top instanceof Symbol.ErrorAction) {
                throw new AvroTypeException(((Symbol.ErrorAction)top).msg);
            }
            if (top instanceof Symbol.DefaultStartAction) {
                Symbol.DefaultStartAction dsa = (Symbol.DefaultStartAction)top;
                this.backup = this.in;
                this.in = DecoderFactory.get().binaryDecoder(dsa.contents, null);
            } else if (top == Symbol.DEFAULT_END_ACTION) {
                this.in = this.backup;
            } else {
                throw new AvroTypeException("Unknown action: " + top);
            }
        }
        return null;
    }

    @Override
    public void skipAction() throws IOException {
        Symbol top = this.parser.popSymbol();
        if (top instanceof Symbol.ResolvingAction) {
            this.parser.pushSymbol(((Symbol.ResolvingAction)top).writer);
        } else if (top instanceof Symbol.SkipAction) {
            this.parser.pushSymbol(((Symbol.SkipAction)top).symToSkip);
        } else if (top instanceof Symbol.WriterUnionAction) {
            Symbol.Alternative branches = (Symbol.Alternative)this.parser.popSymbol();
            this.parser.pushSymbol(branches.getSymbol(this.in.readIndex()));
        } else {
            if (top instanceof Symbol.ErrorAction) {
                throw new AvroTypeException(((Symbol.ErrorAction)top).msg);
            }
            if (top instanceof Symbol.DefaultStartAction) {
                Symbol.DefaultStartAction dsa = (Symbol.DefaultStartAction)top;
                this.backup = this.in;
                this.in = DecoderFactory.get().binaryDecoder(dsa.contents, null);
            } else if (top == Symbol.DEFAULT_END_ACTION) {
                this.in = this.backup;
            }
        }
    }
}

