/*
 * Decompiled with CFR 0.152.
 */
package com.eureka2.shading.apache.commons.compress.archivers.dump;

import com.eureka2.shading.apache.commons.compress.archivers.dump.DumpArchiveConstants;
import com.eureka2.shading.apache.commons.compress.archivers.dump.DumpArchiveException;
import com.eureka2.shading.apache.commons.compress.archivers.dump.DumpArchiveUtil;
import com.eureka2.shading.apache.commons.compress.archivers.dump.ShortFileException;
import com.eureka2.shading.apache.commons.compress.archivers.dump.UnsupportedCompressionAlgorithmException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

class TapeInputStream
extends FilterInputStream {
    private byte[] blockBuffer = new byte[1024];
    private int currBlkIdx = -1;
    private int blockSize = 1024;
    private int recordSize = 1024;
    private int readOffset = 1024;
    private boolean isCompressed = false;
    private long bytesRead = 0L;

    public TapeInputStream(InputStream in) {
        super(in);
    }

    public void resetBlockSize(int recsPerBlock, boolean isCompressed) throws IOException {
        this.isCompressed = isCompressed;
        this.blockSize = this.recordSize * recsPerBlock;
        byte[] oldBuffer = this.blockBuffer;
        this.blockBuffer = new byte[this.blockSize];
        System.arraycopy(oldBuffer, 0, this.blockBuffer, 0, this.recordSize);
        this.readFully(this.blockBuffer, this.recordSize, this.blockSize - this.recordSize);
        this.currBlkIdx = 0;
        this.readOffset = this.recordSize;
    }

    public int available() throws IOException {
        if (this.readOffset < this.blockSize) {
            return this.blockSize - this.readOffset;
        }
        return this.in.available();
    }

    public int read() throws IOException {
        throw new IllegalArgumentException("all reads must be multiple of record size (" + this.recordSize + " bytes.");
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len % this.recordSize != 0) {
            throw new IllegalArgumentException("all reads must be multiple of record size (" + this.recordSize + " bytes.");
        }
        int bytes = 0;
        while (bytes < len) {
            if (this.readOffset == this.blockSize && !this.readBlock(true)) {
                return -1;
            }
            int n = 0;
            n = this.readOffset + (len - bytes) <= this.blockSize ? len - bytes : this.blockSize - this.readOffset;
            System.arraycopy(this.blockBuffer, this.readOffset, b, off, n);
            this.readOffset += n;
            bytes += n;
            off += n;
        }
        return bytes;
    }

    public long skip(long len) throws IOException {
        long bytes;
        long n;
        if (len % (long)this.recordSize != 0L) {
            throw new IllegalArgumentException("all reads must be multiple of record size (" + this.recordSize + " bytes.");
        }
        for (bytes = 0L; bytes < len; bytes += n) {
            if (this.readOffset == this.blockSize && !this.readBlock(len - bytes < (long)this.blockSize)) {
                return -1L;
            }
            n = 0L;
            n = (long)this.readOffset + (len - bytes) <= (long)this.blockSize ? len - bytes : (long)(this.blockSize - this.readOffset);
            this.readOffset = (int)((long)this.readOffset + n);
        }
        return bytes;
    }

    public void close() throws IOException {
        if (this.in != null && this.in != System.in) {
            this.in.close();
        }
    }

    public byte[] peek() throws IOException {
        if (this.readOffset == this.blockSize && !this.readBlock(true)) {
            return null;
        }
        byte[] b = new byte[this.recordSize];
        System.arraycopy(this.blockBuffer, this.readOffset, b, 0, b.length);
        return b;
    }

    public byte[] readRecord() throws IOException {
        byte[] result = new byte[this.recordSize];
        if (-1 == this.read(result, 0, result.length)) {
            throw new ShortFileException();
        }
        return result;
    }

    private boolean readBlock(boolean decompress) throws IOException {
        boolean success = true;
        if (this.in == null) {
            throw new IOException("input buffer is closed");
        }
        if (!this.isCompressed || this.currBlkIdx == -1) {
            success = this.readFully(this.blockBuffer, 0, this.blockSize);
            this.bytesRead += (long)this.blockSize;
        } else {
            boolean compressed;
            if (!this.readFully(this.blockBuffer, 0, 4)) {
                return false;
            }
            this.bytesRead += 4L;
            int h = DumpArchiveUtil.convert32(this.blockBuffer, 0);
            boolean bl = compressed = (h & 1) == 1;
            if (!compressed) {
                success = this.readFully(this.blockBuffer, 0, this.blockSize);
                this.bytesRead += (long)this.blockSize;
            } else {
                int flags = h >> 1 & 7;
                int length = h >> 4 & 0xFFFFFFF;
                byte[] compBuffer = new byte[length];
                success = this.readFully(compBuffer, 0, length);
                this.bytesRead += (long)length;
                if (!decompress) {
                    Arrays.fill(this.blockBuffer, (byte)0);
                } else {
                    switch (DumpArchiveConstants.COMPRESSION_TYPE.find(flags & 3)) {
                        case ZLIB: {
                            try {
                                Inflater inflator = new Inflater();
                                inflator.setInput(compBuffer, 0, compBuffer.length);
                                length = inflator.inflate(this.blockBuffer);
                                if (length != this.blockSize) {
                                    throw new ShortFileException();
                                }
                                inflator.end();
                                break;
                            }
                            catch (DataFormatException e) {
                                throw new DumpArchiveException("bad data", e);
                            }
                        }
                        case BZLIB: {
                            throw new UnsupportedCompressionAlgorithmException("BZLIB2");
                        }
                        case LZO: {
                            throw new UnsupportedCompressionAlgorithmException("LZO");
                        }
                        default: {
                            throw new UnsupportedCompressionAlgorithmException();
                        }
                    }
                }
            }
        }
        ++this.currBlkIdx;
        this.readOffset = 0;
        return success;
    }

    private boolean readFully(byte[] b, int off, int len) throws IOException {
        int n;
        for (int count = 0; count < len; count += n) {
            n = this.in.read(b, off + count, len - count);
            if (n != -1) continue;
            throw new ShortFileException();
        }
        return true;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }
}

