/*
 * Decompiled with CFR 0.152.
 */
package com.eureka2.shading.reactivex.netty.client;

import com.eureka2.shading.reactivex.netty.channel.ChannelMetricEventProvider;
import com.eureka2.shading.reactivex.netty.channel.ObservableConnection;
import com.eureka2.shading.reactivex.netty.client.ConnectionPool;
import com.eureka2.shading.reactivex.netty.client.ConnectionReuseEvent;
import com.eureka2.shading.reactivex.netty.client.PoolConfig;
import com.eureka2.shading.reactivex.netty.metrics.MetricEventsSubject;
import com.eureka2.shading.reactivex.netty.protocol.http.client.ClientRequestResponseConverter;
import io.netty.channel.Channel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Observer;
import rx.subjects.PublishSubject;

public class PooledConnection<I, O>
extends ObservableConnection<I, O> {
    private static final Logger logger = LoggerFactory.getLogger(PooledConnection.class);
    private final AtomicBoolean acquiredOrSoonToBeDiscarded = new AtomicBoolean();
    private ConnectionPool<I, O> pool;
    private volatile long lastReturnToPoolTimeMillis = System.currentTimeMillis();
    private volatile long maxIdleTimeMillis;

    protected PooledConnection(Channel channel, long maxIdleTimeMillis, ChannelMetricEventProvider metricEventProvider, MetricEventsSubject<?> eventsSubject) {
        super(channel, metricEventProvider, eventsSubject);
        this.maxIdleTimeMillis = maxIdleTimeMillis;
    }

    public void setConnectionPool(ConnectionPool<I, O> pool) {
        this.pool = pool;
    }

    @Override
    public Observable<Void> close() {
        this.acquiredOrSoonToBeDiscarded.compareAndSet(true, false);
        if (!this.isUsable()) {
            this.discard();
        }
        return super.close();
    }

    @Override
    protected Observable<Void> _closeChannel() {
        Observable<Void> release;
        Long keepAliveTimeout = (Long)this.getChannel().attr(ClientRequestResponseConverter.KEEP_ALIVE_TIMEOUT_MILLIS_ATTR).get();
        if (null != keepAliveTimeout) {
            this.maxIdleTimeMillis = keepAliveTimeout;
        }
        if (null != this.pool) {
            this.cancelPendingWrites(true);
            release = this.pool.release(this);
            this.lastReturnToPoolTimeMillis = System.currentTimeMillis();
        } else {
            logger.warn("Connection pool instance not set in the PooledConnection. Discarding this connection.");
            release = super._closeChannel();
        }
        return release;
    }

    public Observable<Void> closeUnderlyingChannel() {
        return super._closeChannel();
    }

    public boolean isUsable() {
        Boolean discardConn = (Boolean)this.getChannel().attr(ClientRequestResponseConverter.DISCARD_CONNECTION).get();
        if (!this.getChannel().isActive() || Boolean.TRUE == discardConn) {
            return false;
        }
        long nowMillis = System.currentTimeMillis();
        long idleTime = nowMillis - this.lastReturnToPoolTimeMillis;
        return idleTime < this.maxIdleTimeMillis;
    }

    public void beforeReuse() {
        this.closeIssued.set(false);
        PublishSubject newInputSubject = PublishSubject.create();
        this.updateInputSubject(newInputSubject);
        ConnectionReuseEvent reuseEvent = new ConnectionReuseEvent(this, (Observer)newInputSubject);
        this.getChannel().pipeline().fireUserEventTriggered((Object)reuseEvent);
    }

    public void updateMaxIdleTimeMillis(long maxIdleTimeMillis) {
        this.maxIdleTimeMillis = maxIdleTimeMillis;
    }

    public static <I, O> PooledConnection<I, O> create(Channel channel, long maxIdleTimeMillis, ChannelMetricEventProvider metricEventProvider, MetricEventsSubject<?> eventsSubject) {
        PooledConnection<I, O> toReturn = new PooledConnection<I, O>(channel, maxIdleTimeMillis, metricEventProvider, eventsSubject);
        toReturn.fireNewRxConnectionEvent();
        return toReturn;
    }

    public static <I, O> PooledConnection<I, O> create(Channel channel, ChannelMetricEventProvider metricEventProvider, MetricEventsSubject<?> eventsSubject) {
        return PooledConnection.create(channel, PoolConfig.DEFAULT_CONFIG.getMaxIdleTimeMillis(), metricEventProvider, eventsSubject);
    }

    void setLastReturnToPoolTimeMillis(long lastReturnToPoolTimeMillis) {
        this.lastReturnToPoolTimeMillis = lastReturnToPoolTimeMillis;
    }

    boolean claim() {
        return this.acquiredOrSoonToBeDiscarded.compareAndSet(false, true);
    }

    private void discard() {
        if (null == this.pool) {
            logger.warn("Connection pool instance not set in the PooledConnection.");
        } else {
            this.pool.discard(this);
        }
    }
}

