/*
 * Decompiled with CFR 0.152.
 */
package com.eureka2.shading.reactivex.netty.pipeline;

import com.eureka2.shading.reactivex.netty.client.ClientMetricsEvent;
import com.eureka2.shading.reactivex.netty.client.ClientRequiredConfigurator;
import com.eureka2.shading.reactivex.netty.client.RxClient;
import com.eureka2.shading.reactivex.netty.metrics.MetricEventsSubject;
import com.eureka2.shading.reactivex.netty.pipeline.ByteArrayPipelineConfigurator;
import com.eureka2.shading.reactivex.netty.pipeline.PipelineConfigurator;
import com.eureka2.shading.reactivex.netty.pipeline.PipelineConfiguratorComposite;
import com.eureka2.shading.reactivex.netty.pipeline.ReadTimeoutPipelineConfigurator;
import com.eureka2.shading.reactivex.netty.pipeline.StringMessageConfigurator;
import com.eureka2.shading.reactivex.netty.pipeline.ssl.SSLEngineFactory;
import com.eureka2.shading.reactivex.netty.pipeline.ssl.SslPipelineConfigurator;
import com.eureka2.shading.reactivex.netty.protocol.http.HttpObjectAggregationConfigurator;
import com.eureka2.shading.reactivex.netty.protocol.http.client.HttpClientPipelineConfigurator;
import com.eureka2.shading.reactivex.netty.protocol.http.client.HttpClientRequest;
import com.eureka2.shading.reactivex.netty.protocol.http.client.HttpClientResponse;
import com.eureka2.shading.reactivex.netty.protocol.http.server.HttpServerPipelineConfigurator;
import com.eureka2.shading.reactivex.netty.protocol.http.server.HttpServerRequest;
import com.eureka2.shading.reactivex.netty.protocol.http.server.HttpServerResponse;
import com.eureka2.shading.reactivex.netty.protocol.http.sse.ServerSentEvent;
import com.eureka2.shading.reactivex.netty.protocol.http.sse.SseClientPipelineConfigurator;
import com.eureka2.shading.reactivex.netty.protocol.http.sse.SseOverHttpClientPipelineConfigurator;
import com.eureka2.shading.reactivex.netty.protocol.http.sse.SseOverHttpServerPipelineConfigurator;
import com.eureka2.shading.reactivex.netty.protocol.http.sse.SseServerPipelineConfigurator;
import com.eureka2.shading.reactivex.netty.protocol.text.SimpleTextProtocolConfigurator;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;

public final class PipelineConfigurators {
    private static final PipelineConfigurator<ByteBuf, ByteBuf> EMPTY_CONFIGURATOR = new PipelineConfigurator<ByteBuf, ByteBuf>(){

        @Override
        public void configureNewPipeline(ChannelPipeline pipeline) {
        }
    };

    private PipelineConfigurators() {
    }

    public static PipelineConfigurator<byte[], byte[]> byteArrayConfigurator() {
        return new ByteArrayPipelineConfigurator();
    }

    public static PipelineConfigurator<String, String> textOnlyConfigurator() {
        return new StringMessageConfigurator();
    }

    public static PipelineConfigurator<String, String> textOnlyConfigurator(Charset inputCharset, Charset outputCharset) {
        return new StringMessageConfigurator(inputCharset, outputCharset);
    }

    public static PipelineConfigurator<String, String> stringMessageConfigurator() {
        return new SimpleTextProtocolConfigurator();
    }

    public static <I, O> PipelineConfigurator<HttpServerRequest<I>, HttpServerResponse<O>> httpServerConfigurator() {
        return new PipelineConfiguratorComposite<HttpServerRequest<I>, HttpServerResponse<O>>(new HttpServerPipelineConfigurator(), new HttpObjectAggregationConfigurator());
    }

    public static <I, O> PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> httpClientConfigurator() {
        return new PipelineConfiguratorComposite<HttpClientResponse<O>, HttpClientRequest<I>>(new HttpClientPipelineConfigurator(), new HttpObjectAggregationConfigurator());
    }

    public static <I> PipelineConfigurator<HttpClientResponse<ServerSentEvent>, HttpClientRequest<I>> clientSseConfigurator() {
        return new SseClientPipelineConfigurator();
    }

    public static <I> PipelineConfigurator<HttpServerRequest<I>, HttpServerResponse<ServerSentEvent>> serveSseConfigurator() {
        return new SseServerPipelineConfigurator();
    }

    @Deprecated
    public static <I> PipelineConfigurator<HttpClientResponse<com.eureka2.shading.reactivex.netty.protocol.text.sse.ServerSentEvent>, HttpClientRequest<I>> sseClientConfigurator() {
        return new SseOverHttpClientPipelineConfigurator();
    }

    @Deprecated
    public static <I> PipelineConfigurator<HttpServerRequest<I>, HttpServerResponse<com.eureka2.shading.reactivex.netty.protocol.text.sse.ServerSentEvent>> sseServerConfigurator() {
        return new SseOverHttpServerPipelineConfigurator();
    }

    public static <I, O> PipelineConfigurator<I, O> sslConfigurator(SSLEngineFactory sslEngineFactory) {
        return new SslPipelineConfigurator(sslEngineFactory);
    }

    public static <I, O> PipelineConfigurator<I, O> appendLoggingConfigurator(PipelineConfigurator<I, O> existing, LogLevel logLevel) {
        if (null == existing) {
            return PipelineConfigurators.wireLoggingConfigurator(logLevel);
        }
        return new PipelineConfiguratorComposite(existing, PipelineConfigurators.wireLoggingConfigurator(logLevel));
    }

    public static <I, O> PipelineConfigurator<I, O> composeConfigurators(PipelineConfigurator<I, O> existing, PipelineConfigurator<I, O> additional) {
        if (null == additional) {
            throw new NullPointerException("Additional configurator can not be null.");
        }
        if (null == existing) {
            return additional;
        }
        return new PipelineConfiguratorComposite(existing, additional);
    }

    public static <I, O> PipelineConfigurator<I, O> wireLoggingConfigurator(final LogLevel wireLogginLevel) {
        return new PipelineConfigurator<I, O>(){

            @Override
            public void configureNewPipeline(ChannelPipeline pipeline) {
                pipeline.addFirst(new ChannelHandler[]{new LoggingHandler(wireLogginLevel)});
            }
        };
    }

    public static <I, O> PipelineConfigurator<I, O> createClientConfigurator(PipelineConfigurator<I, O> pipelineConfigurator, RxClient.ClientConfig clientConfig) {
        return PipelineConfigurators.createClientConfigurator(pipelineConfigurator, clientConfig, new MetricEventsSubject());
    }

    public static <I, O> PipelineConfigurator<I, O> createClientConfigurator(PipelineConfigurator<I, O> pipelineConfigurator, RxClient.ClientConfig clientConfig, MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        PipelineConfigurator clientRequiredConfigurator;
        if (clientConfig.isReadTimeoutSet()) {
            ReadTimeoutPipelineConfigurator readTimeoutConfigurator = new ReadTimeoutPipelineConfigurator(clientConfig.getReadTimeoutInMillis(), TimeUnit.MILLISECONDS);
            clientRequiredConfigurator = new PipelineConfiguratorComposite(new ClientRequiredConfigurator(eventsSubject), readTimeoutConfigurator);
        } else {
            clientRequiredConfigurator = new ClientRequiredConfigurator(eventsSubject);
        }
        pipelineConfigurator = null != pipelineConfigurator ? new PipelineConfiguratorComposite(pipelineConfigurator, clientRequiredConfigurator) : clientRequiredConfigurator;
        return pipelineConfigurator;
    }

    public static PipelineConfigurator<ByteBuf, ByteBuf> empty() {
        return EMPTY_CONFIGURATOR;
    }
}

