/*
 * Decompiled with CFR 0.152.
 */
package com.eureka2.shading.reactivex.netty.pipeline;

import com.eureka2.shading.reactivex.netty.pipeline.PipelineConfigurator;
import com.eureka2.shading.reactivex.netty.protocol.http.client.ClientRequestResponseConverter;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ReadTimeoutPipelineConfigurator
implements PipelineConfigurator<Object, Object> {
    private static final Logger logger = LoggerFactory.getLogger(ReadTimeoutPipelineConfigurator.class);
    public static final String READ_TIMEOUT_HANDLER_NAME = "readtimeout-handler";
    public static final String READ_TIMEOUT_LIFECYCLE_MANAGER_HANDLER_NAME = "readtimeout-handler-lifecycle-manager";
    private final long timeout;
    private final TimeUnit timeUnit;

    public ReadTimeoutPipelineConfigurator(long timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    @Override
    public void configureNewPipeline(ChannelPipeline pipeline) {
        pipeline.addFirst(READ_TIMEOUT_LIFECYCLE_MANAGER_HANDLER_NAME, (ChannelHandler)new ReadTimeoutHandlerLifecycleManager());
    }

    public static void disableReadTimeout(ChannelPipeline pipeline) {
        final ChannelHandler timeoutHandler = pipeline.get(READ_TIMEOUT_HANDLER_NAME);
        if (timeoutHandler != null) {
            final ChannelHandlerContext handlerContext = pipeline.context(timeoutHandler);
            EventExecutor executor = handlerContext.executor();
            if (executor.inEventLoop()) {
                ReadTimeoutPipelineConfigurator.disableHandler(timeoutHandler, handlerContext);
            } else {
                executor.submit((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        ReadTimeoutPipelineConfigurator.disableHandler(timeoutHandler, handlerContext);
                        return null;
                    }
                });
            }
        }
    }

    private static void disableHandler(ChannelHandler timeoutHandler, ChannelHandlerContext handlerContext) {
        try {
            timeoutHandler.handlerRemoved(handlerContext);
        }
        catch (Exception e) {
            logger.error("Failed to remove readtimeout handler. This connection will be discarded.", (Throwable)e);
            handlerContext.channel().attr(ClientRequestResponseConverter.DISCARD_CONNECTION).set((Object)true);
        }
    }

    @ChannelHandler.Sharable
    private class ReadTimeoutHandlerLifecycleManager
    extends ChannelOutboundHandlerAdapter {
        private ReadTimeoutHandlerLifecycleManager() {
        }

        public void write(final ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            promise.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    ChannelHandler timeoutHandler = ctx.pipeline().get(ReadTimeoutPipelineConfigurator.READ_TIMEOUT_HANDLER_NAME);
                    if (null == timeoutHandler) {
                        ctx.pipeline().addFirst(ReadTimeoutPipelineConfigurator.READ_TIMEOUT_HANDLER_NAME, (ChannelHandler)new ReadTimeoutHandler(ReadTimeoutPipelineConfigurator.this.timeout, ReadTimeoutPipelineConfigurator.this.timeUnit));
                    } else {
                        ChannelHandlerContext handlerContext = ctx.pipeline().context(timeoutHandler);
                        timeoutHandler.handlerAdded(handlerContext);
                    }
                }
            });
            super.write(ctx, msg, promise);
        }
    }
}

