/*
 * Decompiled with CFR 0.152.
 */
package com.eureka2.shading.reactivex.netty.protocol.http.server;

import com.eureka2.shading.reactivex.netty.pipeline.PipelineConfigurator;
import com.eureka2.shading.reactivex.netty.pipeline.PipelineConfiguratorComposite;
import com.eureka2.shading.reactivex.netty.protocol.http.server.ErrorResponseGenerator;
import com.eureka2.shading.reactivex.netty.protocol.http.server.HttpConnectionHandler;
import com.eureka2.shading.reactivex.netty.protocol.http.server.HttpServerRequest;
import com.eureka2.shading.reactivex.netty.protocol.http.server.HttpServerResponse;
import com.eureka2.shading.reactivex.netty.protocol.http.server.RequestHandler;
import com.eureka2.shading.reactivex.netty.protocol.http.server.ServerRequiredConfigurator;
import com.eureka2.shading.reactivex.netty.server.ErrorHandler;
import com.eureka2.shading.reactivex.netty.server.RxServer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.List;

public class HttpServer<I, O>
extends RxServer<HttpServerRequest<I>, HttpServerResponse<O>> {
    private final HttpConnectionHandler<I, O> connectionHandler;

    public HttpServer(ServerBootstrap bootstrap, int port, PipelineConfigurator<HttpServerRequest<I>, HttpServerResponse<O>> pipelineConfigurator, RequestHandler<I, O> requestHandler) {
        this(bootstrap, port, pipelineConfigurator, requestHandler, null);
    }

    public HttpServer(ServerBootstrap bootstrap, int port, PipelineConfigurator<HttpServerRequest<I>, HttpServerResponse<O>> pipelineConfigurator, RequestHandler<I, O> requestHandler, EventExecutorGroup requestProcessingExecutor) {
        this(bootstrap, port, pipelineConfigurator, new HttpConnectionHandler<I, O>(requestHandler), requestProcessingExecutor, 1L);
    }

    protected HttpServer(ServerBootstrap bootstrap, int port, PipelineConfigurator<HttpServerRequest<I>, HttpServerResponse<O>> pipelineConfigurator, HttpConnectionHandler<I, O> connectionHandler) {
        this(bootstrap, port, pipelineConfigurator, connectionHandler, null, 1L);
    }

    protected HttpServer(ServerBootstrap bootstrap, int port, PipelineConfigurator<HttpServerRequest<I>, HttpServerResponse<O>> pipelineConfigurator, HttpConnectionHandler<I, O> connectionHandler, EventExecutorGroup requestProcessingExecutor, long requestContentSubscriptionTimeoutMs) {
        super(bootstrap, port, HttpServer.addRequiredConfigurator(pipelineConfigurator, requestProcessingExecutor, requestContentSubscriptionTimeoutMs), connectionHandler, requestProcessingExecutor);
        List<PipelineConfigurator> constituentConfigurators = ((PipelineConfiguratorComposite)this.pipelineConfigurator).getConstituentConfigurators();
        boolean updatedSubject = false;
        for (PipelineConfigurator configurator : constituentConfigurators) {
            if (!(configurator instanceof ServerRequiredConfigurator)) continue;
            updatedSubject = true;
            ServerRequiredConfigurator requiredConfigurator = (ServerRequiredConfigurator)configurator;
            requiredConfigurator.useMetricEventsSubject(this.eventsSubject);
        }
        if (!updatedSubject) {
            throw new IllegalStateException("No server required configurator added.");
        }
        connectionHandler.useMetricEventsSubject(this.eventsSubject);
        this.connectionHandler = connectionHandler;
    }

    public HttpServer<I, O> withErrorResponseGenerator(ErrorResponseGenerator<O> responseGenerator) {
        if (null == responseGenerator) {
            throw new IllegalArgumentException("Response generator can not be null.");
        }
        this.connectionHandler.setResponseGenerator(responseGenerator);
        return this;
    }

    @Override
    public HttpServer<I, O> start() {
        super.start();
        return this;
    }

    @Override
    public HttpServer<I, O> withErrorHandler(ErrorHandler errorHandler) {
        super.withErrorHandler(errorHandler);
        return this;
    }

    private static <I, O> PipelineConfigurator<HttpServerRequest<I>, HttpServerResponse<O>> addRequiredConfigurator(PipelineConfigurator<HttpServerRequest<I>, HttpServerResponse<O>> pipelineConfigurator, EventExecutorGroup requestProcessingExecutor, long requestContentSubscriptionTimeoutMs) {
        return new PipelineConfiguratorComposite<HttpServerRequest<I>, HttpServerResponse<O>>(pipelineConfigurator, new ServerRequiredConfigurator(requestProcessingExecutor, requestContentSubscriptionTimeoutMs));
    }
}

