/*
 * Decompiled with CFR 0.152.
 */
package com.eureka2.shading.reactivex.netty.protocol.http.websocket;

import com.eureka2.shading.reactivex.netty.RxNetty;
import com.eureka2.shading.reactivex.netty.channel.ObservableConnection;
import com.eureka2.shading.reactivex.netty.client.AbstractClientBuilder;
import com.eureka2.shading.reactivex.netty.client.ClientChannelFactory;
import com.eureka2.shading.reactivex.netty.client.ClientChannelFactoryImpl;
import com.eureka2.shading.reactivex.netty.client.ClientConnectionFactory;
import com.eureka2.shading.reactivex.netty.client.ClientMetricsEvent;
import com.eureka2.shading.reactivex.netty.client.UnpooledClientConnectionFactory;
import com.eureka2.shading.reactivex.netty.metrics.MetricEventsListener;
import com.eureka2.shading.reactivex.netty.metrics.MetricEventsListenerFactory;
import com.eureka2.shading.reactivex.netty.protocol.http.websocket.WebSocketClient;
import com.eureka2.shading.reactivex.netty.protocol.http.websocket.WebSocketClientPipelineConfigurator;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.URI;
import java.net.URISyntaxException;

public class WebSocketClientBuilder<I extends WebSocketFrame, O extends WebSocketFrame>
extends AbstractClientBuilder<I, O, WebSocketClientBuilder<I, O>, WebSocketClient<I, O>> {
    private URI webSocketURI = URI.create("/");
    private WebSocketVersion webSocketVersion = WebSocketVersion.V13;
    private boolean messageAggregation;
    private String subprotocol;
    private boolean allowExtensions;
    private int maxFramePayloadLength = 65536;

    public WebSocketClientBuilder(String host, int port) {
        this(host, port, new Bootstrap());
    }

    public WebSocketClientBuilder(String host, int port, Bootstrap bootstrap) {
        this(bootstrap, host, port, new UnpooledClientConnectionFactory(), new ClientChannelFactoryImpl(bootstrap));
    }

    public WebSocketClientBuilder(Bootstrap bootstrap, String host, int port, ClientConnectionFactory<O, I, ? extends ObservableConnection<O, I>> connectionFactory, ClientChannelFactory<O, I> factory) {
        super(bootstrap, host, port, connectionFactory, factory);
    }

    @Override
    protected Class<? extends SocketChannel> defaultSocketChannelClass() {
        if (RxNetty.isUsingNativeTransport()) {
            return EpollSocketChannel.class;
        }
        return super.defaultSocketChannelClass();
    }

    @Override
    protected EventLoopGroup defaultEventloop(Class<? extends Channel> socketChannel) {
        return RxNetty.getRxEventLoopProvider().globalClientEventLoop(true);
    }

    @Override
    protected WebSocketClient<I, O> createClient() {
        WebSocketClientPipelineConfigurator webSocketPipeline = new WebSocketClientPipelineConfigurator(this.webSocketURI, this.webSocketVersion, this.subprotocol, this.allowExtensions, this.maxFramePayloadLength, this.messageAggregation, this.eventsSubject);
        if (this.getPipelineConfigurator() != null) {
            this.appendPipelineConfigurator(webSocketPipeline);
        } else {
            this.pipelineConfigurator(webSocketPipeline);
        }
        return new WebSocketClient(this.getOrCreateName(), this.serverInfo, this.bootstrap, this.pipelineConfigurator, this.clientConfig, this.channelFactory, this.connectionFactory, this.eventsSubject);
    }

    @Override
    protected String generatedNamePrefix() {
        return "WebSocketClient-";
    }

    public WebSocketClientBuilder<I, O> withWebSocketURI(String uri) {
        try {
            this.webSocketURI = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    public WebSocketClientBuilder<I, O> withWebSocketVersion(WebSocketVersion version) {
        this.webSocketVersion = version;
        return this;
    }

    public WebSocketClientBuilder<I, O> withMessageAggregation(boolean messageAggregation) {
        this.messageAggregation = messageAggregation;
        return this;
    }

    public WebSocketClientBuilder<I, O> withSubprotocol(String subprotocol) {
        this.subprotocol = subprotocol;
        return this;
    }

    public WebSocketClientBuilder<I, O> allowExtensions(boolean allowExtensions) {
        this.allowExtensions = allowExtensions;
        return this;
    }

    public WebSocketClientBuilder<I, O> withMaxFramePayloadLength(int maxFramePayloadLength) {
        this.maxFramePayloadLength = maxFramePayloadLength;
        return this;
    }

    @Override
    protected MetricEventsListener<? extends ClientMetricsEvent<? extends Enum>> newMetricsListener(MetricEventsListenerFactory factory, WebSocketClient<I, O> client) {
        return factory.forWebSocketClient(client);
    }
}

