/*
 * Decompiled with CFR 0.152.
 */
package com.eureka2.shading.reactivex.netty.protocol.udp.server;

import com.eureka2.shading.reactivex.netty.channel.ConnectionHandler;
import com.eureka2.shading.reactivex.netty.metrics.MetricEventsListener;
import com.eureka2.shading.reactivex.netty.metrics.MetricEventsListenerFactory;
import com.eureka2.shading.reactivex.netty.pipeline.ssl.SSLEngineFactory;
import com.eureka2.shading.reactivex.netty.protocol.udp.server.UdpServer;
import com.eureka2.shading.reactivex.netty.server.AbstractServerBuilder;
import com.eureka2.shading.reactivex.netty.server.ServerMetricsEvent;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.nio.NioDatagramChannel;

public class UdpServerBuilder<I, O>
extends AbstractServerBuilder<I, O, Bootstrap, Channel, UdpServerBuilder<I, O>, UdpServer<I, O>> {
    public UdpServerBuilder(int port, ConnectionHandler<I, O> connectionHandler) {
        this(port, connectionHandler, new Bootstrap());
    }

    public UdpServerBuilder(int port, ConnectionHandler<I, O> connectionHandler, Bootstrap bootstrap) {
        super(port, bootstrap, connectionHandler);
    }

    @Override
    protected Class<? extends Channel> defaultServerChannelClass() {
        return NioDatagramChannel.class;
    }

    @Override
    public UdpServerBuilder<I, O> defaultChannelOptions() {
        this.channelOption(ChannelOption.SO_BROADCAST, true);
        return (UdpServerBuilder)super.defaultChannelOptions();
    }

    @Override
    public UdpServerBuilder<I, O> withSslEngineFactory(SSLEngineFactory sslEngineFactory) {
        throw new IllegalArgumentException("SSL protocol is not applicable to UDP ");
    }

    @Override
    protected UdpServer<I, O> createServer() {
        if (null != this.pipelineConfigurator) {
            return new UdpServer((Bootstrap)this.serverBootstrap, this.port, this.pipelineConfigurator, this.connectionHandler, this.eventExecutorGroup);
        }
        return new UdpServer((Bootstrap)this.serverBootstrap, this.port, this.connectionHandler, this.eventExecutorGroup);
    }

    @Override
    protected MetricEventsListener<ServerMetricsEvent<?>> newMetricsListener(MetricEventsListenerFactory factory, UdpServer<I, O> server) {
        return factory.forUdpServer(server);
    }
}

