/*
 * Decompiled with CFR 0.152.
 */
package com.eureka2.shading.tukaani.xz;

import com.eureka2.shading.tukaani.xz.BlockInputStream;
import com.eureka2.shading.tukaani.xz.CorruptedInputException;
import com.eureka2.shading.tukaani.xz.IndexIndicatorException;
import com.eureka2.shading.tukaani.xz.MemoryLimitException;
import com.eureka2.shading.tukaani.xz.SeekableInputStream;
import com.eureka2.shading.tukaani.xz.UnsupportedOptionsException;
import com.eureka2.shading.tukaani.xz.XZ;
import com.eureka2.shading.tukaani.xz.XZFormatException;
import com.eureka2.shading.tukaani.xz.XZIOException;
import com.eureka2.shading.tukaani.xz.check.Check;
import com.eureka2.shading.tukaani.xz.common.DecoderUtil;
import com.eureka2.shading.tukaani.xz.common.StreamFlags;
import com.eureka2.shading.tukaani.xz.index.BlockInfo;
import com.eureka2.shading.tukaani.xz.index.IndexDecoder;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class SeekableXZInputStream
extends SeekableInputStream {
    private SeekableInputStream in;
    private final int memoryLimit;
    private int indexMemoryUsage = 0;
    private final ArrayList streams = new ArrayList();
    private IndexDecoder index;
    private int checkTypes = 0;
    private Check check;
    private BlockInputStream blockDecoder = null;
    private long uncompressedSize = 0L;
    private long largestBlockSize = 0L;
    private long curPos = 0L;
    private long seekPos;
    private boolean seekNeeded = false;
    private boolean endReached = false;
    private IOException exception = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SeekableXZInputStream(SeekableInputStream seekableInputStream) throws IOException {
        this(seekableInputStream, -1);
    }

    public SeekableXZInputStream(SeekableInputStream seekableInputStream, int n) throws IOException {
        this.in = seekableInputStream;
        DataInputStream dataInputStream = new DataInputStream(seekableInputStream);
        seekableInputStream.seek(0L);
        byte[] byArray = new byte[XZ.HEADER_MAGIC.length];
        dataInputStream.readFully(byArray);
        if (!Arrays.equals(byArray, XZ.HEADER_MAGIC)) {
            throw new XZFormatException();
        }
        long l = seekableInputStream.length();
        if ((l & 3L) != 0L) {
            throw new CorruptedInputException("XZ file size is not a multiple of 4 bytes");
        }
        byte[] byArray2 = new byte[12];
        long l2 = 0L;
        while (l > 0L) {
            long l3;
            if (l < 12L) {
                throw new CorruptedInputException();
            }
            seekableInputStream.seek(l - 12L);
            dataInputStream.readFully(byArray2);
            if (byArray2[8] == 0 && byArray2[9] == 0 && byArray2[10] == 0 && byArray2[11] == 0) {
                l2 += 4L;
                l -= 4L;
                continue;
            }
            StreamFlags streamFlags = DecoderUtil.decodeStreamFooter(byArray2);
            if (streamFlags.backwardSize >= (l -= 12L)) {
                throw new CorruptedInputException("Backward Size in XZ Stream Footer is too big");
            }
            this.check = Check.getInstance(streamFlags.checkType);
            this.checkTypes |= 1 << streamFlags.checkType;
            seekableInputStream.seek(l - streamFlags.backwardSize);
            try {
                this.index = new IndexDecoder(seekableInputStream, streamFlags, l2, n);
            }
            catch (MemoryLimitException memoryLimitException) {
                if (!$assertionsDisabled && n < 0) {
                    throw new AssertionError();
                }
                throw new MemoryLimitException(memoryLimitException.getMemoryNeeded() + this.indexMemoryUsage, n + this.indexMemoryUsage);
            }
            this.indexMemoryUsage += this.index.getMemoryUsage();
            if (n >= 0 && !$assertionsDisabled && (n -= this.index.getMemoryUsage()) < 0) {
                throw new AssertionError();
            }
            if (this.largestBlockSize < this.index.getLargestBlockSize()) {
                this.largestBlockSize = this.index.getLargestBlockSize();
            }
            if (l < (l3 = this.index.getStreamSize() - 12L)) {
                throw new CorruptedInputException("XZ Index indicates too big compressed size for the XZ Stream");
            }
            seekableInputStream.seek(l -= l3);
            dataInputStream.readFully(byArray2);
            StreamFlags streamFlags2 = DecoderUtil.decodeStreamHeader(byArray2);
            if (!DecoderUtil.areStreamFlagsEqual(streamFlags2, streamFlags)) {
                throw new CorruptedInputException("XZ Stream Footer does not match Stream Header");
            }
            this.uncompressedSize += this.index.getUncompressedSize();
            if (this.uncompressedSize < 0L) {
                throw new UnsupportedOptionsException("XZ file is too big");
            }
            this.streams.add(this.index);
            l2 = 0L;
        }
        if (!$assertionsDisabled && l != 0L) {
            throw new AssertionError();
        }
        this.memoryLimit = n;
    }

    public int getCheckTypes() {
        return this.checkTypes;
    }

    public int getIndexMemoryUsage() {
        return this.indexMemoryUsage;
    }

    public long getLargestBlockSize() {
        return this.largestBlockSize;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        return this.read(byArray, 0, 1) == -1 ? -1 : byArray[0] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        block13: {
            if (n < 0 || n2 < 0 || n + n2 < 0 || n + n2 > byArray.length) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            if (this.in == null) {
                throw new XZIOException("Stream closed");
            }
            if (this.exception != null) {
                throw this.exception;
            }
            n3 = 0;
            try {
                if (this.seekNeeded) {
                    this.seek();
                }
                if (this.endReached) {
                    return -1;
                }
                while (n2 > 0) {
                    int n4;
                    if (this.blockDecoder == null) {
                        this.seek();
                        if (this.endReached) break;
                    }
                    if ((n4 = this.blockDecoder.read(byArray, n, n2)) > 0) {
                        this.curPos += (long)n4;
                        n3 += n4;
                        n += n4;
                        n2 -= n4;
                        continue;
                    }
                    if (n4 != -1) continue;
                    this.blockDecoder = null;
                }
            }
            catch (IOException iOException) {
                CorruptedInputException corruptedInputException;
                if (iOException instanceof EOFException) {
                    corruptedInputException = new CorruptedInputException();
                }
                this.exception = corruptedInputException;
                if (n3 != 0) break block13;
                throw corruptedInputException;
            }
        }
        return n3;
    }

    public int available() throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.endReached || this.seekNeeded || this.blockDecoder == null) {
            return 0;
        }
        return this.blockDecoder.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.in != null) {
            try {
                this.in.close();
            }
            finally {
                this.in = null;
            }
        }
    }

    public long length() {
        return this.uncompressedSize;
    }

    public long position() throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        return this.seekNeeded ? this.seekPos : this.curPos;
    }

    public void seek(long l) throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (l < 0L) {
            throw new XZIOException("Negative seek position: " + l);
        }
        this.seekPos = l;
        this.seekNeeded = true;
    }

    private void seek() throws IOException {
        long l;
        long l2;
        long l3;
        block10: {
            if (!this.seekNeeded) {
                if (this.index.hasNext()) {
                    BlockInfo blockInfo = this.index.getNext();
                    this.initBlockDecoder(blockInfo);
                    return;
                }
                this.seekPos = this.curPos;
            }
            this.seekNeeded = false;
            if (this.seekPos >= this.uncompressedSize) {
                this.curPos = this.seekPos;
                this.blockDecoder = null;
                this.endReached = true;
                return;
            }
            this.endReached = false;
            int n = this.streams.size();
            if (!$assertionsDisabled && n < 1) {
                throw new AssertionError();
            }
            l3 = 0L;
            l2 = 0L;
            do {
                this.index = (IndexDecoder)this.streams.get(--n);
                if (l3 + this.index.getUncompressedSize() > this.seekPos) break block10;
                l3 += this.index.getUncompressedSize();
            } while ($assertionsDisabled || ((l2 += this.index.getStreamAndPaddingSize()) & 3L) == 0L);
            throw new AssertionError();
        }
        BlockInfo blockInfo = this.index.locate(this.seekPos - l3);
        if (!$assertionsDisabled && (blockInfo.compressedOffset & 3L) != 0L) {
            throw new AssertionError(blockInfo.compressedOffset);
        }
        blockInfo.compressedOffset += l2;
        blockInfo.uncompressedOffset += l3;
        if (!$assertionsDisabled && this.seekPos < blockInfo.uncompressedOffset) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.seekPos >= blockInfo.uncompressedOffset + blockInfo.uncompressedSize) {
            throw new AssertionError();
        }
        if (this.curPos <= blockInfo.uncompressedOffset || this.curPos > this.seekPos) {
            this.in.seek(blockInfo.compressedOffset);
            this.check = Check.getInstance(blockInfo.streamFlags.checkType);
            this.initBlockDecoder(blockInfo);
            this.curPos = blockInfo.uncompressedOffset;
        }
        if (this.seekPos > this.curPos && this.blockDecoder.skip(l = this.seekPos - this.curPos) != l) {
            throw new CorruptedInputException();
        }
        this.curPos = this.seekPos;
    }

    private void initBlockDecoder(BlockInfo blockInfo) throws IOException {
        try {
            this.blockDecoder = null;
            this.blockDecoder = new BlockInputStream(this.in, this.check, this.memoryLimit, blockInfo.unpaddedSize, blockInfo.uncompressedSize);
        }
        catch (MemoryLimitException memoryLimitException) {
            if (!$assertionsDisabled && this.memoryLimit < 0) {
                throw new AssertionError();
            }
            throw new MemoryLimitException(memoryLimitException.getMemoryNeeded() + this.indexMemoryUsage, this.memoryLimit + this.indexMemoryUsage);
        }
        catch (IndexIndicatorException indexIndicatorException) {
            throw new CorruptedInputException();
        }
    }

    static {
        $assertionsDisabled = !SeekableXZInputStream.class.desiredAssertionStatus();
    }
}

